import java.io.*;

/**
Quelle: Gerhard Rhner, http://javaeditor.org/wiki/index.php/Examples/de
Support class for console input and output of numeric values.<br><br>
*/
  

public class Einlesen {

  /** Reads a boolean-value from console. */
  public static boolean Boolean() {
    final String[] trueValues =
          { "1", "y", "t", "j", "w", "yes", "true", "ja", "wahr", "ok" };
    String input = readln().toLowerCase();
    for (int i = 0; i < trueValues.length; ++i)
      if (trueValues[i].equals(input))
        return true;
    return false;
  }

  /** Reads a char-value from console. */
  public static char Char() {
    return readln().charAt(0);
  }

  /** Reads a double-value from console. */
  public static double Double() {
    return Double.parseDouble(readln());
  }

  /** Reads a float-value from console. */
  public static float Float() {
    return Float.parseFloat(readln());
  }

  /** Reads an int-value from console. */
  public static int Int() {
    return Integer.parseInt(readln());
  }

  /** Reads a long-value from console. */
  public static long Long () {
    return Long.parseLong(readln());
  }

  /** Reads a string-value from console. */
  public static String String() {
    return readln();
  }

  private static BufferedReader Input;

  static {
    try {
      Input = new BufferedReader(new InputStreamReader(System.in));
    }
    catch (Exception e) {
      System.out.println("\nFehler beim Einlesen von der Konsole.\n");
    }
  }

  private static String readln () {
    try {
      return Input.readLine();
    } catch(Exception e) {
      return "";
    }
  }

}
