/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.GeneralNameInterface;

public class OIDName
implements GeneralNameInterface {
    private ObjectIdentifier oid;

    public int getType() {
        return 8;
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not supported for OIDName.");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OIDName)) {
            return false;
        }
        OIDName oIDName = (OIDName)object;
        return this.oid.equals(oIDName.oid);
    }

    public String toString() {
        return "OIDName: " + this.oid.toString();
    }

    public OIDName(String string) throws IOException {
        try {
            this.oid = new ObjectIdentifier(string);
        }
        catch (Exception exception) {
            throw new IOException("Unable to create OIDName: " + exception);
        }
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOID(this.oid);
    }

    public OIDName(DerValue derValue) throws IOException {
        this.oid = derValue.getOID();
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public OIDName(ObjectIdentifier objectIdentifier) {
        this.oid = objectIdentifier;
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n2;
        if (generalNameInterface == null) {
            n2 = -1;
        } else if (generalNameInterface.getType() != 8) {
            n2 = -1;
        } else if (this.equals((OIDName)generalNameInterface)) {
            n2 = 0;
        } else {
            throw new UnsupportedOperationException("Narrowing and widening are not supported for OIDNames");
        }
        return n2;
    }
}

