/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Util;

class Net {
    static {
        Util.load();
        Net.initIDs();
    }

    private Net() {
    }

    private static native void initIDs();

    private static native int socket0(boolean var0, boolean var1);

    private static native int localPort(FileDescriptor var0) throws IOException;

    static int localPortNumber(FileDescriptor fileDescriptor) {
        try {
            return Net.localPort(fileDescriptor);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    static int getIntOption(FileDescriptor fileDescriptor, int n2) throws IOException {
        return Net.getIntOption0(fileDescriptor, n2);
    }

    private static native int getIntOption0(FileDescriptor var0, int var1) throws IOException;

    static void setIntOption(FileDescriptor fileDescriptor, int n2, int n3) throws IOException {
        Net.setIntOption0(fileDescriptor, n2, n3);
    }

    private static native void setIntOption0(FileDescriptor var0, int var1, int var2) throws IOException;

    static FileDescriptor serverSocket(boolean bl2) {
        return IOUtil.newFD(Net.socket0(bl2, true));
    }

    static FileDescriptor socket(boolean bl2) {
        return IOUtil.newFD(Net.socket0(bl2, false));
    }

    static void translateException(Exception exception) throws IOException {
        Net.translateException(exception, false);
    }

    static void translateToSocketException(Exception exception) throws SocketException {
        Net.translateToSocketException(exception, false);
    }

    static void translateException(Exception exception, boolean bl2) throws IOException {
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        Net.translateToSocketException(exception, bl2);
    }

    static void translateToSocketException(Exception exception, boolean bl2) throws SocketException {
        if (exception instanceof SocketException) {
            throw (SocketException)exception;
        }
        Exception exception2 = exception;
        if (exception instanceof ClosedChannelException) {
            exception2 = new SocketException("Socket is closed");
        } else if (exception instanceof AlreadyBoundException) {
            exception2 = new SocketException("Already bound");
        } else if (exception instanceof NotYetBoundException) {
            exception2 = new SocketException("Socket is not bound yet");
        } else if (exception instanceof UnsupportedAddressTypeException) {
            exception2 = new SocketException("Unsupported address type");
        } else if (exception instanceof UnresolvedAddressException) {
            exception2 = bl2 ? new UnknownHostException() : new SocketException("Unresolved address");
        }
        if (exception2 == exception) {
            if (exception2 instanceof RuntimeException) {
                throw (RuntimeException)exception2;
            }
            throw new Error("Untranslated exception", exception2);
        }
        exception2.initCause(exception);
    }

    private static native InetAddress localInetAddress(FileDescriptor var0) throws IOException;

    static native void bind(FileDescriptor var0, InetAddress var1, int var2) throws IOException;

    static native int connect(FileDescriptor var0, InetAddress var1, int var2, int var3) throws IOException;

    static InetSocketAddress localAddress(FileDescriptor fileDescriptor) {
        try {
            return new InetSocketAddress(Net.localInetAddress(fileDescriptor), Net.localPort(fileDescriptor));
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    static InetSocketAddress asInetSocketAddress(SocketAddress socketAddress) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        return (InetSocketAddress)socketAddress;
    }

    static InetSocketAddress checkAddress(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new IllegalArgumentException();
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        return inetSocketAddress;
    }
}

