/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.AlphaComposite;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.Region;
import sun.security.action.GetPropertyAction;

public abstract class GraphicsPrimitive {
    private String methodSignature;
    private int uniqueID;
    private static int unusedPrimID = 1;
    private SurfaceType sourceType;
    private CompositeType compositeType;
    private SurfaceType destType;
    private long pNativePrim;
    static HashMap traceMap;
    public static int traceflags;
    public static String tracefile;
    public static PrintStream traceout;
    public static final int TRACELOG = 1;
    public static final int TRACETIMESTAMP = 2;
    public static final int TRACECOUNTS = 4;
    private String cachedname;

    public final int getPrimTypeID() {
        return this.uniqueID >>> 24;
    }

    public final int getUniqueID() {
        return this.uniqueID;
    }

    public static final synchronized int makePrimTypeID() {
        if (unusedPrimID > 255) {
            throw new InternalError("primitive id overflow");
        }
        return unusedPrimID++;
    }

    static {
        GetPropertyAction getPropertyAction = new GetPropertyAction("sun.java2d.trace");
        String string = (String)AccessController.doPrivileged(getPropertyAction);
        if (string != null) {
            boolean bl2 = false;
            int n2 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("count")) {
                    n2 |= 4;
                    continue;
                }
                if (string2.equalsIgnoreCase("log")) {
                    n2 |= 1;
                    continue;
                }
                if (string2.equalsIgnoreCase("timestamp")) {
                    n2 |= 2;
                    continue;
                }
                if (string2.equalsIgnoreCase("verbose")) {
                    bl2 = true;
                    continue;
                }
                if (string2.regionMatches(true, 0, "out:", 0, 4)) {
                    tracefile = string2.substring(4);
                    continue;
                }
                if (!string2.equalsIgnoreCase("help")) {
                    System.err.println("unrecognized token: " + string2);
                }
                System.err.println("usage: -Dsun.java2d.trace=[log[,timestamp]],[count],[out:<filename>],[help],[verbose]");
            }
            if (bl2) {
                System.err.print("GraphicsPrimitive logging ");
                if ((n2 & 1) != 0) {
                    System.err.println("enabled");
                    System.err.print("GraphicsPrimitive timetamps ");
                    if ((n2 & 2) != 0) {
                        System.err.println("enabled");
                    } else {
                        System.err.println("disabled");
                    }
                } else {
                    System.err.println("[and timestamps] disabled");
                }
                System.err.print("GraphicsPrimitive invocation counts ");
                if ((n2 & 4) != 0) {
                    System.err.println("enabled");
                } else {
                    System.err.println("disabled");
                }
                System.err.print("GraphicsPrimitive trace output to ");
                if (tracefile == null) {
                    System.err.println("System.err");
                } else {
                    System.err.println("file '" + tracefile + "'");
                }
            }
            traceflags = n2;
        }
    }

    public static boolean tracingEnabled() {
        return traceflags != 0;
    }

    private static PrintStream getTraceOutputFile() {
        if (traceout == null) {
            Object object;
            traceout = tracefile != null ? ((object = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return new FileOutputStream(tracefile);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return null;
                    }
                }
            })) != null ? new PrintStream((OutputStream)object) : System.err) : System.err;
        }
        return traceout;
    }

    public static synchronized void tracePrimitive(Object object) {
        Object object2;
        if ((traceflags & 4) != 0) {
            if (traceMap == null) {
                traceMap = new HashMap();
                TraceReporter.setShutdownHook();
            }
            if ((object2 = traceMap.get(object)) == null) {
                object2 = new int[1];
                traceMap.put(object, object2);
            }
            int[] nArray = (int[])object2;
            nArray[0] = nArray[0] + 1;
        }
        if ((traceflags & 1) != 0) {
            object2 = GraphicsPrimitive.getTraceOutputFile();
            if ((traceflags & 2) != 0) {
                ((PrintStream)object2).print(System.currentTimeMillis() + ": ");
            }
            ((PrintStream)object2).println(object);
        }
    }

    public final String getSignature() {
        return this.methodSignature;
    }

    public String toString() {
        if (this.cachedname == null) {
            String string = this.methodSignature;
            int n2 = string.indexOf(40);
            if (n2 >= 0) {
                string = string.substring(0, n2);
            }
            this.cachedname = this.getClass().getName() + "::" + string + "(" + GraphicsPrimitive.simplename(this.sourceType) + ", " + GraphicsPrimitive.simplename(this.compositeType) + ", " + GraphicsPrimitive.simplename(this.destType) + ")";
        }
        return this.cachedname;
    }

    public final CompositeType getCompositeType() {
        return this.compositeType;
    }

    public abstract GraphicsPrimitive traceWrap();

    final boolean satisfiesSameAs(GraphicsPrimitive graphicsPrimitive) {
        return this.methodSignature == graphicsPrimitive.methodSignature && this.sourceType.equals(graphicsPrimitive.sourceType) && this.compositeType.equals(graphicsPrimitive.compositeType) && this.destType.equals(graphicsPrimitive.destType);
    }

    protected void setupGeneralBinaryOp(GeneralBinaryOp generalBinaryOp) {
        Blit blit;
        Blit blit2;
        int n2 = generalBinaryOp.getPrimTypeID();
        String string = generalBinaryOp.getSignature();
        SurfaceType surfaceType = generalBinaryOp.getSourceType();
        CompositeType compositeType = generalBinaryOp.getCompositeType();
        SurfaceType surfaceType2 = generalBinaryOp.getDestType();
        Blit blit3 = GraphicsPrimitive.createConverter(surfaceType, SurfaceType.IntArgb);
        GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locatePrim(n2, SurfaceType.IntArgb, compositeType, surfaceType2);
        if (graphicsPrimitive != null) {
            blit2 = null;
            blit = null;
        } else {
            graphicsPrimitive = GraphicsPrimitive.getGeneralOp(n2, compositeType);
            if (graphicsPrimitive == null) {
                throw new InternalError("Cannot construct general op for " + string + " " + compositeType);
            }
            blit2 = GraphicsPrimitive.createConverter(surfaceType2, SurfaceType.IntArgb);
            blit = GraphicsPrimitive.createConverter(SurfaceType.IntArgb, surfaceType2);
        }
        generalBinaryOp.setPrimitives(blit3, blit2, graphicsPrimitive, blit);
    }

    protected void setupGeneralUnaryOp(GeneralUnaryOp generalUnaryOp) {
        int n2 = generalUnaryOp.getPrimTypeID();
        String string = generalUnaryOp.getSignature();
        CompositeType compositeType = generalUnaryOp.getCompositeType();
        SurfaceType surfaceType = generalUnaryOp.getDestType();
        Blit blit = GraphicsPrimitive.createConverter(surfaceType, SurfaceType.IntArgb);
        GraphicsPrimitive graphicsPrimitive = GraphicsPrimitive.getGeneralOp(n2, compositeType);
        Blit blit2 = GraphicsPrimitive.createConverter(SurfaceType.IntArgb, surfaceType);
        if (blit == null || graphicsPrimitive == null || blit2 == null) {
            throw new InternalError("Cannot construct binary op for " + compositeType + " " + surfaceType);
        }
        generalUnaryOp.setPrimitives(blit, graphicsPrimitive, blit2);
    }

    public final SurfaceType getDestType() {
        return this.destType;
    }

    public final SurfaceType getSourceType() {
        return this.sourceType;
    }

    public static String simplename(CompositeType compositeType) {
        return GraphicsPrimitive.simplename(CompositeType.class.getDeclaredFields(), compositeType);
    }

    public static String simplename(SurfaceType surfaceType) {
        return GraphicsPrimitive.simplename(SurfaceType.class.getDeclaredFields(), surfaceType);
    }

    protected static GraphicsPrimitive getGeneralOp(int n2, CompositeType compositeType) {
        return GraphicsPrimitiveMgr.locatePrim(n2, SurfaceType.IntArgb, compositeType, SurfaceType.IntArgb);
    }

    public static String simplename(Field[] fieldArray, Object object) {
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            Field field = fieldArray[i2];
            try {
                if (object != field.get(null)) continue;
                return field.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "\"" + object.toString() + "\"";
    }

    protected static Blit createConverter(SurfaceType surfaceType, SurfaceType surfaceType2) {
        if (surfaceType.equals(surfaceType2)) {
            return null;
        }
        Blit blit = Blit.getFromCache(surfaceType, CompositeType.SrcNoEa, surfaceType2);
        if (blit == null) {
            throw new InternalError("Cannot construct converter for " + surfaceType + "=>" + surfaceType2);
        }
        return blit;
    }

    public static final synchronized int makeUniqueID(int n2, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        return n2 << 24 | surfaceType2.getUniqueID() << 16 | compositeType.getUniqueID() << 8 | surfaceType.getUniqueID();
    }

    protected static SurfaceData convertFrom(Blit blit, SurfaceData surfaceData, int n2, int n3, int n4, int n5, SurfaceData surfaceData2) {
        Object object;
        if (surfaceData2 != null) {
            object = surfaceData2.getBounds();
            if (n4 > ((Rectangle)object).width || n5 > ((Rectangle)object).height) {
                surfaceData2 = null;
            }
        }
        if (surfaceData2 == null) {
            object = new BufferedImage(n4, n5, 2);
            surfaceData2 = BufImgSurfaceData.createData((BufferedImage)object);
        }
        blit.Blit(surfaceData, surfaceData2, AlphaComposite.Src, null, n2, n3, 0, 0, n4, n5);
        return surfaceData2;
    }

    public abstract GraphicsPrimitive makePrimitive(SurfaceType var1, CompositeType var2, SurfaceType var3);

    protected GraphicsPrimitive(long l2, String string, int n2, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        this.pNativePrim = l2;
        this.methodSignature = string;
        this.sourceType = surfaceType;
        this.compositeType = compositeType;
        this.destType = surfaceType2;
        this.uniqueID = surfaceType == null || compositeType == null || surfaceType2 == null ? n2 << 24 : GraphicsPrimitive.makeUniqueID(n2, surfaceType, compositeType, surfaceType2);
    }

    protected GraphicsPrimitive(String string, int n2, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        this.methodSignature = string;
        this.sourceType = surfaceType;
        this.compositeType = compositeType;
        this.destType = surfaceType2;
        this.uniqueID = surfaceType == null || compositeType == null || surfaceType2 == null ? n2 << 24 : GraphicsPrimitive.makeUniqueID(n2, surfaceType, compositeType, surfaceType2);
    }

    public final boolean satisfies(String string, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        if (string != this.methodSignature) {
            return false;
        }
        while (true) {
            if (surfaceType == null) {
                return false;
            }
            if (surfaceType.equals(this.sourceType)) break;
            surfaceType = surfaceType.getSuperType();
        }
        while (true) {
            if (compositeType == null) {
                return false;
            }
            if (compositeType.equals(this.compositeType)) break;
            compositeType = compositeType.getSuperType();
        }
        while (true) {
            if (surfaceType2 == null) {
                return false;
            }
            if (surfaceType2.equals(this.destType)) break;
            surfaceType2 = surfaceType2.getSuperType();
        }
        return true;
    }

    protected static void convertTo(Blit blit, SurfaceData surfaceData, SurfaceData surfaceData2, Region region, int n2, int n3, int n4, int n5) {
        if (blit != null) {
            blit.Blit(surfaceData, surfaceData2, AlphaComposite.Src, region, 0, 0, n2, n3, n4, n5);
        }
    }

    protected static interface GeneralBinaryOp {
        public int getPrimTypeID();

        public String getSignature();

        public CompositeType getCompositeType();

        public SurfaceType getDestType();

        public SurfaceType getSourceType();

        public void setPrimitives(Blit var1, Blit var2, GraphicsPrimitive var3, Blit var4);
    }

    protected static interface GeneralUnaryOp {
        public int getPrimTypeID();

        public String getSignature();

        public CompositeType getCompositeType();

        public SurfaceType getDestType();

        public void setPrimitives(Blit var1, GraphicsPrimitive var2, Blit var3);
    }

    public static class TraceReporter
    extends Thread {
        public void run() {
            PrintStream printStream = GraphicsPrimitive.getTraceOutputFile();
            Iterator iterator = traceMap.entrySet().iterator();
            long l2 = 0L;
            int n2 = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object object = entry.getKey();
                int[] nArray = (int[])entry.getValue();
                if (nArray[0] == 1) {
                    printStream.print("1 call to ");
                } else {
                    printStream.print(nArray[0] + " calls to ");
                }
                printStream.println(object);
                ++n2;
                l2 += (long)nArray[0];
            }
            if (n2 == 0) {
                printStream.println("No graphics primitives executed");
            } else if (n2 > 1) {
                printStream.println(l2 + " total calls to " + n2 + " different primitives");
            }
        }

        public static void setShutdownHook() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Runtime.getRuntime().addShutdownHook(new TraceReporter());
                    return null;
                }
            });
        }
    }
}

