/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import java.util.Locale;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XString
extends XObject
implements XMLString {
    public static XString EMPTYSTRING = new XString("");

    public double num() {
        return this.toDouble();
    }

    public double toDouble() {
        char c2;
        int n2 = this.length();
        if (0 == n2) {
            return Double.NaN;
        }
        double d2 = 0.0;
        int n3 = 0;
        int n4 = n2 - 1;
        for (int i2 = n3; i2 < n2 && XMLCharacterRecognizer.isWhiteSpace(c2 = this.charAt(i2)); ++i2) {
            ++n3;
        }
        double d3 = 1.0;
        if (n3 < n2 && this.charAt(n3) == '-') {
            d3 = -1.0;
            ++n3;
        }
        int n5 = 0;
        for (int i3 = n3; i3 < n2; ++i3) {
            char c3 = this.charAt(i3);
            if (c3 != '.') {
                if (XMLCharacterRecognizer.isWhiteSpace(c3)) break;
                if (Character.isDigit(c3)) {
                    d2 = d2 * 10.0 + (double)(c3 - 48);
                    ++n5;
                    continue;
                }
                return Double.NaN;
            }
            n4 = i3;
            break;
        }
        if (this.charAt(n4) == '.') {
            char c4;
            double d4 = 0.0;
            for (int i4 = n2 - 1; i4 > n4 && !XMLCharacterRecognizer.isWhiteSpace(c4 = this.charAt(i4)); --i4) {
                if (Character.isDigit(c4)) {
                    d4 = d4 / 10.0 + (double)(c4 - 48);
                    ++n5;
                    continue;
                }
                return Double.NaN;
            }
            d2 += d4 / 10.0;
        }
        if (0 == n5) {
            return Double.NaN;
        }
        return d2 * d3;
    }

    public int getType() {
        return 3;
    }

    public int hashCode() {
        return this.str().hashCode();
    }

    public int length() {
        return this.str().length();
    }

    public boolean bool() {
        return this.str().length() > 0;
    }

    public boolean hasString() {
        return true;
    }

    private static boolean isSpace(char c2) {
        return XMLCharacterRecognizer.isWhiteSpace(c2);
    }

    public char charAt(int n2) {
        return this.str().charAt(n2);
    }

    public int indexOf(int n2) {
        return this.str().indexOf(n2);
    }

    public int lastIndexOf(int n2) {
        return this.str().lastIndexOf(n2);
    }

    public int indexOf(int n2, int n3) {
        return this.str().indexOf(n2, n3);
    }

    public int lastIndexOf(int n2, int n3) {
        return this.str().lastIndexOf(n2, n3);
    }

    public void getChars(int n2, int n3, char[] cArray, int n4) {
        this.str().getChars(n2, n3, cArray, n4);
    }

    protected XString(Object object) {
        super(object);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (object instanceof XNodeSet) {
            return object.equals(this);
        }
        if (object instanceof XNumber) {
            return object.equals(this);
        }
        return this.str().equals(object.toString());
    }

    public String getTypeString() {
        return "#STRING";
    }

    public String str() {
        return null != this.m_obj ? (String)this.m_obj : "";
    }

    public int indexOf(String string) {
        return this.str().indexOf(string);
    }

    public int lastIndexOf(String string) {
        return this.str().lastIndexOf(string);
    }

    public XString(String string) {
        super(string);
    }

    public boolean endsWith(String string) {
        return this.str().endsWith(string);
    }

    public boolean equalsIgnoreCase(String string) {
        return this.str().equalsIgnoreCase(string);
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public int indexOf(String string, int n2) {
        return this.str().indexOf(string, n2);
    }

    public int lastIndexOf(String string, int n2) {
        return this.str().lastIndexOf(string, n2);
    }

    public boolean startsWith(String string, int n2) {
        return this.str().startsWith(string, n2);
    }

    public XMLString toLowerCase() {
        return new XString(this.str().toLowerCase());
    }

    public XMLString toUpperCase() {
        return new XString(this.str().toUpperCase());
    }

    public XMLString trim() {
        return new XString(this.str().trim());
    }

    public XMLString xstr() {
        return this;
    }

    public XMLString substring(int n2) {
        return new XString(this.str().substring(n2));
    }

    public XMLString substring(int n2, int n3) {
        return new XString(this.str().substring(n2, n3));
    }

    public int compareTo(XMLString xMLString) {
        int n2 = this.length();
        int n3 = xMLString.length();
        int n4 = Math.min(n2, n3);
        int n5 = 0;
        int n6 = 0;
        while (n4-- != 0) {
            char c2;
            char c3 = this.charAt(n5);
            if (c3 != (c2 = xMLString.charAt(n6))) {
                return c3 - c2;
            }
            ++n5;
            ++n6;
        }
        return n2 - n3;
    }

    public int compareToIgnoreCase(XMLString xMLString) {
        throw new WrappedRuntimeException(new NoSuchMethodException("Java 1.2 method, not yet implemented"));
    }

    public int indexOf(XMLString xMLString) {
        return this.str().indexOf(((Object)xMLString).toString());
    }

    public boolean equals(XMLString xMLString) {
        if (!xMLString.hasString()) {
            return xMLString.equals(this);
        }
        return this.str().equals(((Object)xMLString).toString());
    }

    public boolean startsWith(XMLString xMLString) {
        return this.startsWith(xMLString, 0);
    }

    public boolean startsWith(XMLString xMLString, int n2) {
        int n3 = n2;
        int n4 = this.length();
        int n5 = 0;
        int n6 = xMLString.length();
        if (n2 < 0 || n2 > n4 - n6) {
            return false;
        }
        while (--n6 >= 0) {
            if (this.charAt(n3) != xMLString.charAt(n5)) {
                return false;
            }
            ++n3;
            ++n5;
        }
        return true;
    }

    public XMLString fixWhiteSpace(boolean bl2, boolean bl3, boolean bl4) {
        int n2;
        int n3;
        int n4 = this.length();
        char[] cArray = new char[n4];
        this.getChars(0, n4, cArray, 0);
        boolean bl5 = false;
        for (n3 = 0; n3 < n4 && !XString.isSpace(cArray[n3]); ++n3) {
        }
        int n5 = n3;
        boolean bl6 = false;
        while (n3 < n4) {
            n2 = cArray[n3];
            if (XString.isSpace((char)n2)) {
                if (!bl6) {
                    if (32 != n2) {
                        bl5 = true;
                    }
                    cArray[n5++] = 32;
                    if (bl4 && n3 != 0) {
                        char c2 = cArray[n3 - 1];
                        if (c2 != '.' && c2 != '!' && c2 != '?') {
                            bl6 = true;
                        }
                    } else {
                        bl6 = true;
                    }
                } else {
                    bl5 = true;
                    bl6 = true;
                }
            } else {
                cArray[n5++] = n2;
                bl6 = false;
            }
            ++n3;
        }
        if (bl3 && 1 <= n5 && ' ' == cArray[n5 - 1]) {
            bl5 = true;
            --n5;
        }
        n2 = 0;
        if (bl2 && 0 < n5 && ' ' == cArray[0]) {
            bl5 = true;
            ++n2;
        }
        XMLStringFactory xMLStringFactory = XMLStringFactoryImpl.getFactory();
        return bl5 ? xMLStringFactory.newstr(new String(cArray, n2, n5 - n2)) : this;
    }

    public int rtf(XPathContext xPathContext) {
        DTM dTM = xPathContext.createDocumentFragment();
        dTM.appendTextChild(this.str());
        return dTM.getDocument();
    }

    public boolean equals(XObject xObject) {
        int n2 = xObject.getType();
        try {
            if (4 == n2) {
                return xObject.equals(this);
            }
            if (1 == n2) {
                return xObject.bool() == this.bool();
            }
            if (2 == n2) {
                return xObject.num() == this.num();
            }
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
        return this.xstr().equals(xObject.xstr());
    }

    public void dispatchCharactersEvents(ContentHandler contentHandler) throws SAXException {
        String string = this.str();
        contentHandler.characters(string.toCharArray(), 0, string.length());
    }

    public void dispatchAsComment(LexicalHandler lexicalHandler) throws SAXException {
        String string = this.str();
        lexicalHandler.comment(string.toCharArray(), 0, string.length());
    }

    public XMLString concat(String string) {
        return new XString(this.str().concat(string));
    }

    public XMLString toLowerCase(Locale locale) {
        return new XString(this.str().toLowerCase(locale));
    }

    public XMLString toUpperCase(Locale locale) {
        return new XString(this.str().toUpperCase(locale));
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        xPathVisitor.visitStringLiteral(expressionOwner, this);
    }
}

