/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabStop;
import javax.swing.text.rtf.RTFAttribute;
import javax.swing.text.rtf.RTFAttributes;
import javax.swing.text.rtf.RTFReader;

class RTFGenerator {
    Dictionary colorTable = new Hashtable();
    int colorCount;
    Dictionary fontTable;
    int fontCount;
    Dictionary styleTable;
    int styleCount;
    OutputStream outputStream;
    boolean afterKeyword;
    MutableAttributeSet outputAttributes;
    int unicodeCount;
    private Segment workingSegment;
    int[] outputConversion;
    public static final Color defaultRTFColor = Color.black;
    public static final float defaultFontSize = 12.0f;
    public static final String defaultFontFamily = "Helvetica";
    protected static Integer One = new Integer(1);
    protected static Integer Zero = new Integer(0);
    protected static Boolean False = false;
    protected static Float ZeroPointZero;
    private static Object MagicToken;
    protected static CharacterKeywordPair[] textKeywords;
    static final char[] hexdigits;

    static {
        MagicToken = new Object();
        ZeroPointZero = new Float(0.0f);
        Dictionary dictionary = RTFReader.textKeywords;
        Enumeration enumeration = dictionary.keys();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            CharacterKeywordPair characterKeywordPair = new CharacterKeywordPair();
            characterKeywordPair.keyword = (String)enumeration.nextElement();
            characterKeywordPair.character = ((String)dictionary.get(characterKeywordPair.keyword)).charAt(0);
            vector.addElement(characterKeywordPair);
        }
        textKeywords = new CharacterKeywordPair[vector.size()];
        vector.copyInto(textKeywords);
        hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public void writeBegingroup() throws IOException {
        this.outputStream.write(123);
        this.afterKeyword = false;
    }

    public void writeEndgroup() throws IOException {
        this.outputStream.write(125);
        this.afterKeyword = false;
    }

    public void writeLineBreak() throws IOException {
        this.writeRawString("\n");
        this.afterKeyword = false;
    }

    public void writeRTFHeader() throws IOException {
        Object object;
        Object object2;
        int n2;
        Object object3;
        this.writeBegingroup();
        this.writeControlWord("rtf", 1);
        this.writeControlWord("ansi");
        this.outputConversion = RTFGenerator.outputConversionForName("ansi");
        this.writeLineBreak();
        String[] stringArray = new String[this.fontCount];
        Enumeration enumeration = this.fontTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object3 = (Color[])this.fontTable.get(string);
            stringArray[((Integer)object3).intValue()] = string;
        }
        this.writeBegingroup();
        this.writeControlWord("fonttbl");
        for (n2 = 0; n2 < this.fontCount; ++n2) {
            this.writeControlWord("f", n2);
            this.writeControlWord("fnil");
            this.writeText(stringArray[n2]);
            this.writeText(";");
        }
        this.writeEndgroup();
        this.writeLineBreak();
        if (this.colorCount > 1) {
            Object object4;
            object3 = new Color[this.colorCount];
            object2 = this.colorTable.keys();
            while (object2.hasMoreElements()) {
                object4 = (Color)object2.nextElement();
                object = (Integer)this.colorTable.get(object4);
                object3[((Integer)object).intValue()] = object4;
            }
            this.writeBegingroup();
            this.writeControlWord("colortbl");
            for (n2 = 0; n2 < this.colorCount; ++n2) {
                object4 = object3[n2];
                if (object4 != null) {
                    this.writeControlWord("red", ((Color)object4).getRed());
                    this.writeControlWord("green", ((Color)object4).getGreen());
                    this.writeControlWord("blue", ((Color)object4).getBlue());
                }
                this.writeRawString(";");
            }
            this.writeEndgroup();
            this.writeLineBreak();
        }
        if (this.styleCount > 1) {
            this.writeBegingroup();
            this.writeControlWord("stylesheet");
            object3 = this.styleTable.keys();
            while (object3.hasMoreElements()) {
                Boolean bl2;
                Serializable serializable;
                Object object5;
                object2 = (Style)object3.nextElement();
                int n3 = (Integer)this.styleTable.get(object2);
                this.writeBegingroup();
                object = (String)object2.getAttribute("style:type");
                if (object == null) {
                    object = "paragraph";
                }
                if (((String)object).equals("character")) {
                    this.writeControlWord("*");
                    this.writeControlWord("cs", n3);
                } else if (((String)object).equals("section")) {
                    this.writeControlWord("*");
                    this.writeControlWord("ds", n3);
                } else {
                    this.writeControlWord("s", n3);
                }
                AttributeSet attributeSet = object2.getResolveParent();
                SimpleAttributeSet simpleAttributeSet = attributeSet == null ? new SimpleAttributeSet() : new SimpleAttributeSet(attributeSet);
                this.updateSectionAttributes(simpleAttributeSet, (AttributeSet)object2, false);
                this.updateParagraphAttributes(simpleAttributeSet, (AttributeSet)object2, false);
                this.updateCharacterAttributes(simpleAttributeSet, (AttributeSet)object2, false);
                attributeSet = object2.getResolveParent();
                if (attributeSet != null && attributeSet instanceof Style && (object5 = (Integer)this.styleTable.get(attributeSet)) != null) {
                    this.writeControlWord("sbasedon", (Integer)object5);
                }
                if ((object5 = (Style)object2.getAttribute("style:nextStyle")) != null && (serializable = (Integer)this.styleTable.get(object5)) != null) {
                    this.writeControlWord("snext", (Integer)serializable);
                }
                if ((serializable = (Boolean)object2.getAttribute("style:hidden")) != null && ((Boolean)serializable).booleanValue()) {
                    this.writeControlWord("shidden");
                }
                if ((bl2 = (Boolean)object2.getAttribute("style:additive")) != null && bl2.booleanValue()) {
                    this.writeControlWord("additive");
                }
                this.writeText(object2.getName());
                this.writeText(";");
                this.writeEndgroup();
            }
            this.writeEndgroup();
            this.writeLineBreak();
        }
        this.outputAttributes = new SimpleAttributeSet();
    }

    public void writeRTFTrailer() throws IOException {
        this.writeEndgroup();
        this.writeLineBreak();
    }

    public void writeCharacter(char c2) throws IOException {
        if (c2 == '\u00a0') {
            this.outputStream.write(92);
            this.outputStream.write(126);
            this.afterKeyword = false;
            return;
        }
        if (c2 == '\t') {
            this.writeControlWord("tab");
            return;
        }
        if (c2 == '\n' || c2 == '\r') {
            return;
        }
        int n2 = RTFGenerator.convertCharacter(this.outputConversion, c2);
        if (n2 == 0) {
            for (int i2 = 0; i2 < textKeywords.length; ++i2) {
                if (RTFGenerator.textKeywords[i2].character != c2) continue;
                this.writeControlWord(RTFGenerator.textKeywords[i2].keyword);
                return;
            }
            String string = this.approximationForUnicode(c2);
            if (string.length() != this.unicodeCount) {
                this.unicodeCount = string.length();
                this.writeControlWord("uc", this.unicodeCount);
            }
            this.writeControlWord("u", c2);
            this.writeRawString(" ");
            this.writeRawString(string);
            this.afterKeyword = false;
            return;
        }
        if (n2 > 127) {
            this.outputStream.write(92);
            this.outputStream.write(39);
            int n3 = (n2 & 0xF0) >>> 4;
            this.outputStream.write(hexdigits[n3]);
            n3 = n2 & 0xF;
            this.outputStream.write(hexdigits[n3]);
            this.afterKeyword = false;
            return;
        }
        switch (n2) {
            case 92: 
            case 123: 
            case 125: {
                this.outputStream.write(92);
                this.afterKeyword = false;
            }
        }
        if (this.afterKeyword) {
            this.outputStream.write(32);
            this.afterKeyword = false;
        }
        this.outputStream.write(n2);
    }

    static int[] outputConversionFromTranslationTable(char[] cArray) {
        int[] nArray = new int[2 * cArray.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            nArray[i2 * 2] = cArray[i2];
            nArray[i2 * 2 + 1] = i2;
        }
        return nArray;
    }

    protected static int convertCharacter(int[] nArray, char c2) {
        for (int i2 = 0; i2 < nArray.length; i2 += 2) {
            if (nArray[i2] != c2) continue;
            return nArray[i2 + 1];
        }
        return 0;
    }

    public RTFGenerator(OutputStream outputStream) {
        this.colorTable.put(defaultRTFColor, new Integer(0));
        this.colorCount = 1;
        this.fontTable = new Hashtable();
        this.fontCount = 0;
        this.styleTable = new Hashtable();
        this.styleCount = 0;
        this.workingSegment = new Segment();
        this.outputStream = outputStream;
        this.unicodeCount = 1;
    }

    String approximationForUnicode(char c2) {
        return "?";
    }

    public void writeControlWord(String string) throws IOException {
        this.outputStream.write(92);
        this.writeRawString(string);
        this.afterKeyword = true;
    }

    public void writeRawString(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.outputStream.write(string.charAt(i2));
        }
    }

    public void writeText(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeCharacter(string.charAt(i2));
        }
    }

    static int[] outputConversionForName(String string) throws IOException {
        char[] cArray = (char[])RTFReader.getCharacterSet(string);
        return RTFGenerator.outputConversionFromTranslationTable(cArray);
    }

    public void writeControlWord(String string, int n2) throws IOException {
        this.outputStream.write(92);
        this.writeRawString(string);
        this.writeRawString(String.valueOf(n2));
        this.afterKeyword = true;
    }

    private void tallyStyles(AttributeSet attributeSet) {
        while (attributeSet != null) {
            Integer n2;
            if (attributeSet instanceof Style && (n2 = (Integer)this.styleTable.get(attributeSet)) == null) {
                ++this.styleCount;
                n2 = new Integer(this.styleCount);
                this.styleTable.put(attributeSet, n2);
            }
            attributeSet = attributeSet.getResolveParent();
        }
    }

    void writeDocumentProperties(Document document) throws IOException {
        boolean bl2 = false;
        for (int i2 = 0; i2 < RTFAttributes.attributes.length; ++i2) {
            Object object;
            boolean bl3;
            RTFAttribute rTFAttribute = RTFAttributes.attributes[i2];
            if (rTFAttribute.domain() != 3 || !(bl3 = rTFAttribute.writeValue(object = document.getProperty(rTFAttribute.swingName()), this, false))) continue;
            bl2 = true;
        }
        if (bl2) {
            this.writeLineBreak();
        }
    }

    public void examineElement(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        this.tallyStyles(attributeSet);
        if (attributeSet != null) {
            String string;
            Object object;
            Color color = StyleConstants.getForeground(attributeSet);
            if (color != null && this.colorTable.get(color) == null) {
                this.colorTable.put(color, new Integer(this.colorCount));
                ++this.colorCount;
            }
            if ((object = attributeSet.getAttribute(StyleConstants.Background)) != null && this.colorTable.get(object) == null) {
                this.colorTable.put(object, new Integer(this.colorCount));
                ++this.colorCount;
            }
            if ((string = StyleConstants.getFontFamily(attributeSet)) == null) {
                string = defaultFontFamily;
            }
            if (string != null && this.fontTable.get(string) == null) {
                this.fontTable.put(string, new Integer(this.fontCount));
                ++this.fontCount;
            }
        }
        int n2 = element.getElementCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.examineElement(element.getElement(i2));
        }
    }

    public void writeParagraphElement(Element element) throws IOException {
        this.updateParagraphAttributes(this.outputAttributes, element.getAttributes(), true);
        int n2 = element.getElementCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeTextElement(element.getElement(i2));
        }
        this.writeControlWord("par");
        this.writeLineBreak();
    }

    public void writeTextElement(Element element) throws IOException {
        this.updateCharacterAttributes(this.outputAttributes, element.getAttributes(), true);
        if (element.isLeaf()) {
            try {
                element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), this.workingSegment);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                throw new InternalError(badLocationException.getMessage());
            }
            this.writeText(this.workingSegment);
        } else {
            int n2 = element.getElementCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.writeTextElement(element.getElement(i2));
            }
        }
    }

    protected void resetCharacterAttributes(MutableAttributeSet mutableAttributeSet) throws IOException {
        this.writeControlWord("plain");
        int n2 = RTFAttributes.attributes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            RTFAttribute rTFAttribute = RTFAttributes.attributes[i2];
            if (rTFAttribute.domain() != 0) continue;
            rTFAttribute.setDefault(mutableAttributeSet);
        }
        StyleConstants.setFontFamily(mutableAttributeSet, defaultFontFamily);
        mutableAttributeSet.removeAttribute(StyleConstants.FontSize);
        mutableAttributeSet.removeAttribute(StyleConstants.Background);
        mutableAttributeSet.removeAttribute(StyleConstants.Foreground);
        mutableAttributeSet.removeAttribute(StyleConstants.LineSpacing);
        mutableAttributeSet.removeAttribute("characterStyle");
    }

    protected void resetParagraphAttributes(MutableAttributeSet mutableAttributeSet) throws IOException {
        this.writeControlWord("pard");
        mutableAttributeSet.addAttribute(StyleConstants.Alignment, Zero);
        int n2 = RTFAttributes.attributes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            RTFAttribute rTFAttribute = RTFAttributes.attributes[i2];
            if (rTFAttribute.domain() != 1) continue;
            rTFAttribute.setDefault(mutableAttributeSet);
        }
        mutableAttributeSet.removeAttribute("paragraphStyle");
        mutableAttributeSet.removeAttribute("tabs");
    }

    protected void resetSectionAttributes(MutableAttributeSet mutableAttributeSet) throws IOException {
        this.writeControlWord("sectd");
        int n2 = RTFAttributes.attributes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            RTFAttribute rTFAttribute = RTFAttributes.attributes[i2];
            if (rTFAttribute.domain() != 2) continue;
            rTFAttribute.setDefault(mutableAttributeSet);
        }
        mutableAttributeSet.removeAttribute("sectionStyle");
    }

    public void writeText(Segment segment) throws IOException {
        int n2;
        int n3 = n2 + segment.count;
        char[] cArray = segment.array;
        for (n2 = segment.offset; n2 < n3; ++n2) {
            this.writeCharacter(cArray[n2]);
        }
    }

    public static void writeDocument(Document document, OutputStream outputStream) throws IOException {
        RTFGenerator rTFGenerator = new RTFGenerator(outputStream);
        Element element = document.getDefaultRootElement();
        rTFGenerator.examineElement(element);
        rTFGenerator.writeRTFHeader();
        rTFGenerator.writeDocumentProperties(document);
        int n2 = element.getElementCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            rTFGenerator.writeParagraphElement(element.getElement(i2));
        }
        rTFGenerator.writeRTFTrailer();
    }

    private static boolean equalArraysOK(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.equals(object2)) {
            return true;
        }
        if (!object.getClass().isArray() || !object2.getClass().isArray()) {
            return false;
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])object2;
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (RTFGenerator.equalArraysOK(objectArray[i2], objectArray2[i2])) continue;
            return false;
        }
        return true;
    }

    void updateCharacterAttributes(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, boolean bl2) throws IOException {
        Object object;
        Integer n2;
        Object object2;
        if (bl2 && (object2 = mutableAttributeSet.getAttribute("characterStyle")) != (n2 = this.findStyleNumber(attributeSet, "character"))) {
            if (object2 != null) {
                this.resetCharacterAttributes(mutableAttributeSet);
            }
            if (n2 != null) {
                this.writeControlWord("cs", n2);
                mutableAttributeSet.addAttribute("characterStyle", n2);
            } else {
                mutableAttributeSet.removeAttribute("characterStyle");
            }
        }
        if ((object = RTFGenerator.attrDiff(mutableAttributeSet, attributeSet, StyleConstants.FontFamily, null)) != null) {
            object2 = (Number)this.fontTable.get(object);
            this.writeControlWord("f", ((Number)object2).intValue());
        }
        this.checkNumericControlWord(mutableAttributeSet, attributeSet, StyleConstants.FontSize, "fs", 12.0f, 2.0f);
        this.checkControlWords(mutableAttributeSet, attributeSet, RTFAttributes.attributes, 0);
        this.checkNumericControlWord(mutableAttributeSet, attributeSet, StyleConstants.LineSpacing, "sl", 0.0f, 20.0f);
        object = RTFGenerator.attrDiff(mutableAttributeSet, attributeSet, StyleConstants.Background, MagicToken);
        if (object != null) {
            int n3 = object == MagicToken ? 0 : ((Number)this.colorTable.get(object)).intValue();
            this.writeControlWord("cb", n3);
        }
        if ((object = RTFGenerator.attrDiff(mutableAttributeSet, attributeSet, StyleConstants.Foreground, null)) != null) {
            int n4 = object == MagicToken ? 0 : ((Number)this.colorTable.get(object)).intValue();
            this.writeControlWord("cf", n4);
        }
    }

    void updateParagraphAttributes(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, boolean bl2) throws IOException {
        Object object;
        Object object2;
        Integer n2;
        Object object3;
        if (bl2) {
            object3 = mutableAttributeSet.getAttribute("paragraphStyle");
            if (object3 != (n2 = this.findStyleNumber(attributeSet, "paragraph")) && object3 != null) {
                this.resetParagraphAttributes(mutableAttributeSet);
                object3 = null;
            }
        } else {
            object3 = null;
            n2 = null;
        }
        if ((object2 = mutableAttributeSet.getAttribute("tabs")) != (object = attributeSet.getAttribute("tabs")) && object2 != null) {
            this.resetParagraphAttributes(mutableAttributeSet);
            object2 = null;
            object3 = null;
        }
        if (object3 != n2 && n2 != null) {
            this.writeControlWord("s", n2);
            mutableAttributeSet.addAttribute("paragraphStyle", n2);
        }
        this.checkControlWords(mutableAttributeSet, attributeSet, RTFAttributes.attributes, 1);
        if (object2 != object && object != null) {
            TabStop[] tabStopArray = (TabStop[])object;
            for (int i2 = 0; i2 < tabStopArray.length; ++i2) {
                TabStop tabStop = tabStopArray[i2];
                switch (tabStop.getAlignment()) {
                    case 0: 
                    case 5: {
                        break;
                    }
                    case 1: {
                        this.writeControlWord("tqr");
                        break;
                    }
                    case 2: {
                        this.writeControlWord("tqc");
                        break;
                    }
                    case 4: {
                        this.writeControlWord("tqdec");
                    }
                }
                switch (tabStop.getLeader()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.writeControlWord("tldot");
                        break;
                    }
                    case 2: {
                        this.writeControlWord("tlhyph");
                        break;
                    }
                    case 3: {
                        this.writeControlWord("tlul");
                        break;
                    }
                    case 4: {
                        this.writeControlWord("tlth");
                        break;
                    }
                    case 5: {
                        this.writeControlWord("tleq");
                    }
                }
                int n3 = Math.round(20.0f * tabStop.getPosition());
                if (tabStop.getAlignment() == 5) {
                    this.writeControlWord("tb", n3);
                    continue;
                }
                this.writeControlWord("tx", n3);
            }
            mutableAttributeSet.addAttribute("tabs", tabStopArray);
        }
    }

    void updateSectionAttributes(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, boolean bl2) throws IOException {
        Integer n2;
        Object object;
        if (bl2 && (object = mutableAttributeSet.getAttribute("sectionStyle")) != (n2 = this.findStyleNumber(attributeSet, "section"))) {
            if (object != null) {
                this.resetSectionAttributes(mutableAttributeSet);
            }
            if (n2 != null) {
                this.writeControlWord("ds", n2);
                mutableAttributeSet.addAttribute("sectionStyle", n2);
            } else {
                mutableAttributeSet.removeAttribute("sectionStyle");
            }
        }
        this.checkControlWords(mutableAttributeSet, attributeSet, RTFAttributes.attributes, 2);
    }

    private Style findStyle(AttributeSet attributeSet) {
        while (attributeSet != null) {
            Object object;
            if (attributeSet instanceof Style && (object = this.styleTable.get(attributeSet)) != null) {
                return (Style)attributeSet;
            }
            attributeSet = attributeSet.getResolveParent();
        }
        return null;
    }

    private Integer findStyleNumber(AttributeSet attributeSet, String string) {
        while (attributeSet != null) {
            Integer n2;
            if (attributeSet instanceof Style && (n2 = (Integer)this.styleTable.get(attributeSet)) != null && (string == null || string.equals(attributeSet.getAttribute("style:type")))) {
                return n2;
            }
            attributeSet = attributeSet.getResolveParent();
        }
        return null;
    }

    protected void checkControlWord(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, RTFAttribute rTFAttribute) throws IOException {
        Object object = RTFGenerator.attrDiff(mutableAttributeSet, attributeSet, rTFAttribute.swingName(), MagicToken);
        if (object != null) {
            if (object == MagicToken) {
                object = null;
            }
            rTFAttribute.writeValue(object, this, true);
        }
    }

    protected void checkControlWords(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, RTFAttribute[] rTFAttributeArray, int n2) throws IOException {
        int n3 = rTFAttributeArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            RTFAttribute rTFAttribute = rTFAttributeArray[i2];
            if (rTFAttribute.domain() != n2) continue;
            this.checkControlWord(mutableAttributeSet, attributeSet, rTFAttribute);
        }
    }

    protected void checkNumericControlWord(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, Object object, String string, float f2, float f3) throws IOException {
        Object object2 = RTFGenerator.attrDiff(mutableAttributeSet, attributeSet, object, MagicToken);
        if (object2 != null) {
            float f4 = object2 == MagicToken ? f2 : ((Number)object2).floatValue();
            this.writeControlWord(string, Math.round(f4 * f3));
        }
    }

    private static Object attrDiff(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, Object object, Object object2) {
        Object object3 = mutableAttributeSet.getAttribute(object);
        Object object4 = attributeSet.getAttribute(object);
        if (object4 == object3) {
            return null;
        }
        if (object4 == null) {
            mutableAttributeSet.removeAttribute(object);
            if (object2 != null && !object2.equals(object3)) {
                return object2;
            }
            return null;
        }
        if (object3 == null || !RTFGenerator.equalArraysOK(object3, object4)) {
            mutableAttributeSet.addAttribute(object, object4);
            return object4;
        }
        return null;
    }

    static class CharacterKeywordPair {
        public char character;
        public String keyword;

        CharacterKeywordPair() {
        }
    }
}

