/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.GlyphPainter2;
import javax.swing.text.GlyphView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import sun.awt.font.BidiUtils;

class TextLayoutStrategy
extends FlowView.FlowStrategy {
    private LineBreakMeasurer measurer;
    private AttributedSegment text = new AttributedSegment();

    public void layout(FlowView flowView) {
        super.layout(flowView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sync(FlowView flowView) {
        Cloneable cloneable;
        FontRenderContext fontRenderContext;
        View view = this.getLogicalView(flowView);
        this.text.setView(view);
        Graphics2D graphics2D = (Graphics2D)flowView.getContainer().getGraphics();
        try {
            if (graphics2D != null) {
                fontRenderContext = graphics2D.getFontRenderContext();
            } else {
                cloneable = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
                fontRenderContext = new FontRenderContext((AffineTransform)cloneable, false, false);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        Container container = flowView.getContainer();
        cloneable = container != null ? BreakIterator.getLineInstance(container.getLocale()) : BreakIterator.getLineInstance();
        this.measurer = new LineBreakMeasurer(this.text, (BreakIterator)cloneable, fontRenderContext);
        int n2 = view.getViewCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view2 = view.getView(i2);
            if (!(view2 instanceof GlyphView)) continue;
            int n3 = view2.getStartOffset();
            int n4 = view2.getEndOffset();
            this.measurer.setPosition(this.text.toIteratorIndex(n3));
            TextLayout textLayout = this.measurer.nextLayout(Float.MAX_VALUE, this.text.toIteratorIndex(n4), false);
            ((GlyphView)view2).setGlyphPainter(new GlyphPainter2(textLayout));
        }
        this.measurer.setPosition(this.text.getBeginIndex());
    }

    protected int layoutRow(FlowView flowView, int n2, int n3) {
        int n4;
        int n5 = super.layoutRow(flowView, n2, n3);
        View view = flowView.getView(n2);
        Document document = flowView.getDocument();
        Object object = document.getProperty("i18n");
        if (object != null && object.equals(Boolean.TRUE) && (n4 = view.getViewCount()) > 1) {
            AbstractDocument abstractDocument = (AbstractDocument)flowView.getDocument();
            Element element = abstractDocument.getBidiRootElement();
            byte[] byArray = new byte[n4];
            Object[] objectArray = new View[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                View view2 = view.getView(i2);
                int n6 = element.getElementIndex(view2.getStartOffset());
                Element element2 = element.getElement(n6);
                byArray[i2] = (byte)StyleConstants.getBidiLevel(element2.getAttributes());
                objectArray[i2] = view2;
            }
            BidiUtils.reorderVisually(byArray, objectArray);
            view.replace(0, n4, (View[])objectArray);
        }
        return n5;
    }

    protected void adjustRow(FlowView flowView, int n2, int n3, int n4) {
    }

    int getLimitingOffset(View view, int n2, int n3, boolean bl2) {
        Object object;
        Element element;
        int n4 = view.getEndOffset();
        Document document = view.getDocument();
        if (document instanceof AbstractDocument && (element = ((AbstractDocument)(object = (AbstractDocument)document)).getBidiRootElement()).getElementCount() > 1) {
            int n5 = element.getElementIndex(n2);
            Element element2 = element.getElement(n5);
            n4 = Math.min(element2.getEndOffset(), n4);
        }
        if (view instanceof GlyphView) {
            object = ((GlyphView)view).getText(n2, n4);
            char c2 = ((Segment)object).first();
            if (c2 == '\t') {
                n4 = n2 + 1;
            } else {
                c2 = ((Segment)object).next();
                while (c2 != '\uffff') {
                    if (c2 == '\t') {
                        n4 = n2 + ((Segment)object).getIndex() - ((Segment)object).getBeginIndex();
                        break;
                    }
                    c2 = ((Segment)object).next();
                }
            }
        }
        int n6 = this.text.toIteratorIndex(n4);
        if (this.measurer != null) {
            int n7 = this.text.toIteratorIndex(n2);
            if (this.measurer.getPosition() != n7) {
                this.measurer.setPosition(n7);
            }
            n6 = this.measurer.nextOffset(n3, n6, bl2);
        }
        int n8 = this.text.toModelPosition(n6);
        return n8;
    }

    protected View createView(FlowView flowView, int n2, int n3, int n4) {
        View view = this.getLogicalView(flowView);
        View view2 = flowView.getView(n4);
        boolean bl2 = view2.getViewCount() != 0;
        int n5 = view.getViewIndex(n2, Position.Bias.Forward);
        View view3 = view.getView(n5);
        int n6 = this.getLimitingOffset(view3, n2, n3, bl2);
        if (n6 == n2) {
            return null;
        }
        View view4 = n2 == view3.getStartOffset() && n6 == view3.getEndOffset() ? view3 : view3.createFragment(n2, n6);
        if (view4 instanceof GlyphView && this.measurer != null) {
            Segment segment;
            char c2;
            boolean bl3 = false;
            int n7 = view4.getStartOffset();
            int n8 = view4.getEndOffset();
            if (n8 - n7 == 1 && (c2 = (segment = ((GlyphView)view4).getText(n7, n8)).first()) == '\t') {
                bl3 = true;
            }
            Cloneable cloneable = segment = bl3 ? null : this.measurer.nextLayout(n3, this.text.toIteratorIndex(n6), bl2);
            if (segment != null) {
                ((GlyphView)view4).setGlyphPainter(new GlyphPainter2((TextLayout)((Object)segment)));
            }
        }
        return view4;
    }

    public void changedUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        this.sync(flowView);
        super.changedUpdate(flowView, documentEvent, rectangle);
    }

    public void insertUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        this.sync(flowView);
        super.insertUpdate(flowView, documentEvent, rectangle);
    }

    public void removeUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        this.sync(flowView);
        super.removeUpdate(flowView, documentEvent, rectangle);
    }

    static class AttributedSegment
    extends Segment
    implements AttributedCharacterIterator {
        View v;
        static Set keys = new HashSet();

        public int getRunLimit() {
            int n2 = this.toModelPosition(this.getIndex());
            int n3 = this.v.getViewIndex(n2, Position.Bias.Forward);
            View view = this.v.getView(n3);
            return this.toIteratorIndex(view.getEndOffset());
        }

        public int getRunStart() {
            int n2 = this.toModelPosition(this.getIndex());
            int n3 = this.v.getViewIndex(n2, Position.Bias.Forward);
            View view = this.v.getView(n3);
            return this.toIteratorIndex(view.getStartOffset());
        }

        static {
            keys.add(TextAttribute.FONT);
            keys.add(TextAttribute.RUN_DIRECTION);
        }

        AttributedSegment() {
        }

        int toIteratorIndex(int n2) {
            return n2 - this.v.getStartOffset() + this.getBeginIndex();
        }

        int toModelPosition(int n2) {
            return this.v.getStartOffset() + (n2 - this.getBeginIndex());
        }

        int getFontBoundary(int n2, int n3) {
            Font font;
            View view = this.v.getView(n2);
            Font font2 = this.getFont(n2);
            n2 += n3;
            while (n2 >= 0 && n2 < this.v.getViewCount() && (font = this.getFont(n2)) == font2) {
                view = this.v.getView(n2);
                n2 += n3;
            }
            return n3 < 0 ? view.getStartOffset() : view.getEndOffset();
        }

        Font getFont(int n2) {
            View view = this.v.getView(n2);
            if (view instanceof GlyphView) {
                return ((GlyphView)view).getFont();
            }
            return null;
        }

        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            if (attribute instanceof TextAttribute) {
                int n2 = this.toModelPosition(this.getIndex());
                int n3 = this.v.getViewIndex(n2, Position.Bias.Forward);
                if (attribute == TextAttribute.FONT) {
                    return this.toIteratorIndex(this.getFontBoundary(n3, 1));
                }
            }
            return this.getEndIndex();
        }

        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            if (attribute instanceof TextAttribute) {
                int n2 = this.toModelPosition(this.getIndex());
                int n3 = this.v.getViewIndex(n2, Position.Bias.Forward);
                if (attribute == TextAttribute.FONT) {
                    return this.toIteratorIndex(this.getFontBoundary(n3, -1));
                }
            }
            return this.getBeginIndex();
        }

        public Map getAttributes() {
            Object[] objectArray = keys.toArray();
            Hashtable hashtable = new Hashtable();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                TextAttribute textAttribute = (TextAttribute)objectArray[i2];
                Object object = this.getAttribute(textAttribute);
                if (object == null) continue;
                hashtable.put(textAttribute, object);
            }
            return hashtable;
        }

        public Set getAllAttributeKeys() {
            return keys;
        }

        public int getRunLimit(Set set) {
            int n2 = this.getEndIndex();
            Object[] objectArray = set.toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                TextAttribute textAttribute = (TextAttribute)objectArray[i2];
                n2 = Math.min(this.getRunLimit(textAttribute), n2);
            }
            return Math.max(this.getIndex(), n2);
        }

        public int getRunStart(Set set) {
            int n2 = this.getBeginIndex();
            Object[] objectArray = set.toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                TextAttribute textAttribute = (TextAttribute)objectArray[i2];
                n2 = Math.max(this.getRunStart(textAttribute), n2);
            }
            return Math.min(this.getIndex(), n2);
        }

        View getView() {
            return this.v;
        }

        void setView(View view) {
            this.v = view;
            Document document = view.getDocument();
            int n2 = view.getStartOffset();
            int n3 = view.getEndOffset();
            try {
                document.getText(n2, n3 - n2, this);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException("Invalid view");
            }
            this.first();
        }

        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            int n2 = this.toModelPosition(this.getIndex());
            int n3 = this.v.getViewIndex(n2, Position.Bias.Forward);
            if (attribute == TextAttribute.FONT) {
                return this.getFont(n3);
            }
            if (attribute == TextAttribute.RUN_DIRECTION) {
                return this.v.getDocument().getProperty(TextAttribute.RUN_DIRECTION);
            }
            return null;
        }
    }
}

