/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.TabSet;

public class StyleConstants {
    public static final String ComponentElementName = "component";
    public static final String IconElementName = "icon";
    public static final Object NameAttribute = new StyleConstants("name");
    public static final Object ResolveAttribute = new StyleConstants("resolver");
    public static final Object ModelAttribute = new StyleConstants("model");
    public static final Object BidiLevel = CharacterConstants.BidiLevel;
    public static final Object FontFamily = CharacterConstants.Family;
    public static final Object FontSize = CharacterConstants.Size;
    public static final Object Bold = CharacterConstants.Bold;
    public static final Object Italic = CharacterConstants.Italic;
    public static final Object Underline = CharacterConstants.Underline;
    public static final Object StrikeThrough = CharacterConstants.StrikeThrough;
    public static final Object Superscript = CharacterConstants.Superscript;
    public static final Object Subscript = CharacterConstants.Subscript;
    public static final Object Foreground = CharacterConstants.Foreground;
    public static final Object Background = CharacterConstants.Background;
    public static final Object ComponentAttribute = CharacterConstants.ComponentAttribute;
    public static final Object IconAttribute = CharacterConstants.IconAttribute;
    public static final Object ComposedTextAttribute = new StyleConstants("composed text");
    public static final Object FirstLineIndent = ParagraphConstants.FirstLineIndent;
    public static final Object LeftIndent = ParagraphConstants.LeftIndent;
    public static final Object RightIndent = ParagraphConstants.RightIndent;
    public static final Object LineSpacing = ParagraphConstants.LineSpacing;
    public static final Object SpaceAbove = ParagraphConstants.SpaceAbove;
    public static final Object SpaceBelow = ParagraphConstants.SpaceBelow;
    public static final Object Alignment = ParagraphConstants.Alignment;
    public static final Object TabSet = ParagraphConstants.TabSet;
    public static final Object Orientation = ParagraphConstants.Orientation;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_JUSTIFIED = 3;
    static Object[] keys = new Object[]{NameAttribute, ResolveAttribute, BidiLevel, FontFamily, FontSize, Bold, Italic, Underline, StrikeThrough, Superscript, Subscript, Foreground, Background, ComponentAttribute, IconAttribute, FirstLineIndent, LeftIndent, RightIndent, LineSpacing, SpaceAbove, SpaceBelow, Alignment, TabSet, Orientation, ModelAttribute, ComposedTextAttribute};
    private String representation;

    public String toString() {
        return this.representation;
    }

    StyleConstants(String string) {
        this.representation = string;
    }

    public static float getFirstLineIndent(AttributeSet attributeSet) {
        Float f2 = (Float)attributeSet.getAttribute(FirstLineIndent);
        if (f2 != null) {
            return f2.floatValue();
        }
        return 0.0f;
    }

    public static float getLeftIndent(AttributeSet attributeSet) {
        Float f2 = (Float)attributeSet.getAttribute(LeftIndent);
        if (f2 != null) {
            return f2.floatValue();
        }
        return 0.0f;
    }

    public static float getLineSpacing(AttributeSet attributeSet) {
        Float f2 = (Float)attributeSet.getAttribute(LineSpacing);
        if (f2 != null) {
            return f2.floatValue();
        }
        return 0.0f;
    }

    public static float getRightIndent(AttributeSet attributeSet) {
        Float f2 = (Float)attributeSet.getAttribute(RightIndent);
        if (f2 != null) {
            return f2.floatValue();
        }
        return 0.0f;
    }

    public static float getSpaceAbove(AttributeSet attributeSet) {
        Float f2 = (Float)attributeSet.getAttribute(SpaceAbove);
        if (f2 != null) {
            return f2.floatValue();
        }
        return 0.0f;
    }

    public static float getSpaceBelow(AttributeSet attributeSet) {
        Float f2 = (Float)attributeSet.getAttribute(SpaceBelow);
        if (f2 != null) {
            return f2.floatValue();
        }
        return 0.0f;
    }

    public static int getAlignment(AttributeSet attributeSet) {
        Integer n2 = (Integer)attributeSet.getAttribute(Alignment);
        if (n2 != null) {
            return n2;
        }
        return 0;
    }

    public static int getBidiLevel(AttributeSet attributeSet) {
        Integer n2 = (Integer)attributeSet.getAttribute(BidiLevel);
        if (n2 != null) {
            return n2;
        }
        return 0;
    }

    public static int getFontSize(AttributeSet attributeSet) {
        Integer n2 = (Integer)attributeSet.getAttribute(FontSize);
        if (n2 != null) {
            return n2;
        }
        return 12;
    }

    public static boolean isBold(AttributeSet attributeSet) {
        Boolean bl2 = (Boolean)attributeSet.getAttribute(Bold);
        if (bl2 != null) {
            return bl2;
        }
        return false;
    }

    public static boolean isItalic(AttributeSet attributeSet) {
        Boolean bl2 = (Boolean)attributeSet.getAttribute(Italic);
        if (bl2 != null) {
            return bl2;
        }
        return false;
    }

    public static boolean isStrikeThrough(AttributeSet attributeSet) {
        Boolean bl2 = (Boolean)attributeSet.getAttribute(StrikeThrough);
        if (bl2 != null) {
            return bl2;
        }
        return false;
    }

    public static boolean isSubscript(AttributeSet attributeSet) {
        Boolean bl2 = (Boolean)attributeSet.getAttribute(Subscript);
        if (bl2 != null) {
            return bl2;
        }
        return false;
    }

    public static boolean isSuperscript(AttributeSet attributeSet) {
        Boolean bl2 = (Boolean)attributeSet.getAttribute(Superscript);
        if (bl2 != null) {
            return bl2;
        }
        return false;
    }

    public static boolean isUnderline(AttributeSet attributeSet) {
        Boolean bl2 = (Boolean)attributeSet.getAttribute(Underline);
        if (bl2 != null) {
            return bl2;
        }
        return false;
    }

    public static void setFirstLineIndent(MutableAttributeSet mutableAttributeSet, float f2) {
        mutableAttributeSet.addAttribute(FirstLineIndent, new Float(f2));
    }

    public static void setLeftIndent(MutableAttributeSet mutableAttributeSet, float f2) {
        mutableAttributeSet.addAttribute(LeftIndent, new Float(f2));
    }

    public static void setLineSpacing(MutableAttributeSet mutableAttributeSet, float f2) {
        mutableAttributeSet.addAttribute(LineSpacing, new Float(f2));
    }

    public static void setRightIndent(MutableAttributeSet mutableAttributeSet, float f2) {
        mutableAttributeSet.addAttribute(RightIndent, new Float(f2));
    }

    public static void setSpaceAbove(MutableAttributeSet mutableAttributeSet, float f2) {
        mutableAttributeSet.addAttribute(SpaceAbove, new Float(f2));
    }

    public static void setSpaceBelow(MutableAttributeSet mutableAttributeSet, float f2) {
        mutableAttributeSet.addAttribute(SpaceBelow, new Float(f2));
    }

    public static void setAlignment(MutableAttributeSet mutableAttributeSet, int n2) {
        mutableAttributeSet.addAttribute(Alignment, new Integer(n2));
    }

    public static void setBidiLevel(MutableAttributeSet mutableAttributeSet, int n2) {
        mutableAttributeSet.addAttribute(BidiLevel, new Integer(n2));
    }

    public static void setFontSize(MutableAttributeSet mutableAttributeSet, int n2) {
        mutableAttributeSet.addAttribute(FontSize, new Integer(n2));
    }

    public static void setBold(MutableAttributeSet mutableAttributeSet, boolean bl2) {
        mutableAttributeSet.addAttribute(Bold, bl2);
    }

    public static void setItalic(MutableAttributeSet mutableAttributeSet, boolean bl2) {
        mutableAttributeSet.addAttribute(Italic, bl2);
    }

    public static void setStrikeThrough(MutableAttributeSet mutableAttributeSet, boolean bl2) {
        mutableAttributeSet.addAttribute(StrikeThrough, bl2);
    }

    public static void setSubscript(MutableAttributeSet mutableAttributeSet, boolean bl2) {
        mutableAttributeSet.addAttribute(Subscript, bl2);
    }

    public static void setSuperscript(MutableAttributeSet mutableAttributeSet, boolean bl2) {
        mutableAttributeSet.addAttribute(Superscript, bl2);
    }

    public static void setUnderline(MutableAttributeSet mutableAttributeSet, boolean bl2) {
        mutableAttributeSet.addAttribute(Underline, bl2);
    }

    public static Color getBackground(AttributeSet attributeSet) {
        Color color = (Color)attributeSet.getAttribute(Background);
        if (color == null) {
            color = Color.black;
        }
        return color;
    }

    public static Color getForeground(AttributeSet attributeSet) {
        Color color = (Color)attributeSet.getAttribute(Foreground);
        if (color == null) {
            color = Color.black;
        }
        return color;
    }

    public static void setBackground(MutableAttributeSet mutableAttributeSet, Color color) {
        mutableAttributeSet.addAttribute(Background, color);
    }

    public static void setForeground(MutableAttributeSet mutableAttributeSet, Color color) {
        mutableAttributeSet.addAttribute(Foreground, color);
    }

    public static Component getComponent(AttributeSet attributeSet) {
        return (Component)attributeSet.getAttribute(ComponentAttribute);
    }

    public static void setComponent(MutableAttributeSet mutableAttributeSet, Component component) {
        mutableAttributeSet.addAttribute("$ename", ComponentElementName);
        mutableAttributeSet.addAttribute(ComponentAttribute, component);
    }

    public static String getFontFamily(AttributeSet attributeSet) {
        String string = (String)attributeSet.getAttribute(FontFamily);
        if (string == null) {
            string = "Monospaced";
        }
        return string;
    }

    public static void setFontFamily(MutableAttributeSet mutableAttributeSet, String string) {
        mutableAttributeSet.addAttribute(FontFamily, string);
    }

    public static Icon getIcon(AttributeSet attributeSet) {
        return (Icon)attributeSet.getAttribute(IconAttribute);
    }

    public static void setIcon(MutableAttributeSet mutableAttributeSet, Icon icon) {
        mutableAttributeSet.addAttribute("$ename", IconElementName);
        mutableAttributeSet.addAttribute(IconAttribute, icon);
    }

    public static TabSet getTabSet(AttributeSet attributeSet) {
        TabSet tabSet = (TabSet)attributeSet.getAttribute(TabSet);
        return tabSet;
    }

    public static void setTabSet(MutableAttributeSet mutableAttributeSet, TabSet tabSet) {
        mutableAttributeSet.addAttribute(TabSet, tabSet);
    }

    public static class CharacterConstants
    extends StyleConstants
    implements AttributeSet.CharacterAttribute {
        public static final Object Underline = new CharacterConstants("underline");
        public static final Object StrikeThrough = new CharacterConstants("strikethrough");
        public static final Object Superscript = new CharacterConstants("superscript");
        public static final Object Subscript = new CharacterConstants("subscript");
        public static final Object ComponentAttribute = new CharacterConstants("component");
        public static final Object IconAttribute = new CharacterConstants("icon");
        public static final Object BidiLevel = new CharacterConstants("bidiLevel");
        public static final Object Family = FontConstants.Family;
        public static final Object Size = FontConstants.Size;
        public static final Object Bold = FontConstants.Bold;
        public static final Object Italic = FontConstants.Italic;
        public static final Object Foreground = ColorConstants.Foreground;
        public static final Object Background = ColorConstants.Background;

        private CharacterConstants(String string) {
            super(string);
        }
    }

    public static class ColorConstants
    extends StyleConstants
    implements AttributeSet.ColorAttribute,
    AttributeSet.CharacterAttribute {
        public static final Object Foreground = new ColorConstants("foreground");
        public static final Object Background = new ColorConstants("background");

        private ColorConstants(String string) {
            super(string);
        }
    }

    public static class FontConstants
    extends StyleConstants
    implements AttributeSet.FontAttribute,
    AttributeSet.CharacterAttribute {
        public static final Object Family = new FontConstants("family");
        public static final Object Size = new FontConstants("size");
        public static final Object Bold = new FontConstants("bold");
        public static final Object Italic = new FontConstants("italic");

        private FontConstants(String string) {
            super(string);
        }
    }

    public static class ParagraphConstants
    extends StyleConstants
    implements AttributeSet.ParagraphAttribute {
        public static final Object FirstLineIndent = new ParagraphConstants("FirstLineIndent");
        public static final Object LeftIndent = new ParagraphConstants("LeftIndent");
        public static final Object RightIndent = new ParagraphConstants("RightIndent");
        public static final Object LineSpacing = new ParagraphConstants("LineSpacing");
        public static final Object SpaceAbove = new ParagraphConstants("SpaceAbove");
        public static final Object SpaceBelow = new ParagraphConstants("SpaceBelow");
        public static final Object Alignment = new ParagraphConstants("Alignment");
        public static final Object TabSet = new ParagraphConstants("TabSet");
        public static final Object Orientation = new ParagraphConstants("Orientation");

        private ParagraphConstants(String string) {
            super(string);
        }
    }
}

