/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalScrollButton
extends BasicArrowButton {
    private static Color shadowColor;
    private static Color highlightColor;
    private boolean isFreeStanding = false;
    private int buttonWidth;

    public int getButtonWidth() {
        return this.buttonWidth;
    }

    public MetalScrollButton(int n2, int n3, boolean bl2) {
        super(n2);
        shadowColor = UIManager.getColor("ScrollBar.darkShadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        this.buttonWidth = n3;
        this.isFreeStanding = bl2;
    }

    public void setFreeStanding(boolean bl2) {
        this.isFreeStanding = bl2;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.getDirection() == 1) {
            return new Dimension(this.buttonWidth, this.buttonWidth - 2);
        }
        if (this.getDirection() == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth - (this.isFreeStanding ? 1 : 2));
        }
        if (this.getDirection() == 3) {
            return new Dimension(this.buttonWidth - (this.isFreeStanding ? 1 : 2), this.buttonWidth);
        }
        if (this.getDirection() == 7) {
            return new Dimension(this.buttonWidth - 2, this.buttonWidth);
        }
        return new Dimension(0, 0);
    }

    public void paint(Graphics graphics) {
        boolean bl2 = MetalUtils.isLeftToRight(this);
        boolean bl3 = this.getParent().isEnabled();
        ColorUIResource colorUIResource = bl3 ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlDisabled();
        boolean bl4 = this.getModel().isPressed();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = n2;
        int n5 = n3;
        int n6 = (n3 + 1) / 4;
        int n7 = (n3 + 1) / 2;
        if (bl4) {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
        } else {
            graphics.setColor(this.getBackground());
        }
        graphics.fillRect(0, 0, n2, n3);
        if (this.getDirection() == 1) {
            if (!this.isFreeStanding) {
                ++n3;
                graphics.translate(0, -1);
                if (!bl2) {
                    ++n2;
                    graphics.translate(-1, 0);
                } else {
                    n2 += 2;
                }
            }
            graphics.setColor(colorUIResource);
            int n8 = (n5 + 1 - n6) / 2;
            int n9 = n4 / 2;
            for (int i2 = 0; i2 < n6; ++i2) {
                graphics.drawLine(n9 - i2, n8 + i2, n9 + i2 + 1, n8 + i2);
            }
            if (bl3) {
                graphics.setColor(highlightColor);
                if (!bl4) {
                    graphics.drawLine(1, 1, n2 - 3, 1);
                    graphics.drawLine(1, 1, 1, n3 - 1);
                }
                graphics.drawLine(n2 - 1, 1, n2 - 1, n3 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, n2 - 2, 0);
                graphics.drawLine(0, 0, 0, n3 - 1);
                graphics.drawLine(n2 - 2, 2, n2 - 2, n3 - 1);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, n2, n3 + 1);
            }
            if (!this.isFreeStanding) {
                --n3;
                graphics.translate(0, 1);
                if (!bl2) {
                    --n2;
                    graphics.translate(1, 0);
                } else {
                    n2 -= 2;
                }
            }
        } else if (this.getDirection() == 5) {
            if (!this.isFreeStanding) {
                ++n3;
                if (!bl2) {
                    ++n2;
                    graphics.translate(-1, 0);
                } else {
                    n2 += 2;
                }
            }
            graphics.setColor(colorUIResource);
            int n10 = (n5 + 1 - n6) / 2 + n6 - 1;
            int n11 = n4 / 2;
            for (int i3 = 0; i3 < n6; ++i3) {
                graphics.drawLine(n11 - i3, n10 - i3, n11 + i3 + 1, n10 - i3);
            }
            if (bl3) {
                graphics.setColor(highlightColor);
                if (!bl4) {
                    graphics.drawLine(1, 0, n2 - 3, 0);
                    graphics.drawLine(1, 0, 1, n3 - 3);
                }
                graphics.drawLine(1, n3 - 1, n2 - 1, n3 - 1);
                graphics.drawLine(n2 - 1, 0, n2 - 1, n3 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, 0, n3 - 2);
                graphics.drawLine(n2 - 2, 0, n2 - 2, n3 - 2);
                graphics.drawLine(2, n3 - 2, n2 - 2, n3 - 2);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, -1, n2, n3 + 1);
            }
            if (!this.isFreeStanding) {
                --n3;
                if (!bl2) {
                    --n2;
                    graphics.translate(1, 0);
                } else {
                    n2 -= 2;
                }
            }
        } else if (this.getDirection() == 3) {
            if (!this.isFreeStanding) {
                n3 += 2;
                ++n2;
            }
            graphics.setColor(colorUIResource);
            int n12 = (n4 + 1 - n6) / 2 + n6 - 1;
            int n13 = n5 / 2;
            for (int i4 = 0; i4 < n6; ++i4) {
                graphics.drawLine(n12 - i4, n13 - i4, n12 - i4, n13 + i4 + 1);
            }
            if (bl3) {
                graphics.setColor(highlightColor);
                if (!bl4) {
                    graphics.drawLine(0, 1, n2 - 3, 1);
                    graphics.drawLine(0, 1, 0, n3 - 3);
                }
                graphics.drawLine(n2 - 1, 1, n2 - 1, n3 - 1);
                graphics.drawLine(0, n3 - 1, n2 - 1, n3 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, n2 - 2, 0);
                graphics.drawLine(n2 - 2, 2, n2 - 2, n3 - 2);
                graphics.drawLine(0, n3 - 2, n2 - 2, n3 - 2);
            } else {
                MetalUtils.drawDisabledBorder(graphics, -1, 0, n2 + 1, n3);
            }
            if (!this.isFreeStanding) {
                n3 -= 2;
                --n2;
            }
        } else if (this.getDirection() == 7) {
            if (!this.isFreeStanding) {
                n3 += 2;
                ++n2;
                graphics.translate(-1, 0);
            }
            graphics.setColor(colorUIResource);
            int n14 = (n4 + 1 - n6) / 2;
            int n15 = n5 / 2;
            for (int i5 = 0; i5 < n6; ++i5) {
                graphics.drawLine(n14 + i5, n15 - i5, n14 + i5, n15 + i5 + 1);
            }
            if (bl3) {
                graphics.setColor(highlightColor);
                if (!bl4) {
                    graphics.drawLine(1, 1, n2 - 1, 1);
                    graphics.drawLine(1, 1, 1, n3 - 3);
                }
                graphics.drawLine(1, n3 - 1, n2 - 1, n3 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, n2 - 1, 0);
                graphics.drawLine(0, 0, 0, n3 - 2);
                graphics.drawLine(2, n3 - 2, n2 - 1, n3 - 2);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, n2 + 1, n3);
            }
            if (!this.isFreeStanding) {
                n3 -= 2;
                --n2;
                graphics.translate(1, 0);
            }
        }
    }
}

