/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.metal.MetalTitlePane;

public class MetalRootPaneUI
extends BasicRootPaneUI {
    private static final String[] borderKeys = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private JComponent titlePane;
    private MouseInputListener mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    private LayoutManager createLayoutManager() {
        return new MetalRootLayout();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string.equals("windowDecorationStyle")) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            int n2 = jRootPane.getWindowDecorationStyle();
            this.uninstallClientDecorations(jRootPane);
            if (n2 != 0) {
                this.installClientDecorations(jRootPane);
            }
        } else if (string.equals("ancestor")) {
            this.uninstallWindowListeners(this.root);
            if (((JRootPane)propertyChangeEvent.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
    }

    private JComponent getTitlePane() {
        return this.titlePane;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.root = (JRootPane)jComponent;
        int n2 = this.root.getWindowDecorationStyle();
        if (n2 != 0) {
            this.installClientDecorations(this.root);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    void installBorder(JRootPane jRootPane) {
        int n2 = jRootPane.getWindowDecorationStyle();
        if (n2 == 0) {
            LookAndFeel.uninstallBorder(jRootPane);
        } else {
            LookAndFeel.installBorder(jRootPane, borderKeys[n2]);
        }
    }

    private void installClientDecorations(JRootPane jRootPane) {
        this.installBorder(jRootPane);
        JComponent jComponent = this.createTitlePane(jRootPane);
        this.setTitlePane(jRootPane, jComponent);
        this.installWindowListeners(jRootPane, jRootPane.getParent());
        this.installLayout(jRootPane);
        if (this.window != null) {
            jRootPane.revalidate();
            jRootPane.repaint();
        }
    }

    private void installLayout(JRootPane jRootPane) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = jRootPane.getLayout();
        jRootPane.setLayout(this.layoutManager);
    }

    private void uninstallBorder(JRootPane jRootPane) {
        LookAndFeel.uninstallBorder(jRootPane);
    }

    private void uninstallClientDecorations(JRootPane jRootPane) {
        this.uninstallBorder(jRootPane);
        this.uninstallWindowListeners(jRootPane);
        this.setTitlePane(jRootPane, null);
        this.uninstallLayout(jRootPane);
        int n2 = jRootPane.getWindowDecorationStyle();
        if (n2 == 0) {
            jRootPane.repaint();
            jRootPane.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private void uninstallLayout(JRootPane jRootPane) {
        if (this.savedOldLayout != null) {
            jRootPane.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void uninstallWindowListeners(JRootPane jRootPane) {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installWindowListeners(JRootPane jRootPane, Component component) {
        this.window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener(jRootPane);
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private JComponent createTitlePane(JRootPane jRootPane) {
        return new MetalTitlePane(jRootPane, this);
    }

    private void setTitlePane(JRootPane jRootPane, JComponent jComponent) {
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        JComponent jComponent2 = this.getTitlePane();
        if (jComponent2 != null) {
            jComponent2.setVisible(false);
            jLayeredPane.remove(jComponent2);
        }
        if (jComponent != null) {
            jLayeredPane.add((Component)jComponent, JLayeredPane.FRAME_CONTENT_LAYER);
            jComponent.setVisible(true);
        }
        this.titlePane = jComponent;
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane jRootPane) {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalRootPaneUI();
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private MetalRootLayout() {
        }

        public void removeLayoutComponent(Component component) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Serializable serializable;
            JRootPane jRootPane = (JRootPane)container;
            Rectangle rectangle = jRootPane.getBounds();
            Insets insets = jRootPane.getInsets();
            int n2 = 0;
            int n3 = rectangle.width - insets.right - insets.left;
            int n4 = rectangle.height - insets.top - insets.bottom;
            if (jRootPane.getLayeredPane() != null) {
                jRootPane.getLayeredPane().setBounds(insets.left, insets.top, n3, n4);
            }
            if (jRootPane.getGlassPane() != null) {
                jRootPane.getGlassPane().setBounds(insets.left, insets.top, n3, n4);
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof MetalRootPaneUI && (serializable = ((MetalRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = ((JComponent)serializable).getPreferredSize()) != null) {
                int n5 = dimension.height;
                ((Component)serializable).setBounds(0, 0, n3, n5);
                n2 += n5;
            }
            if (jRootPane.getMenuBar() != null) {
                serializable = jRootPane.getMenuBar().getPreferredSize();
                jRootPane.getMenuBar().setBounds(0, n2, n3, ((Dimension)serializable).height);
                n2 += ((Dimension)serializable).height;
            }
            if (jRootPane.getContentPane() != null) {
                serializable = jRootPane.getContentPane().getPreferredSize();
                jRootPane.getContentPane().setBounds(0, n2, n3, n4 < n2 ? 0 : n4 - n2);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension maximumLayoutSize(Container container) {
            int n2;
            int n3;
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            Dimension dimension3;
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MAX_VALUE;
            int n6 = Integer.MAX_VALUE;
            int n7 = Integer.MAX_VALUE;
            int n8 = Integer.MAX_VALUE;
            int n9 = Integer.MAX_VALUE;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            if (jRootPane.getContentPane() != null && (dimension3 = jRootPane.getContentPane().getMaximumSize()) != null) {
                n4 = dimension3.width;
                n5 = dimension3.height;
            }
            if (jRootPane.getMenuBar() != null && (dimension2 = jRootPane.getMenuBar().getMaximumSize()) != null) {
                n6 = dimension2.width;
                n7 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof MetalRootPaneUI && (jComponent = ((MetalRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getMaximumSize()) != null) {
                n8 = dimension.width;
                n9 = dimension.height;
            }
            if ((n3 = Math.max(Math.max(n5, n7), n9)) != Integer.MAX_VALUE) {
                n3 = n5 + n7 + n9 + insets.top + insets.bottom;
            }
            if ((n2 = Math.max(Math.max(n4, n6), n8)) != Integer.MAX_VALUE) {
                n2 += insets.left + insets.right;
            }
            return new Dimension(n2, n3);
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getMinimumSize() : jRootPane.getSize();
            if (dimension3 != null) {
                n2 = dimension3.width;
                n3 = dimension3.height;
            }
            if (jRootPane.getMenuBar() != null && (dimension2 = jRootPane.getMenuBar().getMinimumSize()) != null) {
                n4 = dimension2.width;
                n5 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof MetalRootPaneUI && (jComponent = ((MetalRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getMinimumSize()) != null) {
                n6 = dimension.width;
                n7 = dimension.height;
            }
            return new Dimension(Math.max(Math.max(n2, n4), n6) + insets.left + insets.right, n3 + n5 + n6 + insets.top + insets.bottom);
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getPreferredSize() : jRootPane.getSize();
            if (dimension3 != null) {
                n2 = dimension3.width;
                n3 = dimension3.height;
            }
            if (jRootPane.getMenuBar() != null && (dimension2 = jRootPane.getMenuBar().getPreferredSize()) != null) {
                n4 = dimension2.width;
                n5 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof MetalRootPaneUI && (jComponent = ((MetalRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getPreferredSize()) != null) {
                n6 = dimension.width;
                n7 = dimension.height;
            }
            return new Dimension(Math.max(Math.max(n2, n4), n6) + insets.left + insets.right, n3 + n5 + n6 + insets.top + insets.bottom);
        }

        public void addLayoutComponent(Component component, Object object) {
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;

        private int getCursor(int n2) {
            if (n2 == -1) {
                return 0;
            }
            return cursorMapping[n2];
        }

        private int calculatePosition(int n2, int n3) {
            if (n2 < 5) {
                return 0;
            }
            if (n2 < 16) {
                return 1;
            }
            if (n2 >= n3 - 5) {
                return 4;
            }
            if (n2 >= n3 - 16) {
                return 3;
            }
            return 2;
        }

        private int calculateCorner(Component component, int n2, int n3) {
            int n4 = this.calculatePosition(n2, component.getWidth());
            int n5 = this.calculatePosition(n3, component.getHeight());
            if (n4 == -1 || n5 == -1) {
                return -1;
            }
            return n5 * 5 + n4;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            Frame frame = null;
            if (!(window instanceof Frame)) {
                return;
            }
            frame = (Frame)window;
            Point point = SwingUtilities.convertPoint(window, mouseEvent.getPoint(), MetalRootPaneUI.this.getTitlePane());
            int n2 = frame.getExtendedState();
            if (MetalRootPaneUI.this.getTitlePane() != null && MetalRootPaneUI.this.getTitlePane().contains(point) && mouseEvent.getClickCount() % 2 == 0 && (mouseEvent.getModifiers() & 0x10) != 0 && frame.isResizable()) {
                if ((n2 & 6) != 0) {
                    frame.setExtendedState(n2 & 0xFFFFFFF9);
                } else {
                    frame.setExtendedState(n2 | 6);
                }
                return;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            if (this.isMovingWindow) {
                Point point2 = window.getLocationOnScreen();
                point2.x += point.x - this.dragOffsetX;
                point2.y += point.y - this.dragOffsetY;
                window.setLocation(point2);
            } else if (this.dragCursor != 0) {
                Rectangle rectangle = window.getBounds();
                Rectangle rectangle2 = new Rectangle(rectangle);
                Dimension dimension = window.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(rectangle, dimension, 0, 0, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(rectangle, dimension, 0, 0, 0, point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                    case 8: {
                        this.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, 0, -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(rectangle, dimension, 0, 0, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                    case 6: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, point.y - this.dragOffsetY, -(point.x - this.dragOffsetX), -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                }
                if (!rectangle.equals(rectangle2)) {
                    window.setBounds(rectangle);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        window.validate();
                        MetalRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            MetalRootPaneUI.this.lastCursor = window.getCursor();
            this.mouseMoved(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            window.setCursor(MetalRootPaneUI.this.lastCursor);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            JRootPane jRootPane = MetalRootPaneUI.this.getRootPane();
            if (jRootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Window window = (Window)mouseEvent.getSource();
            Frame frame = null;
            Dialog dialog = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
            int n2 = this.getCursor(this.calculateCorner(window, mouseEvent.getX(), mouseEvent.getY()));
            if (n2 != 0 && (frame != null && frame.isResizable() && (frame.getExtendedState() & 6) == 0 || dialog != null && dialog.isResizable())) {
                window.setCursor(Cursor.getPredefinedCursor(n2));
            } else {
                window.setCursor(MetalRootPaneUI.this.lastCursor);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n2;
            JRootPane jRootPane = MetalRootPaneUI.this.getRootPane();
            if (jRootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Window window = (Window)mouseEvent.getSource();
            if (window != null) {
                window.toFront();
            }
            Point point2 = SwingUtilities.convertPoint(window, point, MetalRootPaneUI.this.getTitlePane());
            Frame frame = null;
            Dialog dialog = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
            int n3 = n2 = frame != null ? frame.getExtendedState() : 0;
            if (MetalRootPaneUI.this.getTitlePane() != null && MetalRootPaneUI.this.getTitlePane().contains(point2)) {
                if ((frame != null && (n2 & 6) == 0 || dialog != null) && point.y >= 5 && point.x >= 5 && point.x < window.getWidth() - 5) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = point.x;
                    this.dragOffsetY = point.y;
                }
            } else if (frame != null && frame.isResizable() && (n2 & 6) == 0 || dialog != null && dialog.isResizable()) {
                this.dragOffsetX = point.x;
                this.dragOffsetY = point.y;
                this.dragWidth = window.getWidth();
                this.dragHeight = window.getHeight();
                this.dragCursor = this.getCursor(this.calculateCorner(window, point.x, point.y));
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.dragCursor != 0 && MetalRootPaneUI.this.window != null && !MetalRootPaneUI.this.window.isValid()) {
                MetalRootPaneUI.this.window.validate();
                MetalRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        private MouseInputHandler() {
        }

        private void adjust(Rectangle rectangle, Dimension dimension, int n2, int n3, int n4, int n5) {
            rectangle.x += n2;
            rectangle.y += n3;
            rectangle.width += n4;
            rectangle.height += n5;
            if (dimension != null) {
                int n6;
                if (rectangle.width < dimension.width) {
                    n6 = dimension.width - rectangle.width;
                    if (n2 != 0) {
                        rectangle.x -= n6;
                    }
                    rectangle.width = dimension.width;
                }
                if (rectangle.height < dimension.height) {
                    n6 = dimension.height - rectangle.height;
                    if (n3 != 0) {
                        rectangle.y -= n6;
                    }
                    rectangle.height = dimension.height;
                }
            }
        }
    }
}

