/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    protected JTabbedPane tabPane;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected Color darkShadow;
    protected Color focus;
    private Color selectedColor;
    protected int textIconGap;
    protected int tabRunOverlay;
    protected Insets tabInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets contentBorderInsets;
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected FocusListener focusListener;
    private ContainerListener containerListener;
    private Insets currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private ScrollableTabSupport tabScroller;
    protected transient Rectangle calcRect = new Rectangle(0, 0, 0, 0);
    private int tabCount;
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    protected void expandTabRunsArray() {
        int n2 = this.tabRuns.length;
        int[] nArray = new int[n2 + 10];
        System.arraycopy(this.tabRuns, 0, nArray, 0, this.runCount);
        this.tabRuns = nArray;
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.tabPane.add(this.tabScroller.scrollForwardButton);
            this.tabPane.add(this.tabScroller.scrollBackwardButton);
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.highlight = UIManager.getColor("TabbedPane.light");
        this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.selectedColor = UIManager.getColor("TabbedPane.selected");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, actionMap);
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.scrollForwardButton.setAction(actionMap.get("scrollTabsForwardAction"));
            this.tabScroller.scrollBackwardButton.setAction(actionMap.get("scrollTabsBackwardAction"));
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
            } else {
                this.tabPane.addMouseListener(this.mouseListener);
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        if ((this.containerListener = new ContainerHandler()) != null) {
            this.tabPane.addContainerListener(this.containerListener);
            if (this.tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    protected void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    protected void uninstallDefaults() {
        this.highlight = null;
        this.lightHighlight = null;
        this.shadow = null;
        this.darkShadow = null;
        this.focus = null;
        this.tabInsets = null;
        this.selectedTabPadInsets = null;
        this.tabAreaInsets = null;
        this.contentBorderInsets = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            } else {
                this.tabPane.removeMouseListener(this.mouseListener);
            }
            this.mouseListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        for (int i2 = this.tabPane.getTabCount() - 1; i2 >= 0; --i2) {
            int n2 = this.tabPane.getMnemonicAt(i2);
            if (n2 <= 0) continue;
            this.addMnemonic(i2, n2);
        }
    }

    boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component.isFocusTraversable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected int calculateMaxTabHeight(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        int n5 = fontMetrics.getHeight();
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = Math.max(this.calculateTabHeight(n2, i2, n5), n4);
        }
        return n4;
    }

    protected int calculateMaxTabWidth(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = Math.max(this.calculateTabWidth(n2, i2, fontMetrics), n4);
        }
        return n4;
    }

    protected int getNextTabIndex(int n2) {
        return (n2 + 1) % this.tabPane.getTabCount();
    }

    protected int getNextTabRun(int n2) {
        return (n2 + 1) % this.runCount;
    }

    protected int getPreviousTabIndex(int n2) {
        int n3 = n2 - 1 >= 0 ? n2 - 1 : this.tabPane.getTabCount() - 1;
        return n3 >= 0 ? n3 : 0;
    }

    protected int getPreviousTabRun(int n2) {
        int n3 = n2 - 1 >= 0 ? n2 - 1 : this.runCount - 1;
        return n3 >= 0 ? n3 : 0;
    }

    protected int getTabRunOverlay(int n2) {
        return this.tabRunOverlay;
    }

    protected void assureRectsCreated(int n2) {
        int n3 = this.rects.length;
        if (n2 != n3) {
            Rectangle[] rectangleArray = new Rectangle[n2];
            System.arraycopy(this.rects, 0, rectangleArray, 0, Math.min(n3, n2));
            this.rects = rectangleArray;
            for (int i2 = n3; i2 < n2; ++i2) {
                this.rects[i2] = new Rectangle();
            }
        }
    }

    protected void navigateSelectedTab(int n2) {
        int n3 = this.tabPane.getTabPlacement();
        int n4 = this.tabPane.getSelectedIndex();
        int n5 = this.tabPane.getTabCount();
        boolean bl2 = BasicGraphicsUtils.isLeftToRight(this.tabPane);
        if (n5 <= 0) {
            return;
        }
        block0 : switch (n3) {
            case 12: {
                this.selectNextTab(n4);
                break;
            }
            case 13: {
                this.selectPreviousTab(n4);
                break;
            }
            case 2: 
            case 4: {
                switch (n2) {
                    case 1: {
                        this.selectPreviousTabInRun(n4);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(n4);
                        break block0;
                    }
                    case 7: {
                        int n6 = this.getTabRunOffset(n3, n5, n4, false);
                        this.selectAdjacentRunTab(n3, n4, n6);
                        break block0;
                    }
                    case 3: {
                        int n7 = this.getTabRunOffset(n3, n5, n4, true);
                        this.selectAdjacentRunTab(n3, n4, n7);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (n2) {
                    case 1: {
                        int n8 = this.getTabRunOffset(n3, n5, n4, false);
                        this.selectAdjacentRunTab(n3, n4, n8);
                        break block0;
                    }
                    case 5: {
                        int n9 = this.getTabRunOffset(n3, n5, n4, true);
                        this.selectAdjacentRunTab(n3, n4, n9);
                        break block0;
                    }
                    case 3: {
                        if (bl2) {
                            this.selectNextTabInRun(n4);
                            break block0;
                        }
                        this.selectPreviousTabInRun(n4);
                        break block0;
                    }
                    case 7: {
                        if (bl2) {
                            this.selectPreviousTabInRun(n4);
                            break block0;
                        }
                        this.selectNextTabInRun(n4);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTab(int n2) {
        int n3 = this.getNextTabIndex(n2);
        while (n3 != n2 && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getNextTabIndex(n3);
        }
        this.tabPane.setSelectedIndex(n3);
    }

    protected void selectNextTabInRun(int n2) {
        int n3 = this.tabPane.getTabCount();
        int n4 = this.getNextTabIndexInRun(n3, n2);
        while (n4 != n2 && !this.tabPane.isEnabledAt(n4)) {
            n4 = this.getNextTabIndexInRun(n3, n4);
        }
        this.tabPane.setSelectedIndex(n4);
    }

    protected void selectPreviousTab(int n2) {
        int n3 = this.getPreviousTabIndex(n2);
        while (n3 != n2 && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getPreviousTabIndex(n3);
        }
        this.tabPane.setSelectedIndex(n3);
    }

    protected void selectPreviousTabInRun(int n2) {
        int n3 = this.tabPane.getTabCount();
        int n4 = this.getPreviousTabIndexInRun(n3, n2);
        while (n4 != n2 && !this.tabPane.isEnabledAt(n4)) {
            n4 = this.getPreviousTabIndexInRun(n3, n4);
        }
        this.tabPane.setSelectedIndex(n4);
    }

    protected boolean shouldRotateTabRuns(int n2) {
        return true;
    }

    private int getClosestTab(int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = n5 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n8 = this.tabPane.getTabPlacement();
        boolean bl2 = n8 == 1 || n8 == 3;
        int n9 = n4 = bl2 ? n2 : n3;
        while (n6 != n7) {
            int n10;
            int n11;
            int n12 = (n7 + n6) / 2;
            if (bl2) {
                n11 = this.rects[n12].x;
                n10 = n11 + this.rects[n12].width;
            } else {
                n11 = this.rects[n12].y;
                n10 = n11 + this.rects[n12].height;
            }
            if (n4 < n11) {
                n7 = n12;
                if (n6 != n7) continue;
                return Math.max(0, n12 - 1);
            }
            if (n4 >= n10) {
                n6 = n12;
                if (n7 - n6 > 1) continue;
                return Math.max(n12 + 1, n5 - 1);
            }
            return n12;
        }
        return n6;
    }

    protected int getNextTabIndexInRun(int n2, int n3) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(n3);
        }
        int n4 = this.getRunForTab(n2, n3);
        int n5 = this.getNextTabIndex(n3);
        if (n5 == this.tabRuns[this.getNextTabRun(n4)]) {
            return this.tabRuns[n4];
        }
        return n5;
    }

    protected int getPreviousTabIndexInRun(int n2, int n3) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(n3);
        }
        int n4 = this.getRunForTab(n2, n3);
        if (n3 == this.tabRuns[n4]) {
            int n5 = this.tabRuns[this.getNextTabRun(n4)] - 1;
            return n5 != -1 ? n5 : n2 - 1;
        }
        return this.getPreviousTabIndex(n3);
    }

    protected int getRunForTab(int n2, int n3) {
        for (int i2 = 0; i2 < this.runCount; ++i2) {
            int n4 = this.tabRuns[i2];
            int n5 = this.lastTabInRun(n2, i2);
            if (n3 < n4 || n3 > n5) continue;
            return i2;
        }
        return 0;
    }

    private int getTabAtLocation(int n2, int n3) {
        this.ensureCurrentLayout();
        int n4 = this.tabPane.getTabCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!this.rects[i2].contains(n2, n3)) continue;
            return i2;
        }
        return -1;
    }

    protected int getTabRunIndent(int n2, int n3) {
        return 0;
    }

    protected int lastTabInRun(int n2, int n3) {
        int n4;
        if (this.runCount == 1) {
            return n2 - 1;
        }
        int n5 = n4 = n3 == this.runCount - 1 ? 0 : n3 + 1;
        if (this.tabRuns[n4] == 0) {
            return n2 - 1;
        }
        return this.tabRuns[n4] - 1;
    }

    private void addMnemonic(int n2, int n3) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(n3, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(n3), new Integer(n2));
    }

    protected boolean shouldPadTabRun(int n2, int n3) {
        return this.runCount > 1;
    }

    protected int calculateTabAreaHeight(int n2, int n3, int n4) {
        Insets insets = this.getTabAreaInsets(n2);
        int n5 = this.getTabRunOverlay(n2);
        return n3 > 0 ? n3 * (n4 - n5) + n5 + insets.top + insets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int n2, int n3, int n4) {
        Insets insets = this.getTabAreaInsets(n2);
        int n5 = this.getTabRunOverlay(n2);
        return n3 > 0 ? n3 * (n4 - n5) + n5 + insets.left + insets.right : 0;
    }

    protected int calculateTabHeight(int n2, int n3, int n4) {
        int n5 = 0;
        View view = this.getTextViewForTab(n3);
        n5 = view != null ? (n5 += (int)view.getPreferredSpan(1)) : (n5 += n4);
        Icon icon = this.getIconForTab(n3);
        Insets insets = this.getTabInsets(n2, n3);
        if (icon != null) {
            n5 = Math.max(n5, icon.getIconHeight());
        }
        return n5 += insets.top + insets.bottom + 2;
    }

    protected void selectAdjacentRunTab(int n2, int n3, int n4) {
        int n5;
        if (this.runCount < 2) {
            return;
        }
        Rectangle rectangle = this.rects[n3];
        switch (n2) {
            case 2: 
            case 4: {
                n5 = this.getTabAtLocation(rectangle.x + rectangle.width / 2 + n4, rectangle.y + rectangle.height / 2);
                break;
            }
            default: {
                n5 = this.getTabAtLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + n4);
            }
        }
        if (n5 != -1) {
            while (!this.tabPane.isEnabledAt(n5) && n5 != n3) {
                n5 = this.getNextTabIndex(n5);
            }
            this.tabPane.setSelectedIndex(n5);
        }
    }

    protected int getTabRunOffset(int n2, int n3, int n4, boolean bl2) {
        int n5;
        int n6 = this.getRunForTab(n3, n4);
        switch (n2) {
            case 2: {
                if (n6 == 0) {
                    n5 = bl2 ? -(this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (n6 == this.runCount - 1) {
                    n5 = bl2 ? this.maxTabWidth : this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                n5 = bl2 ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (n6 == 0) {
                    n5 = bl2 ? this.maxTabWidth : this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (n6 == this.runCount - 1) {
                    n5 = bl2 ? -(this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                n5 = bl2 ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (n6 == 0) {
                    n5 = bl2 ? this.maxTabHeight : this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (n6 == this.runCount - 1) {
                    n5 = bl2 ? -(this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                n5 = bl2 ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                n5 = n6 == 0 ? (bl2 ? -(this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (n6 == this.runCount - 1 ? (bl2 ? this.maxTabHeight : this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (bl2 ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return n5;
    }

    protected int getTabLabelShiftX(int n2, int n3, boolean bl2) {
        Rectangle rectangle = this.rects[n3];
        int n4 = 0;
        switch (n2) {
            case 2: {
                n4 = bl2 ? -1 : 1;
                break;
            }
            case 4: {
                n4 = bl2 ? 1 : -1;
                break;
            }
            default: {
                n4 = rectangle.width % 2;
            }
        }
        return n4;
    }

    protected int getTabLabelShiftY(int n2, int n3, boolean bl2) {
        Rectangle rectangle = this.rects[n3];
        int n4 = 0;
        switch (n2) {
            case 3: {
                n4 = bl2 ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                n4 = rectangle.height % 2;
                break;
            }
            default: {
                n4 = bl2 ? -1 : 1;
            }
        }
        return n4;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    protected int calculateTabWidth(int n2, int n3, FontMetrics fontMetrics) {
        View view;
        Icon icon = this.getIconForTab(n3);
        Insets insets = this.getTabInsets(n2, n3);
        int n4 = insets.left + insets.right + 3;
        if (icon != null) {
            n4 += icon.getIconWidth() + this.textIconGap;
        }
        if ((view = this.getTextViewForTab(n3)) != null) {
            n4 += (int)view.getPreferredSpan(0);
        } else {
            String string = this.tabPane.getTitleAt(n3);
            n4 += SwingUtilities.computeStringWidth(fontMetrics, string);
        }
        return n4;
    }

    protected void paintContentBorder(Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getWidth();
        int n5 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n6 = insets.left;
        int n7 = insets.top;
        int n8 = n4 - insets.right - insets.left;
        int n9 = n5 - insets.top - insets.bottom;
        switch (n2) {
            case 2: {
                n8 -= (n6 += this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n8 -= this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n9 -= this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n9 -= (n7 += this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        if (this.selectedColor == null) {
            graphics.setColor(this.tabPane.getBackground());
        } else {
            graphics.setColor(this.selectedColor);
        }
        graphics.fillRect(n6, n7, n8, n9);
        this.paintContentBorderTopEdge(graphics, n2, n3, n6, n7, n8, n9);
        this.paintContentBorderLeftEdge(graphics, n2, n3, n6, n7, n8, n9);
        this.paintContentBorderBottomEdge(graphics, n2, n3, n6, n7, n8, n9);
        this.paintContentBorderRightEdge(graphics, n2, n3, n6, n7, n8, n9);
    }

    protected void paintTabArea(Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        for (int i2 = this.runCount - 1; i2 >= 0; --i2) {
            int n5 = this.tabRuns[i2];
            int n6 = this.tabRuns[i2 == this.runCount - 1 ? 0 : i2 + 1];
            int n7 = n6 != 0 ? n6 - 1 : n4 - 1;
            for (int i3 = n5; i3 <= n7; ++i3) {
                if (!this.rects[i3].intersects(rectangle3)) continue;
                this.paintTab(graphics, n2, this.rects, i3, rectangle, rectangle2);
            }
        }
        if (n3 >= 0 && this.getRunForTab(n4, n3) == 0 && this.rects[n3].intersects(rectangle3)) {
            this.paintTab(graphics, n2, this.rects, n3, rectangle, rectangle2);
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.shadow);
        if (n2 != 3 || n3 < 0 || rectangle.y - 1 > n7 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
        } else {
            graphics.drawLine(n4 + 1, n5 + n7 - 2, rectangle.x - 1, n5 + n7 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4, n5 + n7 - 1, rectangle.x - 1, n5 + n7 - 1);
            if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                graphics.setColor(this.shadow);
                graphics.drawLine(rectangle.x + rectangle.width, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(rectangle.x + rectangle.width, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (n2 != 2 || n3 < 0 || rectangle.x + rectangle.width + 1 < n4 || rectangle.y < n5 || rectangle.y > n5 + n7) {
            graphics.drawLine(n4, n5, n4, n5 + n7 - 2);
        } else {
            graphics.drawLine(n4, n5, n4, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n5 + n7 - 2) {
                graphics.drawLine(n4, rectangle.y + rectangle.height, n4, n5 + n7 - 2);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.shadow);
        if (n2 != 4 || n3 < 0 || rectangle.x - 1 > n6 || rectangle.y < n5 || rectangle.y > n5 + n7) {
            graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + n7 - 3);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 1);
        } else {
            graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, rectangle.y - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n5 + n7 - 2) {
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + n6 - 2, rectangle.y + rectangle.height, n4 + n6 - 2, n5 + n7 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + n6 - 1, rectangle.y + rectangle.height, n4 + n6 - 1, n5 + n7 - 2);
            }
        }
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (n2 != 1 || n3 < 0 || rectangle.y + rectangle.height + 1 < n5 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            graphics.drawLine(n4, n5, n4 + n6 - 2, n5);
        } else {
            graphics.drawLine(n4, n5, rectangle.x - 1, n5);
            if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n5, n4 + n6 - 2, n5);
            } else {
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + n6 - 2, n5, n4 + n6 - 2, n5);
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        graphics.setColor(!bl2 || this.selectedColor == null ? this.tabPane.getBackgroundAt(n3) : this.selectedColor);
        switch (n2) {
            case 2: {
                graphics.fillRect(n4 + 1, n5 + 1, n6 - 2, n7 - 3);
                break;
            }
            case 4: {
                graphics.fillRect(n4, n5 + 1, n6 - 2, n7 - 3);
                break;
            }
            case 3: {
                graphics.fillRect(n4 + 1, n5, n6 - 3, n7 - 1);
                break;
            }
            default: {
                graphics.fillRect(n4 + 1, n5 + 1, n6 - 3, n7 - 1);
            }
        }
    }

    protected void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        graphics.setColor(this.lightHighlight);
        switch (n2) {
            case 2: {
                graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 3);
                graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                graphics.drawLine(n4 + 2, n5, n4 + n6 - 1, n5);
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + n6 - 1, n5 + n7 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
                break;
            }
            case 4: {
                graphics.drawLine(n4, n5, n4 + n6 - 3, n5);
                graphics.setColor(this.shadow);
                graphics.drawLine(n4, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 3);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 3);
                graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                break;
            }
            case 3: {
                graphics.drawLine(n4, n5, n4, n5 + n7 - 3);
                graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 2, n5, n4 + n6 - 2, n5 + n7 - 3);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 3);
                break;
            }
            default: {
                graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 1);
                graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                graphics.drawLine(n4 + 2, n5, n4 + n6 - 3, n5);
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 1);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 1);
                graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
            }
        }
    }

    private void paintCroppedTabEdge(Graphics graphics, int n2, int n3, boolean bl2, int n4, int n5) {
        switch (n2) {
            case 2: 
            case 4: {
                graphics.setColor(this.shadow);
                for (int i2 = n4; i2 <= n4 + this.rects[n3].width; i2 += 12) {
                    for (int i3 = 0; i3 < this.xCropLen.length; i3 += 2) {
                        graphics.drawLine(i2 + this.yCropLen[i3], n5 - this.xCropLen[i3], i2 + this.yCropLen[i3 + 1] - 1, n5 - this.xCropLen[i3 + 1]);
                    }
                }
                break;
            }
            default: {
                graphics.setColor(this.shadow);
                for (int i4 = n5; i4 <= n5 + this.rects[n3].height; i4 += 12) {
                    for (int i5 = 0; i5 < this.xCropLen.length; i5 += 2) {
                        graphics.drawLine(n4 - this.xCropLen[i5], i4 + this.yCropLen[i5], n4 - this.xCropLen[i5 + 1], i4 + this.yCropLen[i5 + 1] - 1);
                    }
                }
            }
        }
    }

    protected Insets getContentBorderInsets(int n2) {
        return this.contentBorderInsets;
    }

    protected Insets getSelectedTabPadInsets(int n2) {
        BasicTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, this.currentPadInsets, n2);
        return this.currentPadInsets;
    }

    protected Insets getTabAreaInsets(int n2) {
        BasicTabbedPaneUI.rotateInsets(this.tabAreaInsets, this.currentTabAreaInsets, n2);
        return this.currentTabAreaInsets;
    }

    protected Insets getTabInsets(int n2, int n3) {
        return this.tabInsets;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    private Vector createHTMLVector() {
        Vector vector = new Vector();
        int n2 = this.tabPane.getTabCount();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = this.tabPane.getTitleAt(i2);
                if (BasicHTML.isHTMLString(string)) {
                    vector.addElement(BasicHTML.createHTMLView(this.tabPane, string));
                    continue;
                }
                vector.addElement(null);
            }
        }
        return vector;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("navigateNext", new NextAction());
        actionMapUIResource.put("navigatePrevious", new PreviousAction());
        actionMapUIResource.put("navigateRight", new RightAction());
        actionMapUIResource.put("navigateLeft", new LeftAction());
        actionMapUIResource.put("navigateUp", new UpAction());
        actionMapUIResource.put("navigateDown", new DownAction());
        actionMapUIResource.put("navigatePageUp", new PageUpAction());
        actionMapUIResource.put("navigatePageDown", new PageDownAction());
        actionMapUIResource.put("requestFocus", new RequestFocusAction());
        actionMapUIResource.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        actionMapUIResource.put("setSelectedIndex", new SetSelectedIndexAction());
        actionMapUIResource.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        actionMapUIResource.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        return actionMapUIResource;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("TabbedPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("TabbedPane.actionMap", actionMap);
        }
        return actionMap;
    }

    protected Icon getIconForTab(int n2) {
        return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n2) ? this.tabPane.getDisabledIconAt(n2) : this.tabPane.getIconAt(n2);
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            return (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        }
        if (n2 == 0) {
            return (InputMap)UIManager.get("TabbedPane.focusInputMap");
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        this.tabPane = (JTabbedPane)jComponent;
        jComponent.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        jComponent.setLayout(null);
        this.tabPane = null;
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n2, int n3) {
        this.ensureCurrentLayout();
        Point point = new Point(n2, n3);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n2, n3, point);
        }
        int n4 = this.tabPane.getTabCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!this.rects[i2].contains(point.x, point.y)) continue;
            return i2;
        }
        return -1;
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected View getTextViewForTab(int n2) {
        if (this.htmlViews != null) {
            return (View)this.htmlViews.elementAt(n2);
        }
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n2) {
        switch (n2) {
            case 2: {
                insets2.top = insets.left;
                insets2.left = insets.top;
                insets2.bottom = insets.right;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.left;
                insets2.bottom = insets.top;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    private Point translatePointToTabPanel(int n2, int n3, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n2 + point2.x + point3.x;
        point.y = n3 + point2.y + point3.y;
        return point;
    }

    private Polygon createCroppedTabClip(int n2, Rectangle rectangle, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        switch (n2) {
            case 2: 
            case 4: {
                n4 = rectangle.width;
                n5 = rectangle.x;
                n6 = rectangle.x + rectangle.width;
                n7 = rectangle.y;
                break;
            }
            default: {
                n4 = rectangle.height;
                n5 = rectangle.y;
                n6 = rectangle.y + rectangle.height;
                n7 = rectangle.x;
            }
        }
        int n8 = n4 / 12;
        if (n4 % 12 > 0) {
            ++n8;
        }
        int n9 = 2 + n8 * 8;
        int[] nArray = new int[n9];
        int[] nArray2 = new int[n9];
        int n10 = 0;
        nArray[n10] = n7;
        nArray2[n10++] = n6;
        nArray[n10] = n7;
        nArray2[n10++] = n5;
        block3: for (int i2 = 0; i2 < n8; ++i2) {
            for (int i3 = 0; i3 < this.xCropLen.length; ++i3) {
                nArray[n10] = n3 - this.xCropLen[i3];
                nArray2[n10] = n5 + i2 * 12 + this.yCropLen[i3];
                if (nArray2[n10] >= n6) {
                    nArray2[n10] = n6;
                    ++n10;
                    continue block3;
                }
                ++n10;
            }
        }
        if (n2 == 1 || n2 == 3) {
            return new Polygon(nArray, nArray2, n10);
        }
        return new Polygon(nArray2, nArray, n10);
    }

    protected Rectangle getTabBounds(int n2, Rectangle rectangle) {
        rectangle.width = this.rects[n2].width;
        rectangle.height = this.rects[n2].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this.tabScroller.viewport.getLocation();
            Point point2 = this.tabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n2].x + point.x - point2.x;
            rectangle.y = this.rects[n2].y + point.y - point2.y;
        } else {
            rectangle.x = this.rects[n2].x;
            rectangle.y = this.rects[n2].y;
        }
        return rectangle;
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n2) {
        this.ensureCurrentLayout();
        Rectangle rectangle = new Rectangle();
        return this.getTabBounds(n2, rectangle);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n2 = this.tabPane.getTabCount();
        if (this.tabCount != n2) {
            this.tabCount = n2;
            this.updateMnemonics();
        }
        int n3 = this.tabPane.getSelectedIndex();
        int n4 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(graphics, n4, n3);
        }
        this.paintContentBorder(graphics, n4, n3);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTabbedPaneUI();
    }

    protected void paintIcon(Graphics graphics, int n2, int n3, Icon icon, Rectangle rectangle, boolean bl2) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintTab(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Rectangle rectangle3 = rectangleArray[n3];
        int n4 = this.tabPane.getSelectedIndex();
        boolean bl2 = n4 == n3;
        Graphics2D graphics2D = null;
        Polygon polygon = null;
        Shape shape = null;
        int n5 = 0;
        int n6 = 0;
        if (this.scrollableTabLayoutEnabled() && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            object = this.tabScroller.viewport.getViewRect();
            switch (n2) {
                case 2: 
                case 4: {
                    int n7 = ((Rectangle)object).y + ((Rectangle)object).height;
                    if (rectangle3.y >= n7 || rectangle3.y + rectangle3.height <= n7) break;
                    polygon = this.createCroppedTabClip(n2, rectangle3, n7);
                    n5 = rectangle3.x;
                    n6 = n7 - 1;
                    break;
                }
                default: {
                    int n7 = ((Rectangle)object).x + ((Rectangle)object).width;
                    if (rectangle3.x >= n7 || rectangle3.x + rectangle3.width <= n7) break;
                    polygon = this.createCroppedTabClip(n2, rectangle3, n7);
                    n5 = n7 - 1;
                    n6 = rectangle3.y;
                }
            }
            if (polygon != null) {
                shape = graphics2D.getClip();
                graphics2D.clip(polygon);
            }
        }
        this.paintTabBackground(graphics, n2, n3, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl2);
        this.paintTabBorder(graphics, n2, n3, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl2);
        object = this.tabPane.getTitleAt(n3);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n3);
        this.layoutLabel(n2, fontMetrics, n3, (String)object, icon, rectangle3, rectangle, rectangle2, bl2);
        this.paintText(graphics, n2, font, fontMetrics, n3, (String)object, rectangle2, bl2);
        this.paintIcon(graphics, n2, n3, icon, rectangle, bl2);
        this.paintFocusIndicator(graphics, n2, rectangleArray, n3, rectangle, rectangle2, bl2);
        if (polygon != null) {
            this.paintCroppedTabEdge(graphics, n2, n3, bl2, n5, n6);
            graphics2D.setClip(shape);
        }
    }

    protected void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
        Rectangle rectangle3 = rectangleArray[n3];
        if (this.tabPane.hasFocus() && bl2) {
            int n4;
            int n5;
            int n6;
            int n7;
            graphics.setColor(this.focus);
            switch (n2) {
                case 2: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 5;
                    n4 = rectangle3.height - 6;
                    break;
                }
                case 4: {
                    n7 = rectangle3.x + 2;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 5;
                    n4 = rectangle3.height - 6;
                    break;
                }
                case 3: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 2;
                    n5 = rectangle3.width - 6;
                    n4 = rectangle3.height - 5;
                    break;
                }
                default: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 6;
                    n4 = rectangle3.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(graphics, n7, n6, n5, n4);
        }
    }

    protected void paintText(Graphics graphics, int n2, Font font, FontMetrics fontMetrics, int n3, String string, Rectangle rectangle, boolean bl2) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            int n4 = this.tabPane.getDisplayedMnemonicIndexAt(n3);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n3)) {
                graphics.setColor(this.tabPane.getForegroundAt(n3));
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n3).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n3).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }

    protected void layoutLabel(int n2, FontMetrics fontMetrics, int n3, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl2) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int n4 = this.getTabLabelShiftX(n2, n3, bl2);
        int n5 = this.getTabLabelShiftY(n2, n3, bl2);
        rectangle2.x += n4;
        rectangle2.y += n5;
        rectangle3.x += n4;
        rectangle3.y += n5;
    }

    private class ContainerHandler
    implements ContainerListener {
        public void componentAdded(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            int n2 = jTabbedPane.indexOfComponent(component);
            String string = jTabbedPane.getTitleAt(n2);
            boolean bl2 = BasicHTML.isHTMLString(string);
            if (bl2) {
                if (BasicTabbedPaneUI.this.htmlViews == null) {
                    BasicTabbedPaneUI.this.htmlViews = BasicTabbedPaneUI.this.createHTMLVector();
                } else {
                    View view = BasicHTML.createHTMLView(jTabbedPane, string);
                    BasicTabbedPaneUI.this.htmlViews.insertElementAt(view, n2);
                }
            } else if (BasicTabbedPaneUI.this.htmlViews != null) {
                BasicTabbedPaneUI.this.htmlViews.insertElementAt(null, n2);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            Integer n2 = (Integer)jTabbedPane.getClientProperty("__index_to_remove__");
            if (n2 != null) {
                int n3 = n2;
                if (BasicTabbedPaneUI.this.htmlViews != null && BasicTabbedPaneUI.this.htmlViews.size() >= n3) {
                    BasicTabbedPaneUI.this.htmlViews.removeElementAt(n3);
                }
            }
        }

        private ContainerHandler() {
        }
    }

    private static class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(5);
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n2 = jTabbedPane.getTabCount();
            int n3 = jTabbedPane.getSelectedIndex();
            if (n3 != -1 && n2 > 0 && n2 == BasicTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(BasicTabbedPaneUI.this.getTabBounds(jTabbedPane, n3));
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n2 = jTabbedPane.getTabCount();
            int n3 = jTabbedPane.getSelectedIndex();
            if (n3 != -1 && n2 > 0 && n2 == BasicTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(BasicTabbedPaneUI.this.getTabBounds(jTabbedPane, n3));
            }
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(7);
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n2 = BasicTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n2 >= 0 && BasicTabbedPaneUI.this.tabPane.isEnabledAt(n2)) {
                if (n2 == BasicTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (BasicTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        BasicTabbedPaneUI.this.tabPane.requestFocus();
                        BasicTabbedPaneUI.this.tabPane.repaint(BasicTabbedPaneUI.this.getTabBounds(BasicTabbedPaneUI.this.tabPane, n2));
                    }
                } else {
                    BasicTabbedPaneUI.this.tabPane.setSelectedIndex(n2);
                }
            }
        }
    }

    private static class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(12);
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            int n2 = jTabbedPane.getTabPlacement();
            if (n2 == 1 || n2 == 3) {
                basicTabbedPaneUI.navigateSelectedTab(3);
            } else {
                basicTabbedPaneUI.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            int n2 = jTabbedPane.getTabPlacement();
            if (n2 == 1 || n2 == 3) {
                basicTabbedPaneUI.navigateSelectedTab(7);
            } else {
                basicTabbedPaneUI.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(13);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("mnemonicAt".equals(string)) {
                BasicTabbedPaneUI.this.updateMnemonics();
                jTabbedPane.repaint();
            } else if ("displayedMnemonicIndexAt".equals(string)) {
                jTabbedPane.repaint();
            } else if (string.equals("indexForTitle")) {
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                String string2 = BasicTabbedPaneUI.this.tabPane.getTitleAt(n2);
                if (BasicHTML.isHTMLString(string2)) {
                    if (BasicTabbedPaneUI.this.htmlViews == null) {
                        BasicTabbedPaneUI.this.htmlViews = BasicTabbedPaneUI.this.createHTMLVector();
                    } else {
                        View view = BasicHTML.createHTMLView(BasicTabbedPaneUI.this.tabPane, string2);
                        BasicTabbedPaneUI.this.htmlViews.setElementAt(view, n2);
                    }
                } else if (BasicTabbedPaneUI.this.htmlViews != null && BasicTabbedPaneUI.this.htmlViews.elementAt(n2) != null) {
                    BasicTabbedPaneUI.this.htmlViews.setElementAt(null, n2);
                }
                BasicTabbedPaneUI.this.updateMnemonics();
            } else if (string.equals("tabLayoutPolicy")) {
                BasicTabbedPaneUI.this.uninstallUI(jTabbedPane);
                BasicTabbedPaneUI.this.installUI(jTabbedPane);
            }
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            jTabbedPane.requestFocus();
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.requestFocusForVisibleComponent();
        }
    }

    private static class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(3);
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private ScrollTabsBackwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            if (basicTabbedPaneUI.scrollableTabLayoutEnabled()) {
                basicTabbedPaneUI.tabScroller.scrollBackward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private ScrollTabsForwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            if (basicTabbedPaneUI.scrollableTabLayoutEnabled()) {
                basicTabbedPaneUI.tabScroller.scrollForward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public boolean scrollsForward() {
            return this.direction == 3 || this.direction == 5;
        }

        public ScrollableTabButton(int n2) {
            super(n2, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            BasicTabbedPaneUI.this.paintTabArea(graphics, BasicTabbedPaneUI.this.tabPane.getTabPlacement(), BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
        }

        public ScrollableTabPanel() {
            this.setLayout(null);
        }
    }

    private class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public ScrollableTabButton scrollForwardButton;
        public ScrollableTabButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        public void scrollBackward(int n2) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(n2, this.leadingTabIndex - 1);
        }

        public void scrollForward(int n2) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n2 == 1 || n2 == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n2, this.leadingTabIndex + 1);
        }

        public void setLeadingTabIndex(int n2, int n3) {
            this.leadingTabIndex = n3;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n2) {
                case 1: 
                case 3: {
                    int n4 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : BasicTabbedPaneUI.this.rects[this.leadingTabIndex].x;
                    if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                    Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                    this.viewport.setExtentSize(dimension2);
                    break;
                }
                case 2: 
                case 4: {
                    int n5 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : BasicTabbedPaneUI.this.rects[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    Dimension dimension3 = new Dimension(rectangle.width, dimension.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(dimension3);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle rectangle = jViewport.getBounds();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            this.leadingTabIndex = BasicTabbedPaneUI.this.getClosestTab(rectangle2.x, rectangle2.y);
            if (this.leadingTabIndex + 1 < n3) {
                switch (n2) {
                    case 1: 
                    case 3: {
                        if (BasicTabbedPaneUI.this.rects[this.leadingTabIndex].x >= rectangle2.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (BasicTabbedPaneUI.this.rects[this.leadingTabIndex].y >= rectangle2.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = BasicTabbedPaneUI.this.getContentBorderInsets(n2);
            switch (n2) {
                case 2: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                }
            }
        }

        ScrollableTabSupport(int n2) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            if (n2 == 1 || n2 == 3) {
                this.scrollForwardButton = new ScrollableTabButton(3);
                this.scrollBackwardButton = new ScrollableTabButton(7);
            } else {
                this.scrollForwardButton = new ScrollableTabButton(5);
                this.scrollBackwardButton = new ScrollableTabButton(1);
            }
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setScrollMode(0);
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            if (jTabbedPane != null && jTabbedPane.getUI() instanceof BasicTabbedPaneUI) {
                BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() > 0) {
                    Integer n2;
                    int n3 = actionEvent.getActionCommand().charAt(0);
                    if (n3 >= 97 && n3 <= 122) {
                        n3 -= 32;
                    }
                    if ((n2 = (Integer)basicTabbedPaneUI.mnemonicToIndexMap.get(new Integer(n3))) != null && jTabbedPane.isEnabledAt(n2)) {
                        jTabbedPane.setSelectedIndex(n2);
                    }
                }
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            int n2;
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
            if (jTabbedPane.getTabLayoutPolicy() == 1 && (n2 = jTabbedPane.getSelectedIndex()) < BasicTabbedPaneUI.this.rects.length && n2 != -1) {
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.scrollRectToVisible(BasicTabbedPaneUI.this.rects[n2]);
            }
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        public void calculateLayoutInfo() {
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            BasicTabbedPaneUI.this.assureRectsCreated(n2);
            this.calculateTabRects(BasicTabbedPaneUI.this.tabPane.getTabPlacement(), n2);
        }

        protected int preferredTabAreaHeight(int n2, int n3) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            int n4 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int n5 = 0;
            if (n4 > 0) {
                int n6 = 1;
                int n7 = 0;
                int n8 = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n9 = BasicTabbedPaneUI.this.calculateTabWidth(n2, i2, fontMetrics);
                    if (n7 != 0 && n7 + n9 > n3) {
                        ++n6;
                        n7 = 0;
                    }
                    n7 += n9;
                }
                n5 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, n6, n8);
            }
            return n5;
        }

        protected int preferredTabAreaWidth(int n2, int n3) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            int n4 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int n5 = 0;
            if (n4 > 0) {
                int n6 = 1;
                int n7 = 0;
                int n8 = fontMetrics.getHeight();
                BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n9 = BasicTabbedPaneUI.this.calculateTabHeight(n2, i2, n8);
                    if (n7 != 0 && n7 + n9 > n3) {
                        ++n6;
                        n7 = 0;
                    }
                    n7 += n9;
                }
                n5 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, n6, BasicTabbedPaneUI.this.maxTabWidth);
            }
            return n5;
        }

        protected void calculateTabRects(int n2, int n3) {
            int n4;
            Rectangle rectangle;
            int n5;
            int n6;
            int n7;
            int n8;
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getTabAreaInsets(n2);
            int n9 = fontMetrics.getHeight();
            int n10 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl2 = n2 == 2 || n2 == 4;
            boolean bl3 = BasicGraphicsUtils.isLeftToRight(BasicTabbedPaneUI.this.tabPane);
            switch (n2) {
                case 2: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                    n8 = insets.left + insets2.left;
                    n7 = insets.top + insets2.top;
                    n6 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                    n8 = dimension.width - insets.right - insets2.right - BasicTabbedPaneUI.this.maxTabWidth;
                    n7 = insets.top + insets2.top;
                    n6 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                    n8 = insets.left + insets2.left;
                    n7 = dimension.height - insets.bottom - insets2.bottom - BasicTabbedPaneUI.this.maxTabHeight;
                    n6 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                    n8 = insets.left + insets2.left;
                    n7 = insets.top + insets2.top;
                    n6 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n11 = BasicTabbedPaneUI.this.getTabRunOverlay(n2);
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            if (n3 == 0) {
                return;
            }
            for (n5 = 0; n5 < n3; ++n5) {
                rectangle = BasicTabbedPaneUI.this.rects[n5];
                if (!bl2) {
                    if (n5 > 0) {
                        rectangle.x = BasicTabbedPaneUI.this.rects[n5 - 1].x + BasicTabbedPaneUI.this.rects[n5 - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        rectangle.x = n8;
                    }
                    rectangle.width = BasicTabbedPaneUI.this.calculateTabWidth(n2, n5, fontMetrics);
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n6) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n5;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.x = n8;
                    }
                    rectangle.y = n7;
                    rectangle.height = BasicTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n5 > 0) {
                        rectangle.y = BasicTabbedPaneUI.this.rects[n5 - 1].y + BasicTabbedPaneUI.this.rects[n5 - 1].height;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabHeight = 0;
                        rectangle.y = n7;
                    }
                    rectangle.height = BasicTabbedPaneUI.this.calculateTabHeight(n2, n5, n9);
                    BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n6) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n5;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.y = n7;
                    }
                    rectangle.x = n8;
                    rectangle.width = BasicTabbedPaneUI.this.maxTabWidth;
                }
                if (n5 != n10) continue;
                BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.runCount - 1;
            }
            if (BasicTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(n2, n3, bl2 ? n7 : n8, n6);
                BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.getRunForTab(n3, n10);
                if (BasicTabbedPaneUI.this.shouldRotateTabRuns(n2)) {
                    this.rotateTabRuns(n2, BasicTabbedPaneUI.this.selectedRun);
                }
            }
            for (n5 = BasicTabbedPaneUI.this.runCount - 1; n5 >= 0; --n5) {
                int n12;
                int n13;
                n4 = BasicTabbedPaneUI.this.tabRuns[n5];
                int n14 = BasicTabbedPaneUI.this.tabRuns[n5 == BasicTabbedPaneUI.this.runCount - 1 ? 0 : n5 + 1];
                int n15 = n13 = n14 != 0 ? n14 - 1 : n3 - 1;
                if (!bl2) {
                    for (n12 = n4; n12 <= n13; ++n12) {
                        rectangle = BasicTabbedPaneUI.this.rects[n12];
                        rectangle.y = n7;
                        rectangle.x += BasicTabbedPaneUI.this.getTabRunIndent(n2, n5);
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(n2, n5)) {
                        this.padTabRun(n2, n4, n13, n6);
                    }
                    if (n2 == 3) {
                        n7 -= BasicTabbedPaneUI.this.maxTabHeight - n11;
                        continue;
                    }
                    n7 += BasicTabbedPaneUI.this.maxTabHeight - n11;
                    continue;
                }
                for (n12 = n4; n12 <= n13; ++n12) {
                    rectangle = BasicTabbedPaneUI.this.rects[n12];
                    rectangle.x = n8;
                    rectangle.y += BasicTabbedPaneUI.this.getTabRunIndent(n2, n5);
                }
                if (BasicTabbedPaneUI.this.shouldPadTabRun(n2, n5)) {
                    this.padTabRun(n2, n4, n13, n6);
                }
                if (n2 == 4) {
                    n8 -= BasicTabbedPaneUI.this.maxTabWidth - n11;
                    continue;
                }
                n8 += BasicTabbedPaneUI.this.maxTabWidth - n11;
            }
            this.padSelectedTab(n2, n10);
            if (!bl3 && !bl2) {
                n4 = dimension.width - (insets.right + insets2.right);
                for (n5 = 0; n5 < n3; ++n5) {
                    BasicTabbedPaneUI.this.rects[n5].x = n4 - BasicTabbedPaneUI.this.rects[n5].x - BasicTabbedPaneUI.this.rects[n5].width;
                }
            }
        }

        protected void padSelectedTab(int n2, int n3) {
            if (n3 >= 0) {
                Rectangle rectangle = BasicTabbedPaneUI.this.rects[n3];
                Insets insets = BasicTabbedPaneUI.this.getSelectedTabPadInsets(n2);
                rectangle.x -= insets.left;
                rectangle.width += insets.left + insets.right;
                rectangle.y -= insets.top;
                rectangle.height += insets.top + insets.bottom;
            }
        }

        protected void rotateTabRuns(int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = BasicTabbedPaneUI.this.tabRuns[0];
                for (int i3 = 1; i3 < BasicTabbedPaneUI.this.runCount; ++i3) {
                    BasicTabbedPaneUI.this.tabRuns[i3 - 1] = BasicTabbedPaneUI.this.tabRuns[i3];
                }
                BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount - 1] = n4;
            }
        }

        protected void normalizeTabRuns(int n2, int n3, int n4, int n5) {
            boolean bl2 = n2 == 2 || n2 == 4;
            int n6 = BasicTabbedPaneUI.this.runCount - 1;
            boolean bl3 = true;
            double d2 = 1.25;
            while (bl3) {
                int n7;
                int n8;
                int n9 = BasicTabbedPaneUI.this.lastTabInRun(n3, n6);
                int n10 = BasicTabbedPaneUI.this.lastTabInRun(n3, n6 - 1);
                if (!bl2) {
                    n8 = BasicTabbedPaneUI.this.rects[n9].x + BasicTabbedPaneUI.this.rects[n9].width;
                    n7 = (int)((double)BasicTabbedPaneUI.this.maxTabWidth * d2);
                } else {
                    n8 = BasicTabbedPaneUI.this.rects[n9].y + BasicTabbedPaneUI.this.rects[n9].height;
                    n7 = (int)((double)BasicTabbedPaneUI.this.maxTabHeight * d2 * 2.0);
                }
                if (n5 - n8 > n7) {
                    BasicTabbedPaneUI.this.tabRuns[n6] = n10;
                    if (!bl2) {
                        BasicTabbedPaneUI.this.rects[n10].x = n4;
                    } else {
                        BasicTabbedPaneUI.this.rects[n10].y = n4;
                    }
                    for (int i2 = n10 + 1; i2 <= n9; ++i2) {
                        if (!bl2) {
                            BasicTabbedPaneUI.this.rects[i2].x = BasicTabbedPaneUI.this.rects[i2 - 1].x + BasicTabbedPaneUI.this.rects[i2 - 1].width;
                            continue;
                        }
                        BasicTabbedPaneUI.this.rects[i2].y = BasicTabbedPaneUI.this.rects[i2 - 1].y + BasicTabbedPaneUI.this.rects[i2 - 1].height;
                    }
                } else if (n6 == BasicTabbedPaneUI.this.runCount - 1) {
                    bl3 = false;
                }
                if (n6 - 1 > 0) {
                    --n6;
                    continue;
                }
                n6 = BasicTabbedPaneUI.this.runCount - 1;
                d2 += 0.25;
            }
        }

        protected void padTabRun(int n2, int n3, int n4, int n5) {
            Rectangle rectangle = BasicTabbedPaneUI.this.rects[n4];
            if (n2 == 1 || n2 == 3) {
                int n6 = rectangle.x + rectangle.width - BasicTabbedPaneUI.this.rects[n3].x;
                int n7 = n5 - (rectangle.x + rectangle.width);
                float f2 = (float)n7 / (float)n6;
                for (int i2 = n3; i2 <= n4; ++i2) {
                    Rectangle rectangle2 = BasicTabbedPaneUI.this.rects[i2];
                    if (i2 > n3) {
                        rectangle2.x = BasicTabbedPaneUI.this.rects[i2 - 1].x + BasicTabbedPaneUI.this.rects[i2 - 1].width;
                    }
                    rectangle2.width += Math.round((float)rectangle2.width * f2);
                }
                rectangle.width = n5 - rectangle.x;
            } else {
                int n8 = rectangle.y + rectangle.height - BasicTabbedPaneUI.this.rects[n3].y;
                int n9 = n5 - (rectangle.y + rectangle.height);
                float f3 = (float)n9 / (float)n8;
                for (int i3 = n3; i3 <= n4; ++i3) {
                    Rectangle rectangle3 = BasicTabbedPaneUI.this.rects[i3];
                    if (i3 > n3) {
                        rectangle3.y = BasicTabbedPaneUI.this.rects[i3 - 1].y + BasicTabbedPaneUI.this.rects[i3 - 1].height;
                    }
                    rectangle3.height += Math.round((float)rectangle3.height * f3);
                }
                rectangle.height = n5 - rectangle.y;
            }
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n3 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BasicTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n3 < 0) {
                if (component != null) {
                    BasicTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                int n4 = 0;
                int n5 = 0;
                Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n2);
                Component component2 = BasicTabbedPaneUI.this.tabPane.getComponentAt(n3);
                boolean bl2 = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl2 = true;
                    }
                    BasicTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Rectangle rectangle = BasicTabbedPaneUI.this.tabPane.getBounds();
                int n6 = BasicTabbedPaneUI.this.tabPane.getComponentCount();
                if (n6 > 0) {
                    int n7;
                    int n8;
                    switch (n2) {
                        case 2: {
                            n4 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n8 = insets.left + n4 + insets2.left;
                            n7 = insets.top + insets2.top;
                            break;
                        }
                        case 4: {
                            n4 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            break;
                        }
                        case 3: {
                            n5 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            break;
                        }
                        default: {
                            n5 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + n5 + insets2.top;
                        }
                    }
                    int n9 = rectangle.width - n4 - insets.left - insets.right - insets2.left - insets2.right;
                    int n10 = rectangle.height - n5 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                    for (int i2 = 0; i2 < n6; ++i2) {
                        Component component3 = BasicTabbedPaneUI.this.tabPane.getComponent(i2);
                        component3.setBounds(n8, n7, n9, n10);
                    }
                }
                if (bl2 && !BasicTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                    BasicTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        protected Dimension calculateSize(boolean bl2) {
            int n2;
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n3);
            Insets insets3 = BasicTabbedPaneUI.this.getTabAreaInsets(n3);
            Dimension dimension = new Dimension(0, 0);
            int n4 = insets2.top + insets2.bottom;
            int n5 = insets2.left + insets2.right;
            int n6 = 0;
            int n7 = 0;
            for (n2 = 0; n2 < BasicTabbedPaneUI.this.tabPane.getTabCount(); ++n2) {
                Component component = BasicTabbedPaneUI.this.tabPane.getComponentAt(n2);
                if (component == null) continue;
                Dimension dimension2 = dimension;
                Dimension dimension3 = dimension2 = bl2 ? component.getMinimumSize() : component.getPreferredSize();
                if (dimension2 == null) continue;
                n7 = Math.max(dimension2.height, n7);
                n6 = Math.max(dimension2.width, n6);
            }
            n5 += n6;
            n4 += n7;
            n2 = 0;
            switch (n3) {
                case 2: 
                case 4: {
                    n4 = Math.max(n4, BasicTabbedPaneUI.this.calculateMaxTabHeight(n3) + insets3.top + insets3.bottom);
                    n2 = this.preferredTabAreaWidth(n3, n4);
                    n5 += n2;
                    break;
                }
                default: {
                    n5 = Math.max(n5, BasicTabbedPaneUI.this.calculateMaxTabWidth(n3) + insets3.left + insets3.right);
                    n2 = this.preferredTabAreaHeight(n3, n5);
                    n4 += n2;
                }
            }
            return new Dimension(n5 + insets.left + insets.right, n4 + insets.bottom + insets.top);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(true);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        protected int preferredTabAreaHeight(int n2, int n3) {
            return BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
        }

        protected int preferredTabAreaWidth(int n2, int n3) {
            return BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
        }

        protected void calculateTabRects(int n2, int n3) {
            int n4;
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getTabAreaInsets(n2);
            int n5 = fontMetrics.getHeight();
            int n6 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl2 = n2 == 2 || n2 == 4;
            boolean bl3 = BasicGraphicsUtils.isLeftToRight(BasicTabbedPaneUI.this.tabPane);
            int n7 = insets2.left;
            int n8 = insets2.top;
            int n9 = 0;
            int n10 = 0;
            switch (n2) {
                case 2: 
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                }
            }
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            if (n3 == 0) {
                return;
            }
            BasicTabbedPaneUI.this.selectedRun = 0;
            BasicTabbedPaneUI.this.runCount = 1;
            for (n4 = 0; n4 < n3; ++n4) {
                Rectangle rectangle = BasicTabbedPaneUI.this.rects[n4];
                if (!bl2) {
                    if (n4 > 0) {
                        rectangle.x = BasicTabbedPaneUI.this.rects[n4 - 1].x + BasicTabbedPaneUI.this.rects[n4 - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        n10 += BasicTabbedPaneUI.this.maxTabHeight;
                        rectangle.x = n7;
                    }
                    rectangle.width = BasicTabbedPaneUI.this.calculateTabWidth(n2, n4, fontMetrics);
                    n9 = rectangle.x + rectangle.width;
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    rectangle.y = n8;
                    rectangle.height = BasicTabbedPaneUI.this.maxTabHeight;
                    continue;
                }
                if (n4 > 0) {
                    rectangle.y = BasicTabbedPaneUI.this.rects[n4 - 1].y + BasicTabbedPaneUI.this.rects[n4 - 1].height;
                } else {
                    BasicTabbedPaneUI.this.tabRuns[0] = 0;
                    BasicTabbedPaneUI.this.maxTabHeight = 0;
                    n9 = BasicTabbedPaneUI.this.maxTabWidth;
                    rectangle.y = n8;
                }
                rectangle.height = BasicTabbedPaneUI.this.calculateTabHeight(n2, n4, n5);
                n10 = rectangle.y + rectangle.height;
                BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rectangle.height);
                rectangle.x = n7;
                rectangle.width = BasicTabbedPaneUI.this.maxTabWidth;
            }
            if (!bl3 && !bl2) {
                int n11 = dimension.width - (insets.right + insets2.right);
                for (n4 = 0; n4 < n3; ++n4) {
                    BasicTabbedPaneUI.this.rects[n4].x = n11 - BasicTabbedPaneUI.this.rects[n4].x - BasicTabbedPaneUI.this.rects[n4].width;
                }
            }
            ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(n9, n10));
        }

        public void layoutContainer(Container container) {
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n4 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BasicTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n4 < 0) {
                if (component != null) {
                    BasicTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component component2 = BasicTabbedPaneUI.this.tabPane.getComponentAt(n4);
                boolean bl2 = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl2 = true;
                    }
                    BasicTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n2);
                Rectangle rectangle = BasicTabbedPaneUI.this.tabPane.getBounds();
                int n5 = BasicTabbedPaneUI.this.tabPane.getComponentCount();
                if (n5 > 0) {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    switch (n2) {
                        case 2: {
                            n13 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = insets.left;
                            n10 = insets.top;
                            n9 = n11 + n13 + insets2.left;
                            n8 = n10 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 4: {
                            n13 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = rectangle.width - insets.right - n13;
                            n10 = insets.top;
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 3: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n11 = insets.left;
                            n10 = rectangle.height - insets.bottom - n12;
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                            break;
                        }
                        default: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n11 = insets.left;
                            n10 = insets.top;
                            n9 = n11 + insets2.left;
                            n8 = n10 + n12 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                        }
                    }
                    for (int i2 = 0; i2 < n5; ++i2) {
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        Cloneable cloneable;
                        JComponent jComponent;
                        Component component3 = BasicTabbedPaneUI.this.tabPane.getComponent(i2);
                        if (component3 instanceof ScrollableTabViewport) {
                            jComponent = (JViewport)component3;
                            cloneable = ((JViewport)jComponent).getViewRect();
                            n17 = n13;
                            n16 = n12;
                            switch (n2) {
                                case 2: 
                                case 4: {
                                    n15 = BasicTabbedPaneUI.this.rects[n3 - 1].y + BasicTabbedPaneUI.this.rects[n3 - 1].height;
                                    if (n15 <= n12 || n15 - cloneable.y > (n16 = Math.max(n12 - 36, 36))) break;
                                    n16 = n15 - cloneable.y;
                                    break;
                                }
                                default: {
                                    n14 = BasicTabbedPaneUI.this.rects[n3 - 1].x + BasicTabbedPaneUI.this.rects[n3 - 1].width;
                                    if (n14 <= n13 || n14 - cloneable.x > (n17 = Math.max(n13 - 36, 36))) break;
                                    n17 = n14 - cloneable.x;
                                }
                            }
                            component3.setBounds(n11, n10, n17, n16);
                            continue;
                        }
                        if (component3 instanceof ScrollableTabButton) {
                            jComponent = (ScrollableTabButton)component3;
                            cloneable = ((BasicArrowButton)jComponent).getPreferredSize();
                            n17 = 0;
                            n16 = 0;
                            n15 = ((Dimension)cloneable).width;
                            n14 = ((Dimension)cloneable).height;
                            boolean bl3 = false;
                            switch (n2) {
                                case 2: 
                                case 4: {
                                    int n18 = BasicTabbedPaneUI.this.rects[n3 - 1].y + BasicTabbedPaneUI.this.rects[n3 - 1].height;
                                    if (n18 <= n12) break;
                                    int n19 = ((ScrollableTabButton)jComponent).scrollsForward() ? 5 : 1;
                                    ((BasicArrowButton)jComponent).setDirection(n19);
                                    bl3 = true;
                                    n17 = n2 == 2 ? n11 + n13 - ((Dimension)cloneable).width : n11;
                                    n16 = n19 == 5 ? rectangle.height - insets.bottom - ((Dimension)cloneable).height : rectangle.height - insets.bottom - 2 * ((Dimension)cloneable).height;
                                    break;
                                }
                                default: {
                                    int n19 = BasicTabbedPaneUI.this.rects[n3 - 1].x + BasicTabbedPaneUI.this.rects[n3 - 1].width;
                                    if (n19 <= n13) break;
                                    int n20 = ((ScrollableTabButton)jComponent).scrollsForward() ? 3 : 7;
                                    ((BasicArrowButton)jComponent).setDirection(n20);
                                    bl3 = true;
                                    n17 = n20 == 3 ? rectangle.width - insets.left - ((Dimension)cloneable).width : rectangle.width - insets.left - 2 * ((Dimension)cloneable).width;
                                    n16 = n2 == 1 ? n10 + n12 - ((Dimension)cloneable).height : n10;
                                }
                            }
                            component3.setVisible(bl3);
                            if (!bl3) continue;
                            component3.setBounds(n17, n16, n15, n14);
                            continue;
                        }
                        component3.setBounds(n9, n8, n7, n6);
                    }
                    if (bl2 && !BasicTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                        BasicTabbedPaneUI.this.tabPane.requestFocus();
                    }
                }
            }
        }

        private TabbedPaneScrollLayout() {
        }
    }

    private static class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(1);
        }
    }
}

