/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;

public class BasicEditorPaneUI
extends BasicTextUI {
    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("editorKit")) {
            ActionMap actionMap = SwingUtilities.getUIActionMap(this.getComponent());
            if (actionMap != null) {
                Action[] actionArray;
                Action[] actionArray2;
                Object object = propertyChangeEvent.getOldValue();
                if (object instanceof EditorKit && (actionArray2 = ((EditorKit)object).getActions()) != null) {
                    this.removeActions(actionMap, actionArray2);
                }
                if ((actionArray2 = propertyChangeEvent.getNewValue()) instanceof EditorKit && (actionArray = ((EditorKit)actionArray2).getActions()) != null) {
                    this.addActions(actionMap, actionArray);
                }
            }
            this.updateFocusTraversalKeys();
        } else if ("editable".equals(propertyChangeEvent.getPropertyName())) {
            this.updateFocusTraversalKeys();
        }
    }

    protected String getPropertyPrefix() {
        return "EditorPane";
    }

    ActionMap getActionMap() {
        Action[] actionArray;
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("requestFocus", new BasicTextUI.FocusAction());
        EditorKit editorKit = this.getEditorKit(this.getComponent());
        if (editorKit != null && (actionArray = editorKit.getActions()) != null) {
            this.addActions(actionMapUIResource, actionArray);
        }
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    void addActions(ActionMap actionMap, Action[] actionArray) {
        int n2 = actionArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Action action = actionArray[i2];
            actionMap.put(action.getValue("Name"), action);
        }
    }

    void removeActions(ActionMap actionMap, Action[] actionArray) {
        int n2 = actionArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Action action = actionArray[i2];
            actionMap.remove(action.getValue("Name"));
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicEditorPaneUI();
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        JEditorPane jEditorPane = (JEditorPane)this.getComponent();
        return jEditorPane.getEditorKit();
    }
}

