/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.IOException;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerValue;

public final class PolicyQualifierInfo {
    private byte[] mEncoded;
    private String mId;
    private byte[] mData;
    private String pqiString;

    public byte[] getEncoded() {
        return (byte[])this.mEncoded.clone();
    }

    public byte[] getPolicyQualifier() {
        return this.mData == null ? null : (byte[])this.mData.clone();
    }

    public PolicyQualifierInfo(byte[] byArray) throws IOException {
        this.mEncoded = (byte[])byArray.clone();
        DerValue derValue = new DerValue(this.mEncoded);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for PolicyQualifierInfo");
        }
        this.mId = derValue.data.getDerValue().getOID().toString();
        byte[] byArray2 = derValue.data.toByteArray();
        if (byArray2 == null) {
            this.mData = null;
        } else {
            this.mData = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.mData, 0, byArray2.length);
        }
    }

    public String getPolicyQualifierId() {
        return this.mId;
    }

    public String toString() {
        if (this.pqiString != null) {
            return this.pqiString;
        }
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolicyQualifierInfo: [\n");
        stringBuffer.append("  qualifierID: " + this.mId + "\n");
        stringBuffer.append("  qualifier: " + (this.mData == null ? "null" : hexDumpEncoder.encodeBuffer(this.mData)) + "\n");
        stringBuffer.append("]");
        this.pqiString = stringBuffer.toString();
        return this.pqiString;
    }
}

