/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecurityPermission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import sun.misc.Launcher;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;

public final class Security {
    private static boolean reloadProviders = true;
    static final boolean debug = false;
    private static final Debug sdebug = Debug.getInstance("properties");
    static final boolean error = true;
    private static Properties props;
    private static Vector providers;
    private static Hashtable providerPropertiesCache;
    private static Hashtable engineCache;
    private static Hashtable searchResultsCache;
    private static Hashtable providerLoads;
    private static int numOfStaticProviders;
    private static Vector providerMasterClassNames;
    private static int indexStaticProviders;
    private static boolean resetProviderIndex;

    static {
        numOfStaticProviders = 0;
        providerMasterClassNames = new Vector(6);
        indexStaticProviders = 0;
        resetProviderIndex = false;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Security.initialize();
                return null;
            }
        });
    }

    private Security() {
    }

    private static synchronized void countProviders() {
        String string;
        int n2 = 1;
        while ((string = props.getProperty("security.provider." + n2)) != null) {
            String string2 = string.trim();
            if (string2.length() == 0) {
                System.err.println("invalid entry for security.provider." + n2);
                break;
            }
            if (!providerMasterClassNames.contains(string2)) {
                providerMasterClassNames.add(string2);
            }
            ++n2;
        }
        numOfStaticProviders = providerMasterClassNames.size();
    }

    private static void initialize() {
        boolean bl2;
        block16: {
            Object object;
            Object object2;
            File file;
            boolean bl3;
            block15: {
                props = new Properties();
                providers = new Vector();
                providerPropertiesCache = new Hashtable();
                engineCache = new Hashtable();
                searchResultsCache = new Hashtable(5);
                providerLoads = new Hashtable(1);
                bl2 = false;
                bl3 = false;
                file = Security.securityPropFile("java.security");
                if (file.exists()) {
                    try {
                        object2 = new FileInputStream(file);
                        object = new BufferedInputStream((InputStream)object2);
                        props.load((InputStream)object);
                        ((InputStream)object).close();
                        bl2 = true;
                        if (sdebug != null) {
                            sdebug.println("reading security properties file: " + file);
                        }
                    }
                    catch (IOException iOException) {
                        if (sdebug == null) break block15;
                        sdebug.println("unable to load security properties from " + file);
                        iOException.printStackTrace();
                    }
                }
            }
            if ("true".equalsIgnoreCase(props.getProperty("security.overridePropertiesFile"))) {
                object2 = System.getProperty("java.security.properties");
                if (object2 != null && ((String)object2).startsWith("=")) {
                    bl3 = true;
                    object2 = ((String)object2).substring(1);
                }
                if (bl3) {
                    props = new Properties();
                    if (sdebug != null) {
                        sdebug.println("overriding other security properties files!");
                    }
                }
                if (object2 != null) {
                    try {
                        object2 = PropertyExpander.expand((String)object2);
                        file = new File((String)object2);
                        object = file.exists() ? new URL("file:" + file.getCanonicalPath()) : new URL((String)object2);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(((URL)object).openStream());
                        props.load(bufferedInputStream);
                        bufferedInputStream.close();
                        bl2 = true;
                        if (sdebug != null) {
                            sdebug.println("reading security properties file: " + object);
                            if (bl3) {
                                sdebug.println("overriding other security properties files!");
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (sdebug == null) break block16;
                        sdebug.println("unable to load security properties from " + (String)object2);
                        exception.printStackTrace();
                    }
                }
            }
        }
        if (!bl2) {
            Security.initializeStatic();
            if (sdebug != null) {
                sdebug.println("unable to load security properties -- using defaults");
            }
        }
        Security.countProviders();
    }

    private static void initializeStatic() {
        props.put("security.provider.1", "sun.security.provider.Sun");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadOneMoreProvider() {
        boolean bl2 = false;
        if (reloadProviders) {
            bl2 = true;
            reloadProviders = false;
        }
        try {
            Launcher launcher = Launcher.getLauncher();
            if (indexStaticProviders >= numOfStaticProviders) {
                return;
            }
            Provider provider = null;
            while (indexStaticProviders < numOfStaticProviders) {
                final String string = (String)providerMasterClassNames.elementAt(indexStaticProviders);
                if (providerLoads.get(string) != null) {
                    ++indexStaticProviders;
                    continue;
                }
                providerLoads.put(string, string);
                provider = (Provider)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Provider.loadProvider(string);
                    }
                });
                ++indexStaticProviders;
                providerLoads.remove(string);
                if (provider != null) {
                    providers.addElement(provider);
                    providerPropertiesCache.clear();
                    engineCache.clear();
                    searchResultsCache.clear();
                    break;
                }
                if (launcher != null) continue;
                resetProviderIndex = true;
            }
        }
        finally {
            if (bl2) {
                reloadProviders = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void reloadProviders() {
        Launcher launcher;
        if (reloadProviders && (launcher = Launcher.getLauncher()) != null) {
            Class clazz = Security.class;
            synchronized (clazz) {
                reloadProviders = false;
                indexStaticProviders = numOfStaticProviders;
                resetProviderIndex = false;
                providers.removeAllElements();
                for (int i2 = 0; i2 < numOfStaticProviders; ++i2) {
                    final String string = (String)providerMasterClassNames.elementAt(i2);
                    Provider provider = (Provider)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Provider.loadProvider(string);
                        }
                    });
                    if (provider == null) continue;
                    providers.addElement(provider);
                }
                providerPropertiesCache.clear();
                engineCache.clear();
                searchResultsCache.clear();
            }
        }
    }

    private static Object saveProviders() throws Exception {
        State state = new State();
        state.reloadProviders = reloadProviders;
        state.providers = providers;
        state.providerLoads = providerLoads;
        state.numOfStaticProviders = numOfStaticProviders;
        state.providerMasterClassNames = providerMasterClassNames;
        state.indexStaticProviders = indexStaticProviders;
        state.resetProviderIndex = resetProviderIndex;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Security.findProvider(vector, vector2, "sun.security.provider.Sun");
        Security.findProvider(vector, vector2, "com.sun.net.ssl.internal.ssl.Provider");
        Security.findProvider(vector, vector2, "com.sun.rsajca.Provider");
        int n2 = vector.size();
        reloadProviders = false;
        providers = vector;
        providerLoads = new Hashtable();
        numOfStaticProviders = n2;
        providerMasterClassNames = vector2;
        indexStaticProviders = n2;
        resetProviderIndex = false;
        providerPropertiesCache.clear();
        engineCache.clear();
        searchResultsCache.clear();
        return state;
    }

    private static void restoreProviders(Object object) {
        State state = (State)object;
        reloadProviders = state.reloadProviders;
        providers = state.providers;
        providerLoads = state.providerLoads;
        numOfStaticProviders = state.numOfStaticProviders;
        providerMasterClassNames = state.providerMasterClassNames;
        indexStaticProviders = state.indexStaticProviders;
        resetProviderIndex = state.resetProviderIndex;
        providerPropertiesCache.clear();
        engineCache.clear();
        searchResultsCache.clear();
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }

    static void debug(String string) {
    }

    static void error(String string) {
    }

    private static void invalidateSMCache(String string) {
        final boolean bl2 = string.equals("package.access");
        boolean bl3 = string.equals("package.definition");
        if (bl2 || bl3) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class clazz = Class.forName("java.lang.SecurityManager", false, null);
                        Field field = null;
                        boolean bl22 = false;
                        if (bl2) {
                            field = clazz.getDeclaredField("packageAccessValid");
                            bl22 = field.isAccessible();
                            field.setAccessible(true);
                        } else {
                            field = clazz.getDeclaredField("packageDefinitionValid");
                            bl22 = field.isAccessible();
                            field.setAccessible(true);
                        }
                        field.setBoolean(field, false);
                        field.setAccessible(bl22);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    public static synchronized void removeProvider(String string) {
        Security.reloadProviders();
        Security.check("removeProvider." + string);
        Provider provider = Security.getProvider(string);
        if (provider != null) {
            Iterator iterator = providers.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != provider) continue;
                iterator.remove();
            }
            providerPropertiesCache.clear();
            engineCache.clear();
            searchResultsCache.clear();
        }
    }

    private static boolean isStandardAttr(String string) {
        if (string.equalsIgnoreCase("KeySize")) {
            return true;
        }
        return string.equalsIgnoreCase("ImplementedIn");
    }

    public static synchronized Provider[] getProviders() {
        Security.reloadProviders();
        Object[] objectArray = new Provider[providers.size()];
        providers.copyInto(objectArray);
        return objectArray;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, 0);
    }

    public static synchronized int insertProviderAt(Provider provider, int n2) {
        Security.reloadProviders();
        Security.check("insertProvider." + provider.getName());
        Provider provider2 = Security.getProvider(provider.getName());
        if (provider2 != null) {
            return -1;
        }
        int n3 = providers.size();
        if (n2 > n3 || n2 <= 0) {
            n2 = n3 + 1;
        }
        providers.insertElementAt(provider, n2 - 1);
        providerPropertiesCache.clear();
        engineCache.clear();
        searchResultsCache.clear();
        return n2;
    }

    private static File securityPropFile(String string) {
        String string2 = File.separator;
        return new File(System.getProperty("java.home") + string2 + "lib" + string2 + "security" + string2 + string);
    }

    private static boolean checkSuperclass(Class clazz, Class clazz2) {
        while (!clazz.equals(clazz2)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return false;
        }
        return true;
    }

    public static String getProperty(String string) {
        String string2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("getProperty." + string));
        }
        if ((string2 = props.getProperty(string)) != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static void setProperty(String string, String string2) {
        Security.check("setProperty." + string);
        props.put(string, string2);
        Security.invalidateSMCache(string);
    }

    static void debug(String string, Throwable throwable) {
    }

    static void error(String string, Throwable throwable) {
        Security.error(string);
    }

    public static synchronized Provider getProvider(String string) {
        Security.reloadProviders();
        Enumeration enumeration = providers.elements();
        while (enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!provider.getName().equals(string)) continue;
            return provider;
        }
        return null;
    }

    public static Provider[] getProviders(String string) {
        String string2 = null;
        String string3 = null;
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            string2 = new String(string);
            string3 = "";
        } else {
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1);
        }
        Hashtable hashtable = new Hashtable(1);
        hashtable.put(string2, string3);
        return Security.getProviders(hashtable);
    }

    public static Provider[] getProviders(Map map) {
        Provider[] providerArray;
        Provider[] providerArray2 = Security.getProviders();
        Set set = map.keySet();
        LinkedHashSet linkedHashSet = new LinkedHashSet(5);
        if (set == null || providerArray2 == null) {
            return providerArray2;
        }
        boolean bl2 = true;
        Object[] objectArray = set.iterator();
        while (objectArray.hasNext()) {
            providerArray = (Provider[])objectArray.next();
            String string = (String)map.get(providerArray);
            LinkedHashSet linkedHashSet2 = Security.getAllQualifyingCandidates((String)providerArray, string, providerArray2);
            if (bl2) {
                linkedHashSet = linkedHashSet2;
                bl2 = false;
            }
            if (linkedHashSet2 != null && !linkedHashSet2.isEmpty()) {
                Iterator iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    Provider provider = (Provider)iterator.next();
                    if (linkedHashSet2.contains(provider)) continue;
                    iterator.remove();
                }
                continue;
            }
            linkedHashSet = null;
            break;
        }
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            return null;
        }
        objectArray = linkedHashSet.toArray();
        providerArray = new Provider[objectArray.length];
        for (int i2 = 0; i2 < providerArray.length; ++i2) {
            providerArray[i2] = (Provider)objectArray[i2];
        }
        return providerArray;
    }

    private static ProviderProperty getProviderProperty(String string) {
        ProviderProperty providerProperty = (ProviderProperty)providerPropertiesCache.get(string);
        if (providerProperty != null) {
            return providerProperty;
        }
        for (int i2 = 0; i2 < providers.size(); ++i2) {
            Object object;
            String string2 = null;
            Provider provider = (Provider)providers.elementAt(i2);
            String string3 = provider.getProperty(string);
            if (string3 == null) {
                object = provider.keys();
                while (object.hasMoreElements() && string3 == null) {
                    string2 = (String)object.nextElement();
                    if (!string.equalsIgnoreCase(string2)) continue;
                    string3 = provider.getProperty(string2);
                    break;
                }
            }
            if (string3 == null) continue;
            object = new ProviderProperty();
            ((ProviderProperty)object).className = string3;
            ((ProviderProperty)object).provider = provider;
            providerPropertiesCache.put(string, object);
            if (string2 != null) {
                providerPropertiesCache.put(string2, object);
            }
            return object;
        }
        return providerProperty;
    }

    public static Set getAlgorithms(String string) {
        HashSet hashSet = new HashSet();
        if (string == null || string.length() == 0 || string.endsWith(".")) {
            return hashSet;
        }
        Provider[] providerArray = Security.getProviders();
        for (int i2 = 0; i2 < providerArray.length; ++i2) {
            Enumeration enumeration = providerArray[i2].keys();
            while (enumeration.hasMoreElements()) {
                String string2 = ((String)enumeration.nextElement()).toUpperCase();
                if (!string2.startsWith(string.toUpperCase()) || string2.indexOf(" ") >= 0) continue;
                hashSet.add(string2.substring(string.length() + 1));
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static String getAlgorithmProperty(String string, String string2) {
        Security.reloadProviders();
        ProviderProperty providerProperty = Security.getProviderProperty("Alg." + string2 + "." + string);
        if (providerProperty != null) {
            return providerProperty.className;
        }
        return null;
    }

    static String[] getFilterComponents(String string, String string2) {
        int n2 = string.indexOf(46);
        if (n2 < 0) {
            throw new InvalidParameterException("Invalid filter");
        }
        String string3 = string.substring(0, n2);
        String string4 = null;
        String string5 = null;
        if (string2.length() == 0) {
            string4 = string.substring(n2 + 1).trim();
            if (string4.length() == 0) {
                throw new InvalidParameterException("Invalid filter");
            }
        } else {
            int n3 = string.indexOf(32);
            if (n3 == -1) {
                throw new InvalidParameterException("Invalid filter");
            }
            string5 = string.substring(n3 + 1).trim();
            if (string5.length() == 0) {
                throw new InvalidParameterException("Invalid filter");
            }
            if (n3 < n2 || n2 == n3 - 1) {
                throw new InvalidParameterException("Invalid filter");
            }
            string4 = string.substring(n2 + 1, n3);
        }
        String[] stringArray = new String[]{string3, string4, string5};
        return stringArray;
    }

    private static boolean isConstraintSatisfied(String string, String string2, String string3) {
        if (string.equalsIgnoreCase("KeySize")) {
            int n2;
            int n3 = new Integer(string2);
            return n3 <= (n2 = new Integer(string3).intValue());
        }
        if (string.equalsIgnoreCase("ImplementedIn")) {
            return string2.equalsIgnoreCase(string3);
        }
        return false;
    }

    private static String getProviderProperty(String string, Provider provider) {
        String string2 = provider.getProperty(string);
        if (string2 == null) {
            Enumeration enumeration = provider.keys();
            while (enumeration.hasMoreElements() && string2 == null) {
                String string3 = (String)enumeration.nextElement();
                if (!string.equalsIgnoreCase(string3)) continue;
                string2 = provider.getProperty(string3);
                break;
            }
        }
        return string2;
    }

    private static void findProvider(Vector vector, Vector vector2, String string) {
        Provider provider;
        Object object = providers.elements();
        while (object.hasMoreElements()) {
            provider = (Provider)object.nextElement();
            Class clazz = provider.getClass();
            if (clazz.getClassLoader() != null || !clazz.getName().equals(string)) continue;
            vector.add(provider);
            vector2.add(string);
            return;
        }
        try {
            object = Class.forName(string);
            provider = (Provider)((Class)object).newInstance();
            vector.add(provider);
            vector2.add(string);
            return;
        }
        catch (Exception exception) {
            if (sdebug != null) {
                sdebug.println("Could not load provider: " + string);
                exception.printStackTrace();
            }
            return;
        }
    }

    private static synchronized ProviderProperty getEngineClassName(String string, String string2) throws NoSuchAlgorithmException {
        ProviderProperty providerProperty;
        String string3 = string2;
        if (string != null) {
            string3 = string3 + "." + string;
        }
        if ((providerProperty = (ProviderProperty)engineCache.get(string3)) != null) {
            return providerProperty;
        }
        Launcher launcher = Launcher.getLauncher();
        if (reloadProviders && launcher != null && resetProviderIndex) {
            resetProviderIndex = false;
            indexStaticProviders = 0;
            providers.removeAllElements();
            providerPropertiesCache.clear();
            engineCache.clear();
            searchResultsCache.clear();
            providerLoads.clear();
        }
        if (providers.size() == 0) {
            Security.loadOneMoreProvider();
        }
        for (int i2 = 0; i2 < providers.size(); ++i2) {
            Provider provider = (Provider)providers.elementAt(i2);
            try {
                providerProperty = Security.getEngineClassName(string, provider, string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (i2 != providers.size() - 1) continue;
                Security.loadOneMoreProvider();
                continue;
            }
            engineCache.put(string3, providerProperty);
            return providerProperty;
        }
        throw new NoSuchAlgorithmException(string.toUpperCase() + " " + string2 + " not available");
    }

    static Object[] getImpl(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        ProviderProperty providerProperty = Security.getEngineClassName(string, string3, string2);
        return Security.doGetImpl(string, string2, providerProperty);
    }

    static Object[] getImpl(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        ProviderProperty providerProperty = Security.getEngineClassName(string, provider, string2);
        return Security.doGetImpl(string, string2, providerProperty);
    }

    private static Object[] doGetImpl(String string, String string2, ProviderProperty providerProperty) throws NoSuchAlgorithmException {
        try {
            return Security.doGetImpl(string, string2, providerProperty, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new NoSuchAlgorithmException(invalidAlgorithmParameterException.getMessage());
        }
    }

    private static String getStandardName(String string, String string2, Provider provider) {
        return Security.getProviderProperty("Alg.Alias." + string2 + "." + string, provider);
    }

    private static ProviderProperty getEngineClassName(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            return Security.getEngineClassName(string, string3);
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("no such provider: " + string2);
        }
        return Security.getEngineClassName(string, provider, string3);
    }

    private static ProviderProperty getEngineClassName(String string, Provider provider, String string2) throws NoSuchAlgorithmException {
        Object object;
        String string3 = string2.equalsIgnoreCase("SecureRandom") && string == null ? string2 : string2 + "." + string;
        String string4 = Security.getProviderProperty(string3, provider);
        if (string4 == null) {
            if (string2.equalsIgnoreCase("SecureRandom") && string == null) {
                throw new NoSuchAlgorithmException("SecureRandom not available for provider " + provider.getName());
            }
            object = Security.getStandardName(string, string2, provider);
            if (object != null) {
                string3 = string2 + "." + (String)object;
            }
            if (object == null || (string4 = Security.getProviderProperty(string3, provider)) == null) {
                throw new NoSuchAlgorithmException("no such algorithm: " + string + " for provider " + provider.getName());
            }
        }
        object = new ProviderProperty();
        ((ProviderProperty)object).className = string4;
        ((ProviderProperty)object).provider = provider;
        return object;
    }

    private static LinkedHashSet getAllQualifyingCandidates(String string, String string2, Provider[] providerArray) {
        String[] stringArray = Security.getFilterComponents(string, string2);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        String string6 = string3 + '.' + string4;
        LinkedHashSet linkedHashSet = (LinkedHashSet)searchResultsCache.get(string6);
        LinkedHashSet linkedHashSet2 = Security.getProvidersNotUsingCache(string3, string4, null, null, null, providerArray);
        if (linkedHashSet2 == null || linkedHashSet2.isEmpty()) {
            return null;
        }
        searchResultsCache.put(string6, linkedHashSet2);
        if (string5 == null) {
            return linkedHashSet2;
        }
        return Security.getProvidersNotUsingCache(string3, string4, string5, string2, linkedHashSet, providerArray);
    }

    static Object[] getImpl(String string, String string2, String string3, Object object) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        ProviderProperty providerProperty = Security.getEngineClassName(string, string3, string2);
        return Security.doGetImpl(string, string2, providerProperty, object);
    }

    static Object[] getImpl(String string, String string2, Provider provider, Object object) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ProviderProperty providerProperty = Security.getEngineClassName(string, provider, string2);
        return Security.doGetImpl(string, string2, providerProperty, object);
    }

    private static Object[] doGetImpl(String string, String string2, ProviderProperty providerProperty, Object object) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        String string3 = providerProperty.className;
        String string4 = providerProperty.provider.getName();
        try {
            Class clazz = string2.equals("CertificateFactory") || string2.equals("CertPathBuilder") || string2.equals("CertPathValidator") || string2.equals("CertStore") ? Class.forName("java.security.cert." + string2 + "Spi") : Class.forName("java.security." + string2 + "Spi");
            ClassLoader classLoader = providerProperty.provider.getClass().getClassLoader();
            Class clazz2 = classLoader != null ? classLoader.loadClass(string3) : Class.forName(string3);
            if (Security.checkSuperclass(clazz2, clazz)) {
                Object object2;
                if (string2.equals("CertStore")) {
                    Constructor constructor = clazz2.getConstructor(new Class[]{Class.forName("java.security.cert.CertStoreParameters")});
                    object2 = constructor.newInstance(new Object[]{object});
                } else {
                    object2 = clazz2.newInstance();
                }
                return new Object[]{object2, providerProperty.provider};
            }
            throw new NoSuchAlgorithmException("class configured for " + string2 + ": " + string3 + " not a " + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException("class configured for " + string2 + "(provider: " + string4 + ")" + "cannot be found.\n" + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("class " + string3 + " configured for " + string2 + "(provider: " + string4 + ") cannot be " + "instantiated.\n").initCause(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchAlgorithmException("class " + string3 + " configured for " + string2 + "(provider: " + string4 + ") cannot be accessed.\n" + illegalAccessException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new NoSuchAlgorithmException("class " + string3 + " configured for " + string2 + "(provider: " + string4 + ") cannot be accessed.\n" + securityException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchAlgorithmException("constructor for class " + string3 + " configured for " + string2 + "(provider: " + string4 + ") cannot be instantiated.\n" + noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null && throwable instanceof InvalidAlgorithmParameterException) {
                throw (InvalidAlgorithmParameterException)throwable;
            }
            throw new InvalidAlgorithmParameterException("constructor for class " + string3 + " configured for " + string2 + "(provider: " + string4 + ") cannot be instantiated.\n" + invocationTargetException.getMessage());
        }
    }

    private static boolean isCriterionSatisfied(Provider provider, String string, String string2, String string3, String string4) {
        String string5;
        String string6 = string + '.' + string2;
        if (string3 != null) {
            string6 = string6 + ' ' + string3;
        }
        if ((string5 = Security.getProviderProperty(string6, provider)) == null) {
            String string7 = Security.getProviderProperty("Alg.Alias." + string + "." + string2, provider);
            if (string7 != null) {
                string6 = string + "." + string7;
                if (string3 != null) {
                    string6 = string6 + ' ' + string3;
                }
                string5 = Security.getProviderProperty(string6, provider);
            }
            if (string5 == null) {
                return false;
            }
        }
        if (string3 == null) {
            return true;
        }
        if (Security.isStandardAttr(string3)) {
            return Security.isConstraintSatisfied(string3, string4, string5);
        }
        return string4.equalsIgnoreCase(string5);
    }

    private static LinkedHashSet getProvidersNotUsingCache(String string, String string2, String string3, String string4, LinkedHashSet linkedHashSet, Provider[] providerArray) {
        if (string3 != null && linkedHashSet != null && !linkedHashSet.isEmpty()) {
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                Provider provider = (Provider)iterator.next();
                if (Security.isCriterionSatisfied(provider, string, string2, string3, string4)) continue;
                iterator.remove();
            }
        }
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            if (linkedHashSet == null) {
                linkedHashSet = new LinkedHashSet(5);
            }
            for (int i2 = 0; i2 < providerArray.length; ++i2) {
                if (!Security.isCriterionSatisfied(providerArray[i2], string, string2, string3, string4)) continue;
                linkedHashSet.add(providerArray[i2]);
            }
        }
        return linkedHashSet;
    }

    private static class ProviderProperty {
        String className;
        Provider provider;

        private ProviderProperty() {
        }
    }

    private static final class State {
        boolean reloadProviders;
        Vector providers;
        Hashtable providerLoads;
        int numOfStaticProviders;
        Vector providerMasterClassNames;
        int indexStaticProviders;
        boolean resetProviderIndex;

        private State() {
        }
    }
}

