/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapLongBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class LongBuffer
extends Buffer
implements Comparable {
    final long[] hb;
    final int offset;
    boolean isReadOnly;

    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public int hashCode() {
        int n2 = 1;
        int n3 = this.position();
        for (int i2 = this.limit() - 1; i2 >= n3; --i2) {
            n2 = 31 * n2 + (int)this.get(i2);
        }
        return n2;
    }

    public abstract long get();

    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public abstract boolean isDirect();

    public final long[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    public abstract long get(int var1);

    LongBuffer(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, null, 0);
    }

    LongBuffer(int n2, int n3, int n4, int n5, long[] lArray, int n6) {
        super(n2, n3, n4, n5);
        this.hb = lArray;
        this.offset = n6;
    }

    public int compareTo(Object object) {
        LongBuffer longBuffer = (LongBuffer)object;
        int n2 = this.position() + Math.min(this.remaining(), longBuffer.remaining());
        int n3 = this.position();
        int n4 = longBuffer.position();
        while (n3 < n2) {
            long l2;
            long l3 = this.get(n3);
            if (l3 != (l2 = longBuffer.get(n4)) && (l3 == l3 || l2 == l2)) {
                if (l3 < l2) {
                    return -1;
                }
                return 1;
            }
            ++n3;
            ++n4;
        }
        return this.remaining() - longBuffer.remaining();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LongBuffer)) {
            return false;
        }
        LongBuffer longBuffer = (LongBuffer)object;
        if (this.remaining() != longBuffer.remaining()) {
            return false;
        }
        int n2 = this.position();
        int n3 = this.limit() - 1;
        int n4 = longBuffer.limit() - 1;
        while (n3 >= n2) {
            long l2;
            long l3 = this.get(n3);
            if (l3 != (l2 = longBuffer.get(n4)) && (l3 == l3 || l2 == l2)) {
                return false;
            }
            --n3;
            --n4;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public abstract ByteOrder order();

    public abstract LongBuffer asReadOnlyBuffer();

    public abstract LongBuffer compact();

    public abstract LongBuffer duplicate();

    public abstract LongBuffer slice();

    public static LongBuffer allocate(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapLongBuffer(n2, n2);
    }

    public abstract LongBuffer put(int var1, long var2);

    public abstract LongBuffer put(long var1);

    public LongBuffer get(long[] lArray) {
        return this.get(lArray, 0, lArray.length);
    }

    public final LongBuffer put(long[] lArray) {
        return this.put(lArray, 0, lArray.length);
    }

    public static LongBuffer wrap(long[] lArray) {
        return LongBuffer.wrap(lArray, 0, lArray.length);
    }

    public LongBuffer get(long[] lArray, int n2, int n3) {
        LongBuffer.checkBounds(n2, n3, lArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            lArray[i2] = this.get();
        }
        return this;
    }

    public LongBuffer put(long[] lArray, int n2, int n3) {
        LongBuffer.checkBounds(n2, n3, lArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.put(lArray[i2]);
        }
        return this;
    }

    public static LongBuffer wrap(long[] lArray, int n2, int n3) {
        try {
            return new HeapLongBuffer(lArray, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n2 = longBuffer.remaining();
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.put(longBuffer.get());
        }
        return this;
    }
}

