/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicIterator;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public abstract class CubicCurve2D
implements Shape,
Cloneable {
    private static final int BELOW = -2;
    private static final int LOWEDGE = -1;
    private static final int INSIDE = 0;
    private static final int HIGHEDGE = 1;
    private static final int ABOVE = 2;

    public abstract double getCtrlX1();

    public abstract double getCtrlX2();

    public abstract double getCtrlY1();

    public abstract double getCtrlY2();

    public double getFlatness() {
        return CubicCurve2D.getFlatness(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public double getFlatnessSq() {
        return CubicCurve2D.getFlatnessSq(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public abstract double getX1();

    public abstract double getX2();

    public abstract double getY1();

    public abstract double getY2();

    protected CubicCurve2D() {
    }

    public boolean contains(double d2, double d3) {
        int n2 = 0;
        double d4 = this.getX1();
        double d5 = this.getY1();
        double d6 = this.getX2();
        double d7 = this.getY2();
        double d8 = d7 - d5;
        if ((d8 > 0.0 && d3 >= d5 && d3 <= d7 || d8 < 0.0 && d3 <= d5 && d3 >= d7) && d2 < d4 + (d3 - d5) * (d6 - d4) / d8) {
            ++n2;
        }
        double d9 = this.getCtrlX1();
        double d10 = this.getCtrlY1();
        double d11 = this.getCtrlX2();
        double d12 = this.getCtrlY2();
        boolean bl2 = (d7 - d5) * (d10 - d5) >= 0.0;
        boolean bl3 = (d5 - d7) * (d12 - d7) >= 0.0;
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        CubicCurve2D.fillEqn(dArray, d3, d5, d10, d12, d7);
        int n3 = CubicCurve2D.solveCubic(dArray, dArray2);
        n3 = CubicCurve2D.evalCubic(dArray2, n3, bl2, bl3, dArray, d4, d9, d11, d6);
        while (--n3 >= 0) {
            if (!(d2 < dArray2[n3])) continue;
            ++n2;
        }
        return (n2 & 1) == 1;
    }

    private static int getTag(double d2, double d3, double d4) {
        if (d2 <= d3) {
            return d2 < d3 ? -2 : -1;
        }
        if (d2 >= d4) {
            return d2 > d4 ? 2 : 1;
        }
        return 0;
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        if (!(this.contains(d2, d3) && this.contains(d2 + d4, d3) && this.contains(d2 + d4, d3 + d5) && this.contains(d2, d3 + d5))) {
            return false;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d4, d5);
        return !double_.intersectsLine(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        int n2;
        boolean bl2;
        if (d4 < 0.0 || d5 < 0.0) {
            return false;
        }
        double d6 = this.getX1();
        double d7 = this.getY1();
        int n3 = CubicCurve2D.getTag(d6, d2, d2 + d4);
        int n4 = CubicCurve2D.getTag(d7, d3, d3 + d5);
        if (n3 == 0 && n4 == 0) {
            return true;
        }
        double d8 = this.getX2();
        double d9 = this.getY2();
        int n5 = CubicCurve2D.getTag(d8, d2, d2 + d4);
        int n6 = CubicCurve2D.getTag(d9, d3, d3 + d5);
        if (n5 == 0 && n6 == 0) {
            return true;
        }
        double d10 = this.getCtrlX1();
        double d11 = this.getCtrlY1();
        double d12 = this.getCtrlX2();
        double d13 = this.getCtrlY2();
        int n7 = CubicCurve2D.getTag(d10, d2, d2 + d4);
        int n8 = CubicCurve2D.getTag(d11, d3, d3 + d5);
        int n9 = CubicCurve2D.getTag(d12, d2, d2 + d4);
        int n10 = CubicCurve2D.getTag(d13, d3, d3 + d5);
        if (n3 < 0 && n5 < 0 && n7 < 0 && n9 < 0) {
            return false;
        }
        if (n4 < 0 && n6 < 0 && n8 < 0 && n10 < 0) {
            return false;
        }
        if (n3 > 0 && n5 > 0 && n7 > 0 && n9 > 0) {
            return false;
        }
        if (n4 > 0 && n6 > 0 && n8 > 0 && n10 > 0) {
            return false;
        }
        if (CubicCurve2D.inwards(n3, n5, n7) && CubicCurve2D.inwards(n4, n6, n8)) {
            return true;
        }
        if (CubicCurve2D.inwards(n5, n3, n9) && CubicCurve2D.inwards(n6, n4, n10)) {
            return true;
        }
        boolean bl3 = n3 * n5 <= 0;
        boolean bl4 = bl2 = n4 * n6 <= 0;
        if (n3 == 0 && n5 == 0 && bl2) {
            return true;
        }
        if (n4 == 0 && n6 == 0 && bl3) {
            return true;
        }
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        if (!bl2) {
            CubicCurve2D.fillEqn(dArray, n4 < 0 ? d3 : d3 + d5, d7, d11, d13, d9);
            int n11 = CubicCurve2D.solveCubic(dArray, dArray2);
            n11 = CubicCurve2D.evalCubic(dArray2, n11, true, true, null, d6, d10, d12, d8);
            return n11 == 2 && CubicCurve2D.getTag(dArray2[0], d2, d2 + d4) * CubicCurve2D.getTag(dArray2[1], d2, d2 + d4) <= 0;
        }
        if (!bl3) {
            CubicCurve2D.fillEqn(dArray, n3 < 0 ? d2 : d2 + d4, d6, d10, d12, d8);
            int n12 = CubicCurve2D.solveCubic(dArray, dArray2);
            n12 = CubicCurve2D.evalCubic(dArray2, n12, true, true, null, d7, d11, d13, d9);
            return n12 == 2 && CubicCurve2D.getTag(dArray2[0], d3, d3 + d5) * CubicCurve2D.getTag(dArray2[1], d3, d3 + d5) <= 0;
        }
        double d14 = d8 - d6;
        double d15 = d9 - d7;
        double d16 = d9 * d6 - d8 * d7;
        int n13 = n4 == 0 ? n3 : CubicCurve2D.getTag((d16 + d14 * (n4 < 0 ? d3 : d3 + d5)) / d15, d2, d2 + d4);
        if (n13 * (n2 = n6 == 0 ? n5 : CubicCurve2D.getTag((d16 + d14 * (n6 < 0 ? d3 : d3 + d5)) / d15, d2, d2 + d4)) <= 0) {
            return true;
        }
        n13 = n13 * n3 <= 0 ? n4 : n6;
        CubicCurve2D.fillEqn(dArray, n2 < 0 ? d2 : d2 + d4, d6, d10, d12, d8);
        int n14 = CubicCurve2D.solveCubic(dArray, dArray2);
        n14 = CubicCurve2D.evalCubic(dArray2, n14, true, true, null, d7, d11, d13, d9);
        int[] nArray = new int[n14 + 1];
        for (int i2 = 0; i2 < n14; ++i2) {
            nArray[i2] = CubicCurve2D.getTag(dArray2[i2], d3, d3 + d5);
        }
        nArray[n14] = n13;
        Arrays.sort(nArray);
        return n14 >= 1 && nArray[0] * nArray[1] <= 0 || n14 >= 3 && nArray[2] * nArray[3] <= 0;
    }

    public static double getFlatness(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return Math.sqrt(CubicCurve2D.getFlatnessSq(d2, d3, d4, d5, d6, d7, d8, d9));
    }

    public static double getFlatnessSq(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return Math.max(Line2D.ptSegDistSq(d2, d3, d8, d9, d4, d5), Line2D.ptSegDistSq(d2, d3, d8, d9, d6, d7));
    }

    public abstract void setCurve(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    private static double findZero(double d2, double d3, double[] dArray) {
        double[] dArray2 = new double[]{dArray[1], 2.0 * dArray[2], 3.0 * dArray[3]};
        double d4 = 0.0;
        double d5 = d2;
        double d6;
        while ((d6 = CubicCurve2D.solveEqn(dArray2, 2, d2)) != 0.0) {
            double d7;
            double d8 = CubicCurve2D.solveEqn(dArray, 3, d2);
            if (d8 == 0.0) {
                return d2;
            }
            double d9 = -(d8 / d6);
            if (d4 == 0.0) {
                d4 = d9;
            }
            if (d2 < d3) {
                if (d9 < 0.0) {
                    return d2;
                }
            } else if (d2 > d3) {
                if (d9 > 0.0) {
                    return d2;
                }
            } else {
                return d9 > 0.0 ? d3 + java.lang.Double.MIN_VALUE : d3 - java.lang.Double.MIN_VALUE;
            }
            if (d2 == (d7 = d2 + d9)) {
                return d2;
            }
            if (d9 * d4 < 0.0) {
                int n2;
                int n3 = n2 = d5 < d2 ? CubicCurve2D.getTag(d3, d5, d2) : CubicCurve2D.getTag(d3, d2, d5);
                if (n2 != 0) {
                    return (d5 + d2) / 2.0;
                }
                d2 = d3;
                continue;
            }
            d2 = d7;
        }
        return d2;
    }

    private static boolean inwards(int n2, int n3, int n4) {
        switch (n2) {
            default: {
                return false;
            }
            case -1: {
                return n3 >= 0 || n4 >= 0;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return n3 <= 0 || n4 <= 0;
    }

    public static int solveCubic(double[] dArray) {
        return CubicCurve2D.solveCubic(dArray, dArray);
    }

    private static void fillEqn(double[] dArray, double d2, double d3, double d4, double d5, double d6) {
        dArray[0] = d3 - d2;
        dArray[1] = (d4 - d3) * 3.0;
        dArray[2] = (d5 - d4 - d4 + d3) * 3.0;
        dArray[3] = d6 + (d4 - d5) * 3.0 - d3;
    }

    public static double getFlatness(double[] dArray, int n2) {
        return CubicCurve2D.getFlatness(dArray[n2 + 0], dArray[n2 + 1], dArray[n2 + 2], dArray[n2 + 3], dArray[n2 + 4], dArray[n2 + 5], dArray[n2 + 6], dArray[n2 + 7]);
    }

    public static double getFlatnessSq(double[] dArray, int n2) {
        return CubicCurve2D.getFlatnessSq(dArray[n2 + 0], dArray[n2 + 1], dArray[n2 + 2], dArray[n2 + 3], dArray[n2 + 4], dArray[n2 + 5], dArray[n2 + 6], dArray[n2 + 7]);
    }

    public void setCurve(double[] dArray, int n2) {
        this.setCurve(dArray[n2 + 0], dArray[n2 + 1], dArray[n2 + 2], dArray[n2 + 3], dArray[n2 + 4], dArray[n2 + 5], dArray[n2 + 6], dArray[n2 + 7]);
    }

    private static double solveEqn(double[] dArray, int n2, double d2) {
        double d3 = dArray[n2];
        while (--n2 >= 0) {
            d3 = d3 * d2 + dArray[n2];
        }
        return d3;
    }

    private static int evalCubic(double[] dArray, int n2, boolean bl2, boolean bl3, double[] dArray2, double d2, double d3, double d4, double d5) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d6 = dArray[i2];
            if (!(bl2 ? d6 >= 0.0 : d6 > 0.0) || !(bl3 ? d6 <= 1.0 : d6 < 1.0) || dArray2 != null && dArray2[1] + (2.0 * dArray2[2] + 3.0 * dArray2[3] * d6) * d6 == 0.0) continue;
            double d7 = 1.0 - d6;
            dArray[n3++] = d2 * d7 * d7 * d7 + 3.0 * d3 * d6 * d7 * d7 + 3.0 * d4 * d6 * d6 * d7 + d5 * d6 * d6 * d6;
        }
        return n3;
    }

    public static void subdivide(double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3, int n4) {
        double d2 = dArray[n2 + 0];
        double d3 = dArray[n2 + 1];
        double d4 = dArray[n2 + 2];
        double d5 = dArray[n2 + 3];
        double d6 = dArray[n2 + 4];
        double d7 = dArray[n2 + 5];
        double d8 = dArray[n2 + 6];
        double d9 = dArray[n2 + 7];
        if (dArray2 != null) {
            dArray2[n3 + 0] = d2;
            dArray2[n3 + 1] = d3;
        }
        if (dArray3 != null) {
            dArray3[n4 + 6] = d8;
            dArray3[n4 + 7] = d9;
        }
        d2 = (d2 + d4) / 2.0;
        d3 = (d3 + d5) / 2.0;
        d8 = (d8 + d6) / 2.0;
        d9 = (d9 + d7) / 2.0;
        double d10 = (d4 + d6) / 2.0;
        double d11 = (d5 + d7) / 2.0;
        d4 = (d2 + d10) / 2.0;
        d5 = (d3 + d11) / 2.0;
        d6 = (d8 + d10) / 2.0;
        d7 = (d9 + d11) / 2.0;
        d10 = (d4 + d6) / 2.0;
        d11 = (d5 + d7) / 2.0;
        if (dArray2 != null) {
            dArray2[n3 + 2] = d2;
            dArray2[n3 + 3] = d3;
            dArray2[n3 + 4] = d4;
            dArray2[n3 + 5] = d5;
            dArray2[n3 + 6] = d10;
            dArray2[n3 + 7] = d11;
        }
        if (dArray3 != null) {
            dArray3[n4 + 0] = d10;
            dArray3[n4 + 1] = d11;
            dArray3[n4 + 2] = d6;
            dArray3[n4 + 3] = d7;
            dArray3[n4 + 4] = d8;
            dArray3[n4 + 5] = d9;
        }
    }

    public static int solveCubic(double[] dArray, double[] dArray2) {
        double d2 = dArray[3];
        if (d2 == 0.0) {
            return QuadCurve2D.solveQuadratic(dArray, dArray2);
        }
        double d3 = dArray[2] / d2;
        double d4 = dArray[1] / d2;
        double d5 = dArray[0] / d2;
        int n2 = 0;
        double d6 = (d3 * d3 - 3.0 * d4) / 9.0;
        double d7 = (2.0 * d3 * d3 * d3 - 9.0 * d3 * d4 + 27.0 * d5) / 54.0;
        double d8 = d7 * d7;
        double d9 = d6 * d6 * d6;
        d3 /= 3.0;
        if (d8 < d9) {
            double d10 = Math.acos(d7 / Math.sqrt(d9));
            d6 = -2.0 * Math.sqrt(d6);
            if (dArray2 == dArray) {
                dArray = new double[4];
                System.arraycopy(dArray2, 0, dArray, 0, 4);
            }
            dArray2[n2++] = d6 * Math.cos(d10 / 3.0) - d3;
            dArray2[n2++] = d6 * Math.cos((d10 + Math.PI * 2) / 3.0) - d3;
            dArray2[n2++] = d6 * Math.cos((d10 - Math.PI * 2) / 3.0) - d3;
            CubicCurve2D.fixRoots(dArray2, dArray);
        } else {
            boolean bl2 = d7 < 0.0;
            double d11 = Math.sqrt(d8 - d9);
            if (bl2) {
                d7 = -d7;
            }
            double d12 = Math.pow(d7 + d11, 0.3333333333333333);
            if (!bl2) {
                d12 = -d12;
            }
            double d13 = d12 == 0.0 ? 0.0 : d6 / d12;
            dArray2[n2++] = d12 + d13 - d3;
        }
        return n2;
    }

    private static void fixRoots(double[] dArray, double[] dArray2) {
        for (int i2 = 0; i2 < 3; ++i2) {
            double d2 = dArray[i2];
            if (Math.abs(d2) < 1.0E-5) {
                dArray[i2] = CubicCurve2D.findZero(d2, 0.0, dArray2);
                continue;
            }
            if (!(Math.abs(d2 - 1.0) < 1.0E-5)) continue;
            dArray[i2] = CubicCurve2D.findZero(d2, 1.0, dArray2);
        }
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public void setCurve(CubicCurve2D cubicCurve2D) {
        this.setCurve(cubicCurve2D.getX1(), cubicCurve2D.getY1(), cubicCurve2D.getCtrlX1(), cubicCurve2D.getCtrlY1(), cubicCurve2D.getCtrlX2(), cubicCurve2D.getCtrlY2(), cubicCurve2D.getX2(), cubicCurve2D.getY2());
    }

    public abstract Point2D getCtrlP1();

    public abstract Point2D getCtrlP2();

    public abstract Point2D getP1();

    public abstract Point2D getP2();

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public void setCurve(Point2D[] point2DArray, int n2) {
        this.setCurve(point2DArray[n2 + 0].getX(), point2DArray[n2 + 0].getY(), point2DArray[n2 + 1].getX(), point2DArray[n2 + 1].getY(), point2DArray[n2 + 2].getX(), point2DArray[n2 + 2].getY(), point2DArray[n2 + 3].getX(), point2DArray[n2 + 3].getY());
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void subdivide(CubicCurve2D cubicCurve2D, CubicCurve2D cubicCurve2D2) {
        CubicCurve2D.subdivide(this, cubicCurve2D, cubicCurve2D2);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new CubicIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d2);
    }

    public static void subdivide(CubicCurve2D cubicCurve2D, CubicCurve2D cubicCurve2D2, CubicCurve2D cubicCurve2D3) {
        double d2 = cubicCurve2D.getX1();
        double d3 = cubicCurve2D.getY1();
        double d4 = cubicCurve2D.getCtrlX1();
        double d5 = cubicCurve2D.getCtrlY1();
        double d6 = cubicCurve2D.getCtrlX2();
        double d7 = cubicCurve2D.getCtrlY2();
        double d8 = cubicCurve2D.getX2();
        double d9 = cubicCurve2D.getY2();
        double d10 = (d4 + d6) / 2.0;
        double d11 = (d5 + d7) / 2.0;
        d4 = (d2 + d4) / 2.0;
        d5 = (d3 + d5) / 2.0;
        d6 = (d8 + d6) / 2.0;
        d7 = (d9 + d7) / 2.0;
        double d12 = (d4 + d10) / 2.0;
        double d13 = (d5 + d11) / 2.0;
        double d14 = (d6 + d10) / 2.0;
        double d15 = (d7 + d11) / 2.0;
        d10 = (d12 + d14) / 2.0;
        d11 = (d13 + d15) / 2.0;
        if (cubicCurve2D2 != null) {
            cubicCurve2D2.setCurve(d2, d3, d4, d5, d12, d13, d10, d11);
        }
        if (cubicCurve2D3 != null) {
            cubicCurve2D3.setCurve(d10, d11, d14, d15, d6, d7, d8, d9);
        }
    }

    public void setCurve(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        this.setCurve(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY());
    }

    public static class Double
    extends CubicCurve2D {
        public double x1;
        public double y1;
        public double ctrlx1;
        public double ctrly1;
        public double ctrlx2;
        public double ctrly2;
        public double x2;
        public double y2;

        public double getCtrlX1() {
            return this.ctrlx1;
        }

        public double getCtrlX2() {
            return this.ctrlx2;
        }

        public double getCtrlY1() {
            return this.ctrly1;
        }

        public double getCtrlY2() {
            return this.ctrly2;
        }

        public double getX1() {
            return this.x1;
        }

        public double getX2() {
            return this.x2;
        }

        public double getY1() {
            return this.y1;
        }

        public double getY2() {
            return this.y2;
        }

        public Double() {
        }

        public Double(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
            this.setCurve(d2, d3, d4, d5, d6, d7, d8, d9);
        }

        public void setCurve(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
            this.x1 = d2;
            this.y1 = d3;
            this.ctrlx1 = d4;
            this.ctrly1 = d5;
            this.ctrlx2 = d6;
            this.ctrly2 = d7;
            this.x2 = d8;
            this.y2 = d9;
        }

        public Point2D getCtrlP1() {
            return new Point2D.Double(this.ctrlx1, this.ctrly1);
        }

        public Point2D getCtrlP2() {
            return new Point2D.Double(this.ctrlx2, this.ctrly2);
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public Rectangle2D getBounds2D() {
            double d2 = Math.min(Math.min(this.x1, this.x2), Math.min(this.ctrlx1, this.ctrlx2));
            double d3 = Math.min(Math.min(this.y1, this.y2), Math.min(this.ctrly1, this.ctrly2));
            double d4 = Math.max(Math.max(this.x1, this.x2), Math.max(this.ctrlx1, this.ctrlx2));
            double d5 = Math.max(Math.max(this.y1, this.y2), Math.max(this.ctrly1, this.ctrly2));
            return new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
        }
    }

    public static class Float
    extends CubicCurve2D {
        public float x1;
        public float y1;
        public float ctrlx1;
        public float ctrly1;
        public float ctrlx2;
        public float ctrly2;
        public float x2;
        public float y2;

        public double getCtrlX1() {
            return this.ctrlx1;
        }

        public double getCtrlX2() {
            return this.ctrlx2;
        }

        public double getCtrlY1() {
            return this.ctrly1;
        }

        public double getCtrlY2() {
            return this.ctrly2;
        }

        public double getX1() {
            return this.x1;
        }

        public double getX2() {
            return this.x2;
        }

        public double getY1() {
            return this.y1;
        }

        public double getY2() {
            return this.y2;
        }

        public Float() {
        }

        public void setCurve(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
            this.x1 = (float)d2;
            this.y1 = (float)d3;
            this.ctrlx1 = (float)d4;
            this.ctrly1 = (float)d5;
            this.ctrlx2 = (float)d6;
            this.ctrly2 = (float)d7;
            this.x2 = (float)d8;
            this.y2 = (float)d9;
        }

        public Float(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
            this.setCurve(f2, f3, f4, f5, f6, f7, f8, f9);
        }

        public void setCurve(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
            this.x1 = f2;
            this.y1 = f3;
            this.ctrlx1 = f4;
            this.ctrly1 = f5;
            this.ctrlx2 = f6;
            this.ctrly2 = f7;
            this.x2 = f8;
            this.y2 = f9;
        }

        public Point2D getCtrlP1() {
            return new Point2D.Float(this.ctrlx1, this.ctrly1);
        }

        public Point2D getCtrlP2() {
            return new Point2D.Float(this.ctrlx2, this.ctrly2);
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public Rectangle2D getBounds2D() {
            float f2 = Math.min(Math.min(this.x1, this.x2), Math.min(this.ctrlx1, this.ctrlx2));
            float f3 = Math.min(Math.min(this.y1, this.y2), Math.min(this.ctrly1, this.ctrly2));
            float f4 = Math.max(Math.max(this.x1, this.x2), Math.max(this.ctrlx1, this.ctrlx2));
            float f5 = Math.max(Math.max(this.y1, this.y2), Math.max(this.ctrly1, this.ctrly2));
            return new Rectangle2D.Float(f2, f3, f4 - f2, f5 - f3);
        }
    }
}

