/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunCodec;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class AlawCodec
extends SunCodec {
    static final byte[] ALAW_TABH = new byte[256];
    static final byte[] ALAW_TABL = new byte[256];
    private static final AudioFormat.Encoding[] alawEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.ALAW, AudioFormat.Encoding.PCM_SIGNED};
    private static final short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
    private static final int tempBufferSize = 64;
    private byte[] tempBuffer = null;

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            int n2 = i2 ^ 0x55;
            int n3 = (n2 & 0xF) << 4;
            int n4 = (n2 & 0x70) >> 4;
            int n5 = n3 + 8;
            if (n4 >= 1) {
                n5 += 256;
            }
            if (n4 > 1) {
                n5 <<= n4 - 1;
            }
            if ((n2 & 0x80) == 0) {
                n5 = -n5;
            }
            AlawCodec.ALAW_TABL[i2] = (byte)n5;
            AlawCodec.ALAW_TABH[i2] = (byte)(n5 >> 8);
        }
    }

    public AlawCodec() {
        super(alawEncodings, alawEncodings);
    }

    private AudioFormat[] getOutputFormats(AudioFormat audioFormat) {
        AudioFormat audioFormat2;
        Vector vector = new Vector();
        if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.ALAW, audioFormat.getSampleRate(), 8, audioFormat.getChannels(), audioFormat.getChannels(), audioFormat.getSampleRate(), false);
            vector.addElement(audioFormat2);
        }
        if (audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
            vector.addElement(audioFormat2);
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), true);
            vector.addElement(audioFormat2);
        }
        AudioFormat[] audioFormatArray = new AudioFormat[vector.size()];
        for (int i2 = 0; i2 < audioFormatArray.length; ++i2) {
            audioFormatArray[i2] = (AudioFormat)vector.elementAt(i2);
        }
        return audioFormatArray;
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (audioFormat.getSampleSizeInBits() == 16) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.ALAW};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        return new AudioFormat.Encoding[0];
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW) || encoding.equals(AudioFormat.Encoding.ALAW) && audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            return this.getOutputFormats(audioFormat);
        }
        return new AudioFormat[0];
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        return this.getConvertedStream(audioFormat, audioInputStream);
    }

    private AudioInputStream getConvertedStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioInputStream audioInputStream2 = null;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (audioFormat2.matches(audioFormat)) {
            audioInputStream2 = audioInputStream;
        } else {
            audioInputStream2 = new AlawCodecStream(audioInputStream, audioFormat);
            this.tempBuffer = new byte[64];
        }
        return audioInputStream2;
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat.getEncoding();
        if (encoding2.equals(encoding)) {
            return audioInputStream;
        }
        AudioFormat audioFormat2 = null;
        if (!this.isConversionSupported(encoding, audioInputStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        if (encoding2.equals(AudioFormat.Encoding.ALAW) && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 2 * audioFormat.getChannels(), audioFormat.getSampleRate(), audioFormat.isBigEndian());
        } else if (encoding2.equals(AudioFormat.Encoding.PCM_SIGNED) && encoding.equals(AudioFormat.Encoding.ALAW)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), 8, audioFormat.getChannels(), audioFormat.getChannels(), audioFormat.getSampleRate(), false);
        } else {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        return this.getAudioInputStream(audioFormat2, audioInputStream);
    }

    class AlawCodecStream
    extends AudioInputStream {
        boolean encode;
        AudioFormat encodeFormat;
        AudioFormat decodeFormat;
        byte[] tabByte1;
        byte[] tabByte2;
        int highByte;
        int lowByte;

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            return this.read(byArray, 0, byArray.length);
        }

        private short search(short s2, short[] sArray, short s3) {
            for (short s4 = 0; s4 < s3; s4 = (short)(s4 + 1)) {
                if (s2 > sArray[s4]) continue;
                return s4;
            }
            return s3;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            if (n3 % this.frameSize != 0) {
                n3 -= n3 % this.frameSize;
            }
            if (this.encode) {
                int n5;
                int n6 = 15;
                int n7 = 4;
                int n8 = 0;
                int n9 = n2;
                int n10 = n3 * 2;
                int n11 = n5 = n10 > 64 ? 64 : n10;
                while ((n8 = super.read(AlawCodec.this.tempBuffer, 0, n5)) > 0) {
                    for (int i2 = 0; i2 < n8; i2 += 2) {
                        byte by;
                        int n12;
                        short s2 = (short)(AlawCodec.this.tempBuffer[i2 + this.highByte] << 8 & 0xFF00);
                        if ((s2 = (short)(s2 | (short)(AlawCodec.this.tempBuffer[i2 + this.lowByte] & 0xFF))) >= 0) {
                            n12 = 213;
                        } else {
                            n12 = 85;
                            s2 = (short)(-s2 - 8);
                        }
                        short s3 = this.search(s2, seg_end, (short)8);
                        if (s3 >= 8) {
                            by = (byte)(0x7F ^ n12);
                        } else {
                            by = (byte)(s3 << n7);
                            by = s3 < 2 ? (byte)(by | (byte)(s2 >> 4 & n6)) : (byte)(by | (byte)(s2 >> s3 + 3 & n6));
                            by = (byte)(by ^ n12);
                        }
                        byArray[n9] = by;
                        ++n9;
                    }
                    n5 = (n10 -= n8) > 64 ? 64 : n10;
                }
                if (n9 == n2 && n8 < 0) {
                    return n8;
                }
                return n9 - n2;
            }
            int n13 = n3 / 2;
            int n14 = n2 + n3 / 2;
            int n15 = super.read(byArray, n14, n13);
            for (n4 = n2; n4 < n2 + n15 * 2; n4 += 2) {
                byArray[n4] = this.tabByte1[byArray[n14] & 0xFF];
                byArray[n4 + 1] = this.tabByte2[byArray[n14] & 0xFF];
                ++n14;
            }
            if (n15 < 0) {
                return n15;
            }
            return n4 - n2;
        }

        AlawCodecStream(AudioInputStream audioInputStream, AudioFormat audioFormat) {
            boolean bl2;
            super(audioInputStream, audioFormat, -1L);
            this.encode = false;
            this.tabByte1 = null;
            this.tabByte2 = null;
            this.highByte = 0;
            this.lowByte = 1;
            AudioFormat audioFormat2 = audioInputStream.getFormat();
            if (!AlawCodec.this.isConversionSupported(audioFormat, audioFormat2)) {
                throw new IllegalArgumentException("Unsupported conversion: " + audioFormat2.toString() + " to " + audioFormat.toString());
            }
            if (audioFormat2.getEncoding() == AudioFormat.Encoding.ALAW) {
                this.encode = false;
                this.encodeFormat = audioFormat2;
                this.decodeFormat = audioFormat;
                bl2 = audioFormat.isBigEndian();
            } else {
                this.encode = true;
                this.encodeFormat = audioFormat;
                this.decodeFormat = audioFormat2;
                bl2 = audioFormat2.isBigEndian();
            }
            if (bl2) {
                this.tabByte1 = ALAW_TABH;
                this.tabByte2 = ALAW_TABL;
                this.highByte = 0;
                this.lowByte = 1;
            } else {
                this.tabByte1 = ALAW_TABL;
                this.tabByte2 = ALAW_TABH;
                this.highByte = 1;
                this.lowByte = 0;
            }
            if (audioInputStream instanceof AudioInputStream) {
                this.frameLength = audioInputStream.getFrameLength();
            }
            this.framePos = 0L;
            this.frameSize = audioFormat2.getFrameSize();
            if (this.frameSize == -1) {
                this.frameSize = 1;
            }
        }
    }
}

