/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.dir;

import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class ContextEnumerator
implements NamingEnumeration {
    private static boolean debug = false;
    private NamingEnumeration children = null;
    private Binding currentChild = null;
    private boolean currentReturned = false;
    private Context root;
    private ContextEnumerator currentChildEnum = null;
    private boolean currentChildExpanded = false;
    private boolean rootProcessed = false;
    private int scope = 2;
    private String contextName = "";

    public void close() throws NamingException {
        this.root = null;
    }

    private void prepNextChild() throws NamingException {
        if (this.hasMoreChildren()) {
            try {
                this.currentChild = this.getNextChild();
                this.currentReturned = false;
            }
            catch (NamingException namingException) {
                if (debug) {
                    System.out.println(namingException);
                }
                if (debug) {
                    namingException.printStackTrace();
                }
            }
        } else {
            this.currentChild = null;
            return;
        }
        if (this.scope == 2 && this.currentChild.getObject() instanceof Context) {
            this.currentChildEnum = this.newEnumerator((Context)this.currentChild.getObject(), this.scope, this.currentChild.getName(), false);
            this.currentChildExpanded = true;
            if (debug) {
                System.out.println("prepNextChild: expanded");
            }
        } else {
            this.currentChildExpanded = false;
            this.currentChildEnum = null;
            if (debug) {
                System.out.println("prepNextChild: normal");
            }
        }
    }

    public boolean hasMore() throws NamingException {
        return !this.rootProcessed || this.scope != 0 && this.hasMoreDescendants();
    }

    private boolean hasMoreChildren() throws NamingException {
        return this.children != null && this.children.hasMore();
    }

    private boolean hasMoreDescendants() throws NamingException {
        if (!this.currentReturned) {
            if (debug) {
                System.out.println("hasMoreDescendants returning " + (this.currentChild != null));
            }
            return this.currentChild != null;
        }
        if (this.currentChildExpanded && this.currentChildEnum.hasMore()) {
            if (debug) {
                System.out.println("hasMoreDescendants returning true");
            }
            return true;
        }
        if (debug) {
            System.out.println("hasMoreDescendants returning hasMoreChildren");
        }
        return this.hasMoreChildren();
    }

    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    public Object next() throws NamingException {
        if (!this.rootProcessed) {
            this.rootProcessed = true;
            return new Binding("", this.root.getClass().getName(), this.root, true);
        }
        if (this.scope != 0 && this.hasMoreDescendants()) {
            return this.getNextDescendant();
        }
        throw new NoSuchElementException();
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException(namingException.toString());
        }
    }

    private Binding getNextChild() throws NamingException {
        Binding binding = (Binding)this.children.next();
        Binding binding2 = null;
        if (binding.isRelative() && !this.contextName.equals("")) {
            NameParser nameParser = this.root.getNameParser("");
            Name name = nameParser.parse(this.contextName);
            name.add(binding.getName());
            if (debug) {
                System.out.println("ContextEnumerator: adding " + name);
            }
            binding2 = new Binding(name.toString(), binding.getClassName(), binding.getObject(), binding.isRelative());
        } else {
            if (debug) {
                System.out.println("ContextEnumerator: using old binding");
            }
            binding2 = binding;
        }
        return binding2;
    }

    private Binding getNextDescendant() throws NamingException {
        if (!this.currentReturned) {
            if (debug) {
                System.out.println("getNextDescedant: simple case");
            }
            this.currentReturned = true;
            return this.currentChild;
        }
        if (this.currentChildExpanded && this.currentChildEnum.hasMore()) {
            if (debug) {
                System.out.println("getNextDescedant: expanded case");
            }
            return (Binding)this.currentChildEnum.next();
        }
        if (debug) {
            System.out.println("getNextDescedant: next case");
        }
        this.prepNextChild();
        return this.getNextDescendant();
    }

    public ContextEnumerator(Context context) throws NamingException {
        this(context, 2);
    }

    public ContextEnumerator(Context context, int n2) throws NamingException {
        this(context, n2, "", n2 != 1);
    }

    protected ContextEnumerator(Context context, int n2, String string, boolean bl2) throws NamingException {
        if (context == null) {
            throw new IllegalArgumentException("null context passed");
        }
        this.root = context;
        if (n2 != 0) {
            this.children = this.getImmediateChildren(context);
        }
        this.scope = n2;
        this.contextName = string;
        this.rootProcessed = !bl2;
        this.prepNextChild();
    }

    protected NamingEnumeration getImmediateChildren(Context context) throws NamingException {
        return context.listBindings("");
    }

    protected ContextEnumerator newEnumerator(Context context, int n2, String string, boolean bl2) throws NamingException {
        return new ContextEnumerator(context, n2, string, bl2);
    }
}

