/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.protocol.http;

import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.plugin.net.protocol.socks.SocksSocket;
import sun.plugin.net.proxy.PluginProxyManager;
import sun.plugin.net.proxy.ProxyInfo;

public final class HttpClient
extends sun.net.www.http.HttpClient {
    private boolean resolveProxy = true;

    public HttpClient(URL uRL, String string, int n, boolean bl) throws IOException {
        super(uRL, string, n);
        this.resolveProxy = bl;
    }

    public static sun.net.www.http.HttpClient New(URL uRL, String string, int n, boolean bl) throws IOException {
        Object object = kac.get(uRL, null);
        HttpClient httpClient = null;
        if (object instanceof HttpClient) {
            httpClient = (HttpClient)object;
        }
        if (httpClient == null) {
            httpClient = new HttpClient(uRL, string, n, bl);
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            httpClient.url = uRL;
        }
        return httpClient;
    }

    protected Socket doConnect(final String string, final int n) throws IOException, UnknownHostException {
        ProxyInfo proxyInfo;
        if (this.resolveProxy && (proxyInfo = PluginProxyManager.getProxyInfo(this.url)) != null && proxyInfo.isSocksUsed()) {
            try {
                return (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new SocksSocket(string, n, proxyInfo.getSocksProxy(), proxyInfo.getSocksPort());
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                IOException iOException = (IOException)privilegedActionException.getException();
                throw iOException;
            }
        }
        return super.doConnect(string, n);
    }
}

