/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.DownloadWindow;
import com.sun.javaws.LaunchErrorDialog;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.Main;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.jnlp.JNLPClassLoader;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import javax.jnlp.ExtensionInstallerService;

public final class ExtensionInstallerServiceImpl
implements ExtensionInstallerService {
    private LocalApplicationProperties _lap;
    private DownloadWindow _window;
    private String _target;
    private String _installPath;
    static ExtensionInstallerServiceImpl _sharedInstance = null;

    public void hideProgressBar() {
        this._window.setProgressBarVisible(false);
    }

    public void hideStatusWindow() {
        this._window.getFrame().setVisible(false);
    }

    public void installFailed() {
        if (Globals.TraceExtensions) {
            Debug.println("installFailed");
        }
        Main.systemExit(1);
    }

    public void updateProgress(int n) {
        this._window.setProgressBarValue(n);
    }

    public void installSucceeded(boolean bl) {
        if (Globals.TraceExtensions) {
            Debug.println("installSucceded");
        }
        final ConfigProperties configProperties = ConfigProperties.getInstance();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                configProperties.store();
                return null;
            }
        });
        this._lap.setInstallDirectory(this._installPath);
        if (bl) {
            this._lap.setRebootNeeded(true);
        } else {
            this._lap.setLocallyInstalled(true);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ExtensionInstallerServiceImpl.this._lap.store();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                LaunchErrorDialog.show(this._window.getFrame(), (IOException)privilegedActionException.getException());
            }
            Debug.ignoredException(privilegedActionException.getException());
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Main.systemExit(0);
                return null;
            }
        });
    }

    public static synchronized ExtensionInstallerServiceImpl getInstance() {
        return _sharedInstance;
    }

    public String getExtensionVersion() {
        return this._lap.getVersionId();
    }

    public String getInstallPath() {
        return this._installPath;
    }

    public void setHeading(String string) {
        this._window.setStatus(string);
    }

    public void setNativeLibraryInfo(String string) {
        if (Globals.TraceExtensions) {
            Debug.println("setNativeLibInfo: " + string);
        }
        this._lap.setNativeLibDirectory(string);
    }

    public void setStatus(String string) {
        this._window.setProgressText(string);
    }

    public URL getExtensionLocation() {
        return this._lap.getLocation();
    }

    public void setJREInfo(String string, String string2) {
        int n = JNLPClassLoader.getInstance().getDefaultSecurityModel();
        if (n != 1 && n != 2) {
            throw new SecurityException("Unsigned extension installer attempting to call setJREInfo.");
        }
        if (Globals.TraceExtensions) {
            Debug.println("setJREInfo: " + string2);
        }
        if (string2 != null) {
            ConfigProperties configProperties = ConfigProperties.getInstance();
            ArrayList arrayList = configProperties.getJREInformationList();
            arrayList.add(new ConfigProperties.JREInformation(string, this.getExtensionVersion(), this.getExtensionLocation(), string2, 0, true, ConfigProperties.getNextAvailableUserJREIndex(), Globals.osName, Globals.osArch));
        }
    }

    private ExtensionInstallerServiceImpl(String string, LocalApplicationProperties localApplicationProperties, DownloadWindow downloadWindow) {
        this._lap = localApplicationProperties;
        this._window = downloadWindow;
        this._installPath = string;
    }

    public static synchronized void initialize(String string, LocalApplicationProperties localApplicationProperties, DownloadWindow downloadWindow) {
        if (_sharedInstance == null) {
            _sharedInstance = new ExtensionInstallerServiceImpl(string, localApplicationProperties, downloadWindow);
        }
    }

    public String getInstalledJRE(URL uRL, String string) {
        ConfigProperties configProperties = ConfigProperties.getInstance();
        ConfigProperties.JREInformation jREInformation = configProperties.getJRE(uRL, string);
        return jREInformation != null ? jREInformation.getInstalledPath() : null;
    }
}

