/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.IcoEncoder;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.NativeLibrary;
import com.sun.javaws.Resources;
import com.sun.javaws.WinRegistry;
import com.sun.javaws.cache.CacheUtilities;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.general.GeneralUtilities;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class WinInstallHandler
extends LocalInstallHandler {
    private static final String INSTALLED_DESKTOP_SHORTCUT_KEY = "windows.installedDesktopShortcut";
    private static final String INSTALLED_START_MENU_KEY = "windows.installedStartMenuShortcut";
    private static final int IMAGE_SIZE = 32;
    private static final int IMAGE_TYPE = 1;
    private static final int IMAGE_KIND = 0;
    public static final int TYPE_DESKTOP = 1;
    public static final int TYPE_START_MENU = 2;
    private static final String REG_SHORTCUT_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    private static final String REG_DESKTOP_PATH_KEY = "Desktop";
    private static final String REG_START_MENU_PATH_KEY = "Programs";
    private static final String SHORTCUT_EXTENSION = ".lnk";
    private static final int MAX_PATH = 200;
    private boolean _loadedPaths = false;
    private String _desktopPath;
    private String _startMenuPath;

    static {
        NativeLibrary.getInstance().load();
    }

    private void loadPathsIfNecessary() {
        if (!this._loadedPaths) {
            this._desktopPath = WinRegistry.getString(-2147483647, REG_SHORTCUT_PATH, REG_DESKTOP_PATH_KEY);
            if (this._desktopPath != null && this._desktopPath.length() > 0 && this._desktopPath.charAt(this._desktopPath.length() - 1) != '\\') {
                this._desktopPath = this._desktopPath + '\\';
            }
            this._startMenuPath = WinRegistry.getString(-2147483647, REG_SHORTCUT_PATH, REG_START_MENU_PATH_KEY);
            if (this._startMenuPath != null && this._startMenuPath.length() > 0 && this._startMenuPath.charAt(this._startMenuPath.length() - 1) != '\\') {
                this._startMenuPath = this._startMenuPath + '\\';
            }
            this._loadedPaths = true;
            if (Globals.TraceLocalAppInstall) {
                Debug.println("Start path: " + this._startMenuPath + " desktop " + this._desktopPath);
            }
        }
    }

    public boolean isLocalInstallSupported() {
        return true;
    }

    private void save(LocalApplicationProperties localApplicationProperties) {
        block2: {
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                if (!Globals.TraceLocalAppInstall) break block2;
                Debug.println("Couldn't save LAP: " + iOException);
            }
        }
    }

    private void uninstallFailed(final LaunchDesc launchDesc) {
        Runnable runnable = new Runnable(){

            public void run() {
                GeneralUtilities.showMessageDialog(null, Resources.getString("windowsInstall.uninstallFailed", WinInstallHandler.this.getInstallName(launchDesc)), Resources.getString("windowsInstall.uninstallFailedTitle"), 0);
            }
        };
        this.invokeRunnable(runnable);
    }

    private boolean hasValidTitle(LaunchDesc launchDesc) {
        if (launchDesc == null) {
            return false;
        }
        InformationDesc informationDesc = launchDesc.getInformation();
        if (informationDesc == null || informationDesc.getTitle() == null) {
            if (Globals.TraceLocalAppInstall) {
                Debug.println("Invalid: No title!");
            }
            return false;
        }
        return true;
    }

    private boolean isApplicationInstalled(LaunchDesc launchDesc) {
        this.loadPathsIfNecessary();
        String string = this.getDesktopPath(launchDesc);
        if (string == null) {
            return true;
        }
        if (new File(string).exists()) {
            if (Globals.TraceLocalAppInstall) {
                Debug.println("Shortcut exists, bailing");
            }
            return true;
        }
        string = this.getStartMenuPath(launchDesc);
        if (string == null) {
            return true;
        }
        if (new File(string).exists()) {
            if (Globals.TraceLocalAppInstall) {
                Debug.println("Start menu exists, bailing");
            }
            return true;
        }
        return false;
    }

    private boolean shouldInstallOverExisting(final LaunchDesc launchDesc) {
        final int[] nArray = new int[]{1};
        Runnable runnable = new Runnable(){

            public void run() {
                nArray[0] = GeneralUtilities.showOptionDialog(null, Resources.getString("windowsInstall.applicationAlreadyInstalled", WinInstallHandler.this.getInstallName(launchDesc)), Resources.getString("windowsInstall.applicationAlreadyInstalledTitle"), 0, 3);
            }
        };
        this.invokeRunnable(runnable);
        return nArray[0] == 0;
    }

    private void installFailed(final LaunchDesc launchDesc, final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (n == -7) {
                    GeneralUtilities.showMessageDialog(null, Resources.getString("windowsInstall.invalidFilename", WinInstallHandler.this.getInstallName(launchDesc)), Resources.getString("windowsInstall.installFailedTitle"), 0);
                } else {
                    GeneralUtilities.showMessageDialog(null, Resources.getString("windowsInstall.installFailed", WinInstallHandler.this.getInstallName(launchDesc)), Resources.getString("windowsInstall.installFailedTitle"), 0);
                }
            }
        };
        this.invokeRunnable(runnable);
    }

    private void invokeRunnable(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private String getDesktopPath() {
        this.loadPathsIfNecessary();
        return this._desktopPath;
    }

    private String getStartMenuPath() {
        this.loadPathsIfNecessary();
        return this._startMenuPath;
    }

    private boolean uninstallShortcut(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    private void install(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        String string;
        int n;
        block8: {
            if (!this.hasValidTitle(launchDesc)) {
                if (Globals.TraceLocalAppInstall) {
                    Debug.println("No valid title for install, bailing!");
                }
                return;
            }
            if (this.isApplicationInstalled(launchDesc) && !this.shouldInstallOverExisting(launchDesc)) {
                return;
            }
            n = 0;
            try {
                string = localApplicationProperties.getIndirectLauchFilePath(true);
            }
            catch (IOException iOException) {
                string = null;
                if (!Globals.TraceLocalAppInstall) break block8;
                Debug.println("Couldn't determine path for install: " + iOException);
            }
        }
        if (string == null) {
            this.installFailed(launchDesc, n);
            return;
        }
        n = this.handleInstall(launchDesc, localApplicationProperties, string, 1);
        if (n != 0) {
            this.installFailed(launchDesc, n);
            return;
        }
        n = this.handleInstall(launchDesc, localApplicationProperties, string, 2);
        if (n != 0) {
            this.uninstall(launchDesc, localApplicationProperties, false);
            this.installFailed(launchDesc, n);
            return;
        }
        localApplicationProperties.setLocallyInstalled(true);
        this.save(localApplicationProperties);
    }

    public void uninstall(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        this.uninstall(launchDesc, localApplicationProperties, false);
    }

    private void uninstall(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
        if (localApplicationProperties == null) {
            if (Globals.TraceLocalAppInstall) {
                Debug.println("No LAP for uninstall, bailing!");
            }
            return;
        }
        boolean bl2 = false;
        String string = localApplicationProperties.get(INSTALLED_START_MENU_KEY);
        if (string != null) {
            if (!this.uninstallShortcut(string)) {
                bl2 = true;
            } else {
                localApplicationProperties.put(INSTALLED_START_MENU_KEY, null);
            }
        }
        if ((string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY)) != null) {
            if (!this.uninstallShortcut(string)) {
                bl2 = true;
            } else {
                localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, null);
            }
        }
        localApplicationProperties.setLocallyInstalled(false);
        this.save(localApplicationProperties);
        if (bl2 && bl) {
            this.uninstallFailed(launchDesc);
        }
    }

    private File saveICOfile(Image image) {
        FileOutputStream fileOutputStream = null;
        File file = null;
        try {
            file = File.createTempFile("javaws", ".ico");
            fileOutputStream = new FileOutputStream(file);
            IcoEncoder icoEncoder = new IcoEncoder(fileOutputStream, image);
            icoEncoder.encode();
            fileOutputStream.close();
            return file;
        }
        catch (Throwable throwable) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (file != null) {
                file.delete();
            }
            return null;
        }
    }

    private String getDesktopName(LaunchDesc launchDesc) {
        return Resources.getString("windowsInstall.desktopShortcutName", this.getInstallName(launchDesc));
    }

    private String getDesktopPath(LaunchDesc launchDesc) {
        String string = this.getDesktopPath();
        if (string != null) {
            String string2 = this.getDesktopName(launchDesc);
            if (string2 != null) {
                string = string + string2;
            }
            if (string.length() > 200) {
                string = string.substring(0, 200);
            }
            string = string + SHORTCUT_EXTENSION;
        }
        return string;
    }

    private String getIconPath(LaunchDesc launchDesc) {
        Object object;
        File file;
        block14: {
            if (Globals.TraceLocalAppInstall) {
                Debug.println("Getting icon path");
            }
            IconDesc iconDesc = launchDesc.getInformation().getIconLocation(1, 0);
            file = null;
            if (iconDesc != null) {
                try {
                    object = DownloadProtocol.getResource(iconDesc.getLocation(), iconDesc.getVersion(), 2, true, null);
                    File file2 = ((DiskCacheEntry)object).getMappedBitmap();
                    if (file2 == null || !file2.exists()) {
                        file2 = null;
                        Image image = CacheUtilities.getSharedInstance().loadImage(((DiskCacheEntry)object).getFile().getPath());
                        file = this.saveICOfile(image);
                        if (Globals.TraceLocalAppInstall) {
                            Debug.println("updating ICO: " + file);
                        }
                        if (file != null) {
                            file2 = InstallCache.getDiskCache().putMappedImage(iconDesc.getLocation(), iconDesc.getVersion(), file);
                            file = null;
                        }
                    }
                    if (file2 != null) {
                        return file2.getPath();
                    }
                }
                catch (IOException iOException) {
                    if (Globals.TraceLocalAppInstall) {
                        Debug.println("exception creating BMP: " + iOException);
                    }
                }
                catch (JNLPException jNLPException) {
                    if (!Globals.TraceLocalAppInstall) break block14;
                    Debug.println("exception creating BMP: " + jNLPException);
                }
            }
        }
        if (file != null) {
            file.delete();
        }
        StringBuffer stringBuffer = new StringBuffer();
        ConfigProperties.getInstance();
        object = stringBuffer.append(ConfigProperties.getApplicationHome()).append(File.separator).append("JavaCup.ico").toString();
        file = new File((String)object);
        if (file.exists()) {
            return file.getPath();
        }
        file = this.saveICOfile(Resources.getIcon("JavaCup.image").getImage());
        if (Globals.TraceIcoCreation) {
            Debug.println("default button ico path: " + file.getPath());
        }
        if (file != null) {
            return file.getPath();
        }
        return null;
    }

    private String getInstallName(LaunchDesc launchDesc) {
        return launchDesc.getInformation().getTitle();
    }

    private String getStartMenuName(LaunchDesc launchDesc) {
        return Resources.getString("windowsInstall.startMenuShortcutName", this.getInstallName(launchDesc));
    }

    private String getStartMenuPath(LaunchDesc launchDesc) {
        String string = this.getStartMenuPath();
        if (string != null) {
            String string2 = this.getStartMenuName(launchDesc);
            if (string2 != null) {
                string = string + string2;
            }
            if (string.length() > 200) {
                string = string.substring(0, 200);
            }
            string = string + SHORTCUT_EXTENSION;
        }
        return string;
    }

    public void install(Window window, LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        this.install(launchDesc, localApplicationProperties);
    }

    public void installIfNecessaryFromLaunch(Window window, LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        int n = ConfigProperties.getInstance().getWhenInstall();
        switch (n) {
            case 0: {
                return;
            }
            case 1: {
                this.install(window, launchDesc, localApplicationProperties);
                return;
            }
        }
        if (localApplicationProperties.getAskedForInstall()) {
            return;
        }
        int n2 = GeneralUtilities.showLocalInstallDialog(window, launchDesc.getInformation().getTitle());
        if (Globals.TraceLocalAppInstall) {
            Debug.println("showLocalInstallDialog returned: " + n2);
        }
        switch (n2) {
            case 1: {
                this.install(window, launchDesc, localApplicationProperties);
                localApplicationProperties.setAskedForInstall(true);
                break;
            }
            case 0: {
                localApplicationProperties.setAskedForInstall(true);
                break;
            }
            case 2: {
                localApplicationProperties.setAskedForInstall(false);
            }
        }
        this.save(localApplicationProperties);
    }

    private int handleInstall(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, String string, int n) {
        String string2;
        int n2;
        String string3;
        InformationDesc informationDesc = launchDesc.getInformation();
        String string4 = this.getIconPath(launchDesc);
        String string5 = this.getInstallName(launchDesc);
        String string6 = informationDesc.getDescription(1);
        string = "\"@" + string + "\"";
        if (n == 1) {
            string3 = this.getDesktopPath(launchDesc);
            string5 = this.getDesktopName(launchDesc);
            n2 = this.installShortcut(string3, string5, string6, ConfigProperties.getStartCommand(), string, null, string4);
            string2 = INSTALLED_DESKTOP_SHORTCUT_KEY;
        } else {
            string3 = this.getStartMenuPath(launchDesc);
            string5 = this.getStartMenuName(launchDesc);
            n2 = this.installShortcut(string3, string5, string6, ConfigProperties.getStartCommand(), string, null, string4);
            string2 = INSTALLED_START_MENU_KEY;
        }
        if (n2 == 0) {
            localApplicationProperties.put(string2, string3);
            if (Globals.TraceLocalAppInstall) {
                Debug.println("Installed desktop shortcut as: " + string5);
            }
        } else if (Globals.TraceLocalAppInstall) {
            Debug.println("Installed desktop shortcut failed!");
        }
        return n2;
    }

    private native int installShortcut(String var1, String var2, String var3, String var4, String var5, String var6, String var7);
}

