/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.Packet;
import java.io.IOException;

class SharedMemoryConnection
implements ConnectionService {
    private long id;
    private Object receiveLock = new Object();
    private Object sendLock = new Object();
    private volatile boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte receiveByte() throws IOException {
        Object object = this.receiveLock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Connection closed");
            }
            return this.receiveByte0(this.id);
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.close0(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendByte(byte by) throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Connection closed");
            }
            this.sendByte0(this.id, by);
        }
    }

    private native byte receiveByte0(long var1) throws IOException;

    SharedMemoryConnection(long l) throws IOException {
        this.id = l;
    }

    private native void close0(long var1);

    private native void sendByte0(long var1, byte var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet receivePacket() throws IOException {
        Object object = this.receiveLock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Connection closed");
            }
            Packet packet = new Packet();
            this.receivePacket0(this.id, packet);
            return packet;
        }
    }

    private native void receivePacket0(long var1, Packet var3) throws IOException;

    private native void sendPacket0(long var1, Packet var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Connection closed");
            }
            this.sendPacket0(this.id, packet);
        }
    }
}

