/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.text.MessageFormat;
import sun.security.action.GetPropertyAction;
import sun.security.provider.PolicyParser;
import sun.security.tools.CancelButtonListener;
import sun.security.tools.ErrorOKButtonListener;
import sun.security.tools.FileMenuListener;
import sun.security.tools.MainWindowListener;
import sun.security.tools.PolicyEntry;
import sun.security.tools.PolicyListListener;
import sun.security.tools.PolicyTool;
import sun.security.tools.StatusOKButtonListener;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindowListener;

class ToolWindow
extends Frame {
    private static final long serialVersionUID = 5682568601210376777L;
    public static final Insets TOP_PADDING = new Insets(25, 0, 0, 0);
    public static final Insets BOTTOM_PADDING = new Insets(0, 0, 25, 0);
    public static final Insets LITE_BOTTOM_PADDING = new Insets(0, 0, 10, 0);
    public static final Insets LR_PADDING = new Insets(0, 10, 0, 10);
    public static final String NEW_POLICY_FILE = PolicyTool.rb.getString("New");
    public static final String OPEN_POLICY_FILE = PolicyTool.rb.getString("Open");
    public static final String SAVE_POLICY_FILE = PolicyTool.rb.getString("Save");
    public static final String SAVE_AS_POLICY_FILE = PolicyTool.rb.getString("Save As");
    public static final String VIEW_WARNINGS = PolicyTool.rb.getString("View Warning Log");
    public static final String QUIT = PolicyTool.rb.getString("Exit");
    public static final String ADD_POLICY_ENTRY = PolicyTool.rb.getString("Add Policy Entry");
    public static final String EDIT_POLICY_ENTRY = PolicyTool.rb.getString("Edit Policy Entry");
    public static final String REMOVE_POLICY_ENTRY = PolicyTool.rb.getString("Remove Policy Entry");
    public static final String CHANGE_KEYSTORE = PolicyTool.rb.getString("Change KeyStore");
    public static final String ADD_PUBKEY_ALIAS = PolicyTool.rb.getString("Add Public Key Alias");
    public static final String REMOVE_PUBKEY_ALIAS = PolicyTool.rb.getString("Remove Public Key Alias");
    public static final int MW_FILENAME_LABEL = 0;
    public static final int MW_FILENAME_TEXTFIELD = 1;
    public static final int MW_KEYSTORE_LABEL = 2;
    public static final int MW_KEYSTORE_TEXTFIELD = 3;
    public static final int MW_PANEL = 4;
    public static final int MW_ADD_BUTTON = 0;
    public static final int MW_EDIT_BUTTON = 1;
    public static final int MW_REMOVE_BUTTON = 2;
    public static final int MW_POLICY_LIST = 5;
    private PolicyTool tool;

    private void initWindow() {
        Object object;
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu(PolicyTool.rb.getString("File"));
        menu.add(NEW_POLICY_FILE);
        menu.add(OPEN_POLICY_FILE);
        menu.add(SAVE_POLICY_FILE);
        menu.add(SAVE_AS_POLICY_FILE);
        menu.add(VIEW_WARNINGS);
        menu.add(QUIT);
        menu.addActionListener(new FileMenuListener(this.tool, this));
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        menu = new Menu(PolicyTool.rb.getString("Edit"));
        menu.add(ADD_POLICY_ENTRY);
        menu.add(EDIT_POLICY_ENTRY);
        menu.add(REMOVE_POLICY_ENTRY);
        menu.add(CHANGE_KEYSTORE);
        menu.addActionListener(new MainWindowListener(this.tool, this));
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        Label label = new Label(PolicyTool.rb.getString("Policy File:"));
        this.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, TOP_PADDING);
        TextField textField = new TextField(50);
        textField.setEditable(false);
        this.addNewComponent(this, textField, 1, 1, 0, 1, 1, 0.0, 0.0, 1, TOP_PADDING);
        label = new Label(PolicyTool.rb.getString("Keystore:"));
        this.addNewComponent(this, label, 2, 0, 1, 1, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        textField = new TextField(50);
        textField.setEditable(false);
        this.addNewComponent(this, textField, 3, 1, 1, 1, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Button button = new Button(ADD_POLICY_ENTRY);
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 0, 0, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        button = new Button(EDIT_POLICY_ENTRY);
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 1, 1, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        button = new Button(REMOVE_POLICY_ENTRY);
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 2, 2, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        this.addNewComponent(this, panel, 4, 0, 2, 2, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        String string = this.tool.getPolicyFileName();
        if (string == null) {
            object = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            string = (String)object + File.separatorChar + ".java.policy";
        }
        try {
            this.tool.openPolicy(string);
            object = new List(40, false);
            ((List)object).addActionListener(new PolicyListListener(this.tool, this));
            PolicyEntry[] policyEntryArray = this.tool.getEntry();
            if (policyEntryArray != null) {
                for (int i = 0; i < policyEntryArray.length; ++i) {
                    ((List)object).add(policyEntryArray[i].headerToString());
                }
            }
            TextField textField2 = (TextField)this.getComponent(1);
            textField2.setText(string);
            TextField textField3 = (TextField)this.getComponent(3);
            if (this.tool.getKeyStoreType() != null && this.tool.getKeyStoreType().length() > 0) {
                textField3.setText(this.tool.getKeyStoreName() + ", " + this.tool.getKeyStoreType());
            } else {
                textField3.setText(this.tool.getKeyStoreName());
            }
            this.initPolicyList((List)object);
        }
        catch (PolicyParser.ParsingException parsingException) {
            List list = new List(40, false);
            this.initPolicyList(list);
            this.setVisible(true);
            MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Error parsing policy file policyFile: pppe.getMessage()"));
            Object[] objectArray = new Object[]{string, parsingException.getMessage()};
            this.displayErrorDialog(null, messageFormat.format(objectArray));
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            List list = new List(40, false);
            list.addActionListener(new PolicyListListener(this.tool, this));
            this.initPolicyList(list);
            this.tool.modified = false;
            this.setVisible(true);
            this.displayErrorDialog(null, PolicyTool.rb.getString("Could not find Policy File: ") + string);
        }
        catch (Exception exception) {
            List list = new List(40, false);
            list.addActionListener(new PolicyListListener(this.tool, this));
            this.initPolicyList(list);
            this.tool.modified = false;
        }
    }

    void initPolicyList(List list) {
        this.addNewComponent(this, list, 5, 0, 3, 2, 1, 1.0, 1.0, 1);
    }

    void replacePolicyList(List list) {
        List list2 = (List)this.getComponent(5);
        list2.removeAll();
        String[] stringArray = list.getItems();
        for (int i = 0; i < stringArray.length; ++i) {
            list2.add(stringArray[i]);
        }
    }

    void displayWarningLog(Window window) {
        ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Warning"), this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        toolDialog.setBounds(point.x + 50, point.y + 50, 500, 100);
        toolDialog.setLayout(new GridBagLayout());
        TextArea textArea = new TextArea();
        textArea.setEditable(false);
        for (int i = 0; i < this.tool.warnings.size(); ++i) {
            textArea.append((String)this.tool.warnings.elementAt(i));
            textArea.append(PolicyTool.rb.getString("\n"));
        }
        this.addNewComponent(toolDialog, textArea, 0, 0, 0, 1, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        Button button = new Button(PolicyTool.rb.getString("OK"));
        button.addActionListener(new CancelButtonListener(toolDialog));
        this.addNewComponent(toolDialog, button, 1, 0, 1, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        toolDialog.pack();
        toolDialog.setVisible(true);
    }

    void displayToolWindow(String[] stringArray) {
        this.setTitle(PolicyTool.rb.getString("Policy Tool"));
        this.setResizable(true);
        this.addWindowListener(new ToolWindowListener(this));
        this.setBounds(135, 80, 500, 500);
        this.setLayout(new GridBagLayout());
        this.initWindow();
        this.setVisible(true);
        if (this.tool.newWarning) {
            this.displayStatusDialog(this, PolicyTool.rb.getString("Errors have occurred while opening the policy configuration.  View the Warning Log for more information."));
        }
    }

    ToolWindow(PolicyTool policyTool) {
        this.tool = policyTool;
    }

    void addNewComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6) {
        this.addNewComponent(container, component, n, n2, n3, n4, n5, d, d2, n6, null);
    }

    void displayErrorDialog(Window window, Exception exception) {
        this.displayErrorDialog(window, exception.toString());
    }

    void displayErrorDialog(Window window, String string) {
        ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Error"), this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        toolDialog.setBounds(point.x + 50, point.y + 50, 600, 100);
        toolDialog.setLayout(new GridBagLayout());
        Label label = new Label(string);
        this.addNewComponent(toolDialog, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        Button button = new Button(PolicyTool.rb.getString("OK"));
        button.addActionListener(new ErrorOKButtonListener(toolDialog));
        this.addNewComponent(toolDialog, button, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        toolDialog.pack();
        toolDialog.setVisible(true);
    }

    void displayStatusDialog(Window window, String string) {
        ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Status"), this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        toolDialog.setBounds(point.x + 50, point.y + 50, 500, 100);
        toolDialog.setLayout(new GridBagLayout());
        Label label = new Label(string);
        this.addNewComponent(toolDialog, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        Button button = new Button(PolicyTool.rb.getString("OK"));
        button.addActionListener(new StatusOKButtonListener(toolDialog));
        this.addNewComponent(toolDialog, button, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        toolDialog.pack();
        toolDialog.setVisible(true);
    }

    void addNewComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6, Insets insets) {
        container.add(component, n);
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.gridwidth = n4;
        gridBagConstraints.gridheight = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = n6;
        if (insets != null) {
            gridBagConstraints.insets = insets;
        }
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }
}

