/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import sun.applet.AppletClassLoader;
import sun.awt.AWTSecurityManager;
import sun.awt.AppContext;
import sun.security.util.SecurityConstants;

public class AppletSecurity
extends AWTSecurityManager {
    private AppContext mainAppContext;
    private static Field facc = null;
    private static Field fcontext = null;
    private HashSet restrictedPackages = new HashSet();
    private boolean inThreadGroupCheck = false;

    static {
        try {
            facc = URLClassLoader.class.getDeclaredField("acc");
            facc.setAccessible(true);
            fcontext = AccessControlContext.class.getDeclaredField("context");
            fcontext.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            unsupportedOperationException.initCause(noSuchFieldException);
            throw unsupportedOperationException;
        }
    }

    public AppletSecurity() {
        this.reset();
        this.mainAppContext = AppContext.getAppContext();
    }

    public void checkAwtEventQueueAccess() {
        AppContext appContext = AppContext.getAppContext();
        AppletClassLoader appletClassLoader = this.currentAppletClassLoader();
        if (appContext == this.mainAppContext && appletClassLoader != null) {
            super.checkAwtEventQueueAccess();
        }
    }

    public void reset() {
        this.restrictedPackages.clear();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Enumeration<?> enumeration = System.getProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)enumeration.nextElement();
                    if (string2 == null || !string2.startsWith("package.restrict.access.") || (string = System.getProperty(string2)) == null || !string.equalsIgnoreCase("true")) continue;
                    String string3 = string2.substring(24);
                    AppletSecurity.this.restrictedPackages.add(string3);
                }
                return null;
            }
        });
    }

    public void checkPackageAccess(String string) {
        super.checkPackageAccess(string);
        Iterator iterator = this.restrictedPackages.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2) && !string.startsWith(string2 + ".")) continue;
            this.checkPermission(new RuntimePermission("accessClassInPackage." + string));
        }
    }

    public synchronized void checkAccess(Thread thread) {
        if (!this.inThreadGroup(thread)) {
            this.checkPermission(SecurityConstants.MODIFY_THREAD_PERMISSION);
        }
    }

    protected boolean inThreadGroup(Thread thread) {
        return this.inThreadGroup(thread.getThreadGroup());
    }

    public ThreadGroup getThreadGroup() {
        ThreadGroup threadGroup;
        AppletClassLoader appletClassLoader = this.currentAppletClassLoader();
        ThreadGroup threadGroup2 = threadGroup = appletClassLoader == null ? null : appletClassLoader.getThreadGroup();
        if (threadGroup != null) {
            return threadGroup;
        }
        return super.getThreadGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAccess(ThreadGroup threadGroup) {
        if (this.inThreadGroupCheck) {
            this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        } else {
            try {
                this.inThreadGroupCheck = true;
                if (!this.inThreadGroup(threadGroup)) {
                    this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
                }
            }
            finally {
                this.inThreadGroupCheck = false;
            }
        }
    }

    protected boolean inThreadGroup(ThreadGroup threadGroup) {
        if (this.currentAppletClassLoader() == null) {
            return false;
        }
        return this.getThreadGroup().parentOf(threadGroup);
    }

    private AppletClassLoader currentAppletClassLoader() {
        int n;
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null || classLoader instanceof AppletClassLoader) {
            return (AppletClassLoader)classLoader;
        }
        Class[] classArray = this.getClassContext();
        for (n = 0; n < classArray.length; ++n) {
            classLoader = classArray[n].getClassLoader();
            if (!(classLoader instanceof AppletClassLoader)) continue;
            return (AppletClassLoader)classLoader;
        }
        for (n = 0; n < classArray.length; ++n) {
            final ClassLoader classLoader2 = classArray[n].getClassLoader();
            if (!(classLoader2 instanceof URLClassLoader) || (classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AccessControlContext accessControlContext = null;
                    ProtectionDomain[] protectionDomainArray = null;
                    try {
                        accessControlContext = (AccessControlContext)facc.get(classLoader2);
                        if (accessControlContext == null) {
                            return null;
                        }
                        protectionDomainArray = (ProtectionDomain[])fcontext.get(accessControlContext);
                        if (protectionDomainArray == null) {
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                        unsupportedOperationException.initCause(exception);
                        throw unsupportedOperationException;
                    }
                    for (int i = 0; i < protectionDomainArray.length; ++i) {
                        ClassLoader classLoader = protectionDomainArray[i].getClassLoader();
                        if (!(classLoader instanceof AppletClassLoader)) continue;
                        return classLoader;
                    }
                    return null;
                }
            })) == null) continue;
            return (AppletClassLoader)classLoader;
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof AppletClassLoader) {
            return (AppletClassLoader)classLoader;
        }
        return null;
    }

    public AppContext getAppContext() {
        AppletClassLoader appletClassLoader = this.currentAppletClassLoader();
        if (appletClassLoader == null) {
            return null;
        }
        AppContext appContext = appletClassLoader.getAppContext();
        if (appContext == null) {
            throw new SecurityException("Applet classloader has invalid AppContext");
        }
        return appContext;
    }
}

