/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Calendar;
import java.util.HashMap;
import sun.plugin.net.proxy.BrowserProxyInfo;
import sun.plugin.net.proxy.ProxyConfigException;
import sun.plugin.net.proxy.ProxyHandler;
import sun.plugin.net.proxy.ProxyInfo;
import sun.plugin.services.ServiceUnavailableException;
import sun.plugin.util.Trace;

final class SmartProxyHandler
implements ProxyHandler {
    private ProxyHandler realHandler = null;
    private HashMap proxyCache = new HashMap();
    private int pingTimeout;
    private long aliveTimeout;
    private long deadTimeout;

    public boolean isProxyCacheSupported() {
        return this.realHandler.isProxyCacheSupported();
    }

    public boolean isSupported(int n) {
        return this.realHandler.isSupported(n);
    }

    public void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        this.realHandler.init(browserProxyInfo);
    }

    public SmartProxyHandler(ProxyHandler proxyHandler) {
        this.proxyCache.put(new ProxyInfo(null, -1), new ProxyRecord(true, -1L));
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SmartProxyHandler.this.pingTimeout = Integer.getInteger("javaplugin.proxy.pingTimeout", 2000);
                SmartProxyHandler.this.aliveTimeout = Long.getLong("javaplugin.proxy.aliveTimeout", 1800000L);
                SmartProxyHandler.this.deadTimeout = Long.getLong("javaplugin.proxy.deadTimeout", 600000L);
                return null;
            }
        });
        this.realHandler = proxyHandler;
    }

    private boolean pingProxy(ProxyInfo proxyInfo) {
        String string = proxyInfo.getProxy();
        int n = -1;
        if (string != null) {
            n = proxyInfo.getPort();
        } else {
            string = proxyInfo.getSocksProxy();
            if (string != null) {
                n = proxyInfo.getSocksPort();
            } else {
                return true;
            }
        }
        final String string2 = string;
        final int n2 = n;
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Object[] objectArray = new Object[]{string2, new Integer(n2)};
                Socket socket = new Socket();
                Trace.msgNetPrintln("net.proxy.browser.smartConfig", objectArray);
                try {
                    socket.connect(new InetSocketAddress(string2, n2), SmartProxyHandler.this.pingTimeout);
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                catch (Exception exception) {
                    Trace.msgNetPrintln("net.proxy.browser.connectionException", objectArray);
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    public ProxyInfo[] getProxyInfo(URL uRL) throws ServiceUnavailableException {
        ProxyInfo[] proxyInfoArray = this.realHandler.getProxyInfo(uRL);
        for (int i = 0; i < proxyInfoArray.length; ++i) {
            String string = proxyInfoArray[i].toString();
            ProxyRecord proxyRecord = (ProxyRecord)this.proxyCache.get(string);
            if (proxyRecord == null) {
                ProxyRecord proxyRecord2 = new ProxyRecord(false, Calendar.getInstance().getTimeInMillis());
                this.proxyCache.put(string, proxyRecord2);
                if (!this.pingProxy(proxyInfoArray[i])) continue;
                proxyRecord2.setStatus(true);
                return new ProxyInfo[]{proxyInfoArray[i]};
            }
            long l = Calendar.getInstance().getTimeInMillis();
            boolean bl = proxyRecord.getStatus();
            long l2 = proxyRecord.getTimeStamp();
            if (l2 > 0L && (bl && l - l2 >= this.aliveTimeout || !bl && l - l2 >= this.deadTimeout)) {
                bl = this.pingProxy(proxyInfoArray[i]);
                proxyRecord.setTimeStamp(l);
                proxyRecord.setStatus(bl);
            }
            if (!bl) continue;
            return new ProxyInfo[]{proxyInfoArray[i]};
        }
        return new ProxyInfo[]{proxyInfoArray[0]};
    }

    private class ProxyRecord {
        private boolean isAlive = false;
        private long timeStamp = 0L;

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public boolean getStatus() {
            return this.isAlive;
        }

        public void setTimeStamp(long l) {
            this.timeStamp = l;
        }

        public void setStatus(boolean bl) {
            this.isAlive = bl;
        }

        public ProxyRecord(boolean bl, long l) {
            this.isAlive = bl;
            this.timeStamp = l;
        }
    }
}

