/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.DoubleValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveValueImpl;

public class DoubleValueImpl
extends PrimitiveValueImpl
implements DoubleValue {
    private double value;

    public byte byteValue() {
        return (byte)this.value;
    }

    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127.0 || this.value < -128.0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    byte typeValueKey() {
        return 68;
    }

    public char charValue() {
        return (char)this.value;
    }

    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535.0 || this.value < 0.0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    public double doubleValue() {
        return this.value;
    }

    public double value() {
        return this.value;
    }

    float checkedFloatValue() throws InvalidTypeException {
        float f = (float)this.value;
        if ((double)f != this.value) {
            throw new InvalidTypeException("Can't convert " + this.value + " to float");
        }
        return super.checkedFloatValue();
    }

    public float floatValue() {
        return (float)this.value;
    }

    int checkedIntValue() throws InvalidTypeException {
        if (this.value > 2.147483647E9 || this.value < -2.147483648E9) {
            throw new InvalidTypeException("Can't convert " + this.value + " to int");
        }
        return super.checkedIntValue();
    }

    public int hashCode() {
        return this.intValue();
    }

    public int intValue() {
        return (int)this.value;
    }

    long checkedLongValue() throws InvalidTypeException {
        long l = (long)this.value;
        if ((double)l != this.value) {
            throw new InvalidTypeException("Can't convert " + this.value + " to long");
        }
        return super.checkedLongValue();
    }

    public long longValue() {
        return (long)this.value;
    }

    short checkedShortValue() throws InvalidTypeException {
        if (this.value > 32767.0 || this.value < -32768.0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    public short shortValue() {
        return (short)this.value;
    }

    public boolean booleanValue() {
        return this.value != 0.0;
    }

    public Type type() {
        return this.vm.theDoubleType();
    }

    DoubleValueImpl(VirtualMachine virtualMachine, double d) {
        super(virtualMachine);
        this.value = d;
    }

    public int compareTo(Object object) {
        double d = ((DoubleValue)object).value();
        if (this.value() < d) {
            return -1;
        }
        if (this.value() == d) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleValue) {
            return this.value == ((DoubleValue)object).value() && super.equals(object);
        }
        return false;
    }

    public String toString() {
        return "" + this.value;
    }
}

