/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.Bidi;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.Utilities;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import sun.awt.font.BidiUtils;

public abstract class AbstractDocument
implements Document,
Serializable {
    private transient int numReaders;
    private transient Thread currWriter;
    private transient int numWriters;
    private transient boolean notifyingListeners;
    private static Boolean defaultI18NProperty;
    private Dictionary documentProperties = null;
    protected EventListenerList listenerList = new EventListenerList();
    private Content data;
    private AttributeContext context;
    private transient BranchElement bidiRoot;
    private DocumentFilter documentFilter;
    private transient DocumentFilter.FilterBypass filterBypass;
    private static final String BAD_LOCK_STATE = "document lock failure";
    protected static final String BAD_LOCATION = "document location failure";
    public static final String ParagraphElementName = "paragraph";
    public static final String ContentElementName = "content";
    public static final String SectionElementName = "section";
    public static final String BidiElementName = "bidi level";
    public static final String ElementNameAttribute = "$ename";
    static final String I18NProperty = "i18n";
    static final Object MultiByteProperty;
    static final String AsyncLoadPriority = "load priority";

    public int getAsynchronousLoadPriority() {
        Integer n2 = (Integer)this.getProperty(AsyncLoadPriority);
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    public int getLength() {
        return this.data.length() - 1;
    }

    static {
        MultiByteProperty = "multiByte";
    }

    public final synchronized void readLock() {
        try {
            while (this.currWriter != null) {
                if (this.currWriter == Thread.currentThread()) {
                    return;
                }
                this.wait();
            }
            ++this.numReaders;
        }
        catch (InterruptedException interruptedException) {
            throw new Error("Interrupted attempt to aquire read lock");
        }
    }

    public final synchronized void readUnlock() {
        if (this.currWriter == Thread.currentThread()) {
            return;
        }
        if (this.numReaders <= 0) {
            throw new StateInvariantError(BAD_LOCK_STATE);
        }
        --this.numReaders;
        this.notify();
    }

    protected final synchronized void writeLock() {
        try {
            while (this.numReaders > 0 || this.currWriter != null) {
                if (Thread.currentThread() == this.currWriter) {
                    if (this.notifyingListeners) {
                        throw new IllegalStateException("Attempt to mutate in notification");
                    }
                    ++this.numWriters;
                    return;
                }
                this.wait();
            }
            this.currWriter = Thread.currentThread();
            this.numWriters = 1;
        }
        catch (InterruptedException interruptedException) {
            throw new Error("Interrupted attempt to aquire write lock");
        }
    }

    protected final synchronized void writeUnlock() {
        if (--this.numWriters <= 0) {
            this.numWriters = 0;
            this.currWriter = null;
            this.notifyAll();
        }
    }

    private static final boolean isComplex(char c2) {
        return c2 >= '\u0900' && c2 <= '\u0d7f' || c2 >= '\u0e00' && c2 <= '\u0e7f';
    }

    public void setAsynchronousLoadPriority(int n2) {
        Integer n3 = n2 >= 0 ? new Integer(n2) : null;
        this.putProperty(AsyncLoadPriority, n3);
    }

    void handleRemove(int n2, int n3) throws BadLocationException {
        if (n3 > 0) {
            if (n2 < 0 || n2 + n3 > this.getLength()) {
                throw new BadLocationException("Invalid remove", this.getLength() + 1);
            }
            DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(n2, n3, DocumentEvent.EventType.REMOVE);
            boolean bl2 = false;
            bl2 = Utilities.isComposedTextElement(this, n2);
            this.removeUpdate(defaultDocumentEvent);
            UndoableEdit undoableEdit = this.data.remove(n2, n3);
            if (undoableEdit != null) {
                defaultDocumentEvent.addEdit(undoableEdit);
            }
            this.postRemoveUpdate(defaultDocumentEvent);
            defaultDocumentEvent.end();
            this.fireRemoveUpdate(defaultDocumentEvent);
            if (undoableEdit != null && !bl2) {
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n2, int n3) throws BadLocationException {
        DocumentFilter documentFilter = this.getDocumentFilter();
        this.writeLock();
        try {
            if (documentFilter != null) {
                documentFilter.remove(this.getFilterBypass(), n2, n3);
            } else {
                this.handleRemove(n2, n3);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    boolean isLeftToRight(int n2, int n3) {
        int n4;
        if (!this.getProperty(I18NProperty).equals(Boolean.TRUE)) {
            return true;
        }
        Element element = this.getBidiRootElement();
        Element element2 = element.getElement(n4 = element.getElementIndex(n2));
        if (element2.getEndOffset() >= n3) {
            AttributeSet attributeSet = element2.getAttributes();
            return StyleConstants.getBidiLevel(attributeSet) % 2 == 0;
        }
        return true;
    }

    private byte[] calculateBidiLevels(int n2, int n3) {
        byte[] byArray = new byte[n3 - n2];
        int n4 = 0;
        Boolean bl2 = null;
        Object object = this.getProperty(TextAttribute.RUN_DIRECTION);
        if (object instanceof Boolean) {
            bl2 = (Boolean)object;
        }
        int n5 = n2;
        while (n5 < n3) {
            String string;
            Element element = this.getParagraphElement(n5);
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset();
            Boolean bl3 = bl2;
            object = element.getAttributes().getAttribute(TextAttribute.RUN_DIRECTION);
            if (object instanceof Boolean) {
                bl3 = (Boolean)object;
            }
            try {
                string = this.getText(n6, n7 - n6);
            }
            catch (BadLocationException badLocationException) {
                throw new Error("Internal error: " + badLocationException.toString());
            }
            int n8 = -2;
            if (bl3 != null) {
                n8 = TextAttribute.RUN_DIRECTION_LTR.equals(bl3) ? 0 : 1;
            }
            Bidi bidi = new Bidi(string, n8);
            BidiUtils.getLevels(bidi, byArray, n4);
            n4 += bidi.getLength();
            n5 = element.getEndOffset();
        }
        if (n4 != byArray.length) {
            throw new Error("levelsEnd assertion failed.");
        }
        return byArray;
    }

    private static final boolean isComplex(char[] cArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!AbstractDocument.isComplex(cArray[i2])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.bidiRoot = new BidiRootElement();
        try {
            this.writeLock();
            Element[] elementArray = new Element[]{new BidiElement((Element)this.bidiRoot, 0, 1, 0)};
            this.bidiRoot.replace(0, 0, elementArray);
        }
        finally {
            this.writeUnlock();
        }
        objectInputStream.registerValidation(new ObjectInputValidation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void validateObject() {
                try {
                    AbstractDocument.this.writeLock();
                    DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(0, AbstractDocument.this.getLength(), DocumentEvent.EventType.INSERT);
                    AbstractDocument.this.updateBidi(defaultDocumentEvent);
                }
                finally {
                    AbstractDocument.this.writeUnlock();
                }
            }
        }, 0);
    }

    public void dump(PrintStream printStream) {
        Element element = this.getDefaultRootElement();
        if (element instanceof AbstractElement) {
            ((AbstractElement)element).dump(printStream, 0);
        }
        this.bidiRoot.dump(printStream, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Runnable runnable) {
        this.readLock();
        try {
            runnable.run();
        }
        finally {
            this.readUnlock();
        }
    }

    public String getText(int n2, int n3) throws BadLocationException {
        if (n3 < 0) {
            throw new BadLocationException("Length must be positive", n3);
        }
        String string = this.data.getString(n2, n3);
        return string;
    }

    protected final synchronized Thread getCurrentWriter() {
        return this.currWriter;
    }

    public Dictionary getDocumentProperties() {
        if (this.documentProperties == null) {
            this.documentProperties = new Hashtable(2);
        }
        return this.documentProperties;
    }

    public void setDocumentProperties(Dictionary dictionary) {
        this.documentProperties = dictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        this.notifyingListeners = true;
        try {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
                if (objectArray[i2] != (class$javax$swing$event$DocumentListener == null ? AbstractDocument.class$("javax.swing.event.DocumentListener") : class$javax$swing$event$DocumentListener)) continue;
                ((DocumentListener)objectArray[i2 + 1]).changedUpdate(documentEvent);
            }
        }
        finally {
            this.notifyingListeners = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        this.notifyingListeners = true;
        try {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
                if (objectArray[i2] != (class$javax$swing$event$DocumentListener == null ? AbstractDocument.class$("javax.swing.event.DocumentListener") : class$javax$swing$event$DocumentListener)) continue;
                ((DocumentListener)objectArray[i2 + 1]).insertUpdate(documentEvent);
            }
        }
        finally {
            this.notifyingListeners = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        this.notifyingListeners = true;
        try {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
                if (objectArray[i2] != (class$javax$swing$event$DocumentListener == null ? AbstractDocument.class$("javax.swing.event.DocumentListener") : class$javax$swing$event$DocumentListener)) continue;
                ((DocumentListener)objectArray[i2 + 1]).removeUpdate(documentEvent);
            }
        }
        finally {
            this.notifyingListeners = false;
        }
    }

    public DocumentListener[] getDocumentListeners() {
        return (DocumentListener[])this.listenerList.getListeners(DocumentListener.class);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.listenerList.add(DocumentListener.class, documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listenerList.remove(DocumentListener.class, documentListener);
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$UndoableEditListener == null ? AbstractDocument.class$("javax.swing.event.UndoableEditListener") : class$javax$swing$event$UndoableEditListener)) continue;
            ((UndoableEditListener)objectArray[i2 + 1]).undoableEditHappened(undoableEditEvent);
        }
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        return (UndoableEditListener[])this.listenerList.getListeners(UndoableEditListener.class);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.remove(UndoableEditListener.class, undoableEditListener);
    }

    protected final AttributeContext getAttributeContext() {
        return this.context;
    }

    protected final Content getContent() {
        return this.data;
    }

    protected AbstractDocument(Content content) {
        this(content, StyleContext.getDefaultStyleContext());
    }

    protected void postRemoveUpdate(DefaultDocumentEvent defaultDocumentEvent) {
        if (this.getProperty(I18NProperty).equals(Boolean.TRUE)) {
            this.updateBidi(defaultDocumentEvent);
        }
    }

    protected void removeUpdate(DefaultDocumentEvent defaultDocumentEvent) {
    }

    void updateBidi(DefaultDocumentEvent defaultDocumentEvent) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (defaultDocumentEvent.type == DocumentEvent.EventType.INSERT || defaultDocumentEvent.type == DocumentEvent.EventType.CHANGE) {
            int n7 = defaultDocumentEvent.getOffset();
            int n8 = n7 + defaultDocumentEvent.getLength();
            n6 = this.getParagraphElement(n7).getStartOffset();
            n5 = this.getParagraphElement(n8).getEndOffset();
        } else if (defaultDocumentEvent.type == DocumentEvent.EventType.REMOVE) {
            Element element = this.getParagraphElement(defaultDocumentEvent.getOffset());
            n6 = element.getStartOffset();
            n5 = element.getEndOffset();
        } else {
            throw new Error("Internal error: unknown event type.");
        }
        byte[] byArray = this.calculateBidiLevels(n6, n5);
        Vector vector = new Vector();
        int n9 = n6;
        int n10 = 0;
        if (n9 > 0) {
            n10 = n4 = this.bidiRoot.getElementIndex(n6 - 1);
            Element element = this.bidiRoot.getElement(n4);
            int n11 = StyleConstants.getBidiLevel(element.getAttributes());
            if (n11 == byArray[0]) {
                n9 = element.getStartOffset();
            } else if (element.getEndOffset() > n6) {
                vector.addElement(new BidiElement((Element)this.bidiRoot, element.getStartOffset(), n6, n11));
            } else {
                ++n10;
            }
        }
        for (n4 = 0; n4 < byArray.length && byArray[n4] == byArray[0]; ++n4) {
        }
        int n12 = n5;
        BidiElement bidiElement = null;
        int n13 = this.bidiRoot.getElementCount() - 1;
        if (n12 <= this.getLength()) {
            n13 = n3 = this.bidiRoot.getElementIndex(n5);
            Element element = this.bidiRoot.getElement(n3);
            n2 = StyleConstants.getBidiLevel(element.getAttributes());
            if (n2 == byArray[byArray.length - 1]) {
                n12 = element.getEndOffset();
            } else if (element.getStartOffset() < n5) {
                bidiElement = new BidiElement((Element)this.bidiRoot, n5, element.getEndOffset(), n2);
            } else {
                --n13;
            }
        }
        for (n3 = byArray.length; n3 > n4 && byArray[n3 - 1] == byArray[byArray.length - 1]; --n3) {
        }
        if (n4 == n3 && byArray[0] == byArray[byArray.length - 1]) {
            vector.addElement(new BidiElement((Element)this.bidiRoot, n9, n12, (int)byArray[0]));
        } else {
            vector.addElement(new BidiElement((Element)this.bidiRoot, n9, n4 + n6, (int)byArray[0]));
            int n14 = n4;
            while (n14 < n3) {
                for (n2 = n14; n2 < byArray.length && byArray[n2] == byArray[n14]; ++n2) {
                }
                vector.addElement(new BidiElement((Element)this.bidiRoot, n6 + n14, n6 + n2, (int)byArray[n14]));
                n14 = n2;
            }
            vector.addElement(new BidiElement((Element)this.bidiRoot, n3 + n6, n12, (int)byArray[byArray.length - 1]));
        }
        if (bidiElement != null) {
            vector.addElement(bidiElement);
        }
        int n15 = 0;
        if (this.bidiRoot.getElementCount() > 0) {
            n15 = n13 - n10 + 1;
        }
        Element[] elementArray = new Element[n15];
        for (int i2 = 0; i2 < n15; ++i2) {
            elementArray[i2] = this.bidiRoot.getElement(n10 + i2);
        }
        Object[] objectArray = new Element[vector.size()];
        vector.copyInto(objectArray);
        ElementEdit elementEdit = new ElementEdit(this.bidiRoot, n10, elementArray, (Element[])objectArray);
        defaultDocumentEvent.addEdit(elementEdit);
        this.bidiRoot.replace(n10, elementArray.length, (Element[])objectArray);
    }

    public DocumentFilter getDocumentFilter() {
        return this.documentFilter;
    }

    public void setDocumentFilter(DocumentFilter documentFilter) {
        this.documentFilter = documentFilter;
    }

    private DocumentFilter.FilterBypass getFilterBypass() {
        if (this.filterBypass == null) {
            this.filterBypass = new DefaultFilterBypass();
        }
        return this.filterBypass;
    }

    public Element getBidiRootElement() {
        return this.bidiRoot;
    }

    public abstract Element getDefaultRootElement();

    public Element[] getRootElements() {
        Element[] elementArray = new Element[]{this.getDefaultRootElement(), this.getBidiRootElement()};
        return elementArray;
    }

    public abstract Element getParagraphElement(int var1);

    public final Position getEndPosition() {
        Position position;
        try {
            position = this.createPosition(this.data.length());
        }
        catch (BadLocationException badLocationException) {
            position = null;
        }
        return position;
    }

    public final Position getStartPosition() {
        Position position;
        try {
            position = this.createPosition(0);
        }
        catch (BadLocationException badLocationException) {
            position = null;
        }
        return position;
    }

    public synchronized Position createPosition(int n2) throws BadLocationException {
        return this.data.createPosition(n2);
    }

    public void getText(int n2, int n3, Segment segment) throws BadLocationException {
        if (n3 < 0) {
            throw new BadLocationException("Length must be positive", n3);
        }
        this.data.getChars(n2, n3, segment);
    }

    public final Object getProperty(Object object) {
        return this.getDocumentProperties().get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putProperty(Object object, Object object2) {
        if (object2 != null) {
            this.getDocumentProperties().put(object, object2);
        } else {
            this.getDocumentProperties().remove(object);
        }
        if (object == TextAttribute.RUN_DIRECTION && Boolean.TRUE.equals(this.getProperty(I18NProperty))) {
            this.writeLock();
            try {
                DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(0, this.getLength(), DocumentEvent.EventType.INSERT);
                this.updateBidi(defaultDocumentEvent);
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractDocument(Content content, AttributeContext attributeContext) {
        Element[] elementArray;
        this.data = content;
        this.context = attributeContext;
        this.bidiRoot = new BidiRootElement();
        if (defaultI18NProperty == null) {
            elementArray = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(AbstractDocument.I18NProperty);
                }
            });
            defaultI18NProperty = elementArray != null ? Boolean.valueOf((String)elementArray) : Boolean.FALSE;
        }
        this.putProperty(I18NProperty, defaultI18NProperty);
        this.writeLock();
        try {
            elementArray = new Element[]{new BidiElement((Element)this.bidiRoot, 0, 1, 0)};
            this.bidiRoot.replace(0, 0, elementArray);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
        if (n3 == 0 && (string == null || string.length() == 0)) {
            return;
        }
        DocumentFilter documentFilter = this.getDocumentFilter();
        this.writeLock();
        try {
            if (documentFilter != null) {
                documentFilter.replace(this.getFilterBypass(), n2, n3, string, attributeSet);
            } else {
                if (n3 > 0) {
                    this.remove(n2, n3);
                }
                if (string != null && string.length() > 0) {
                    this.insertString(n2, string, attributeSet);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    void handleInsertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || string.length() == 0) {
            return;
        }
        UndoableEdit undoableEdit = this.data.insertString(n2, string);
        DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(n2, string.length(), DocumentEvent.EventType.INSERT);
        if (undoableEdit != null) {
            defaultDocumentEvent.addEdit(undoableEdit);
        }
        if (this.getProperty(I18NProperty).equals(Boolean.FALSE)) {
            Object object = this.getProperty(TextAttribute.RUN_DIRECTION);
            if (object != null && object.equals(TextAttribute.RUN_DIRECTION_RTL)) {
                this.putProperty(I18NProperty, Boolean.TRUE);
            } else {
                char[] cArray = string.toCharArray();
                if (Bidi.requiresBidi(cArray, 0, cArray.length) || AbstractDocument.isComplex(cArray, 0, cArray.length)) {
                    this.putProperty(I18NProperty, Boolean.TRUE);
                }
            }
        }
        this.insertUpdate(defaultDocumentEvent, attributeSet);
        defaultDocumentEvent.end();
        this.fireInsertUpdate(defaultDocumentEvent);
        if (!(undoableEdit == null || attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute))) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || string.length() == 0) {
            return;
        }
        DocumentFilter documentFilter = this.getDocumentFilter();
        this.writeLock();
        try {
            if (documentFilter != null) {
                documentFilter.insertString(this.getFilterBypass(), n2, string, attributeSet);
            } else {
                this.handleInsertString(n2, string, attributeSet);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void insertUpdate(DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        if (this.getProperty(I18NProperty).equals(Boolean.TRUE)) {
            this.updateBidi(defaultDocumentEvent);
        }
        if (defaultDocumentEvent.type == DocumentEvent.EventType.INSERT && defaultDocumentEvent.getLength() > 0 && !Boolean.TRUE.equals(this.getProperty(MultiByteProperty))) {
            Segment segment = SegmentCache.getSharedSegment();
            try {
                this.getText(defaultDocumentEvent.getOffset(), defaultDocumentEvent.getLength(), segment);
                segment.first();
                do {
                    if (segment.current() <= '\u00ff') continue;
                    this.putProperty(MultiByteProperty, Boolean.TRUE);
                    break;
                } while (segment.next() != '\uffff');
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            SegmentCache.releaseSharedSegment(segment);
        }
    }

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BranchElement(element, attributeSet);
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n2, int n3) {
        return new LeafElement(element, attributeSet, n2, n3);
    }

    public abstract class AbstractElement
    implements Element,
    MutableAttributeSet,
    Serializable,
    TreeNode {
        private Element parent;
        private transient AttributeSet attributes;

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public int getChildCount() {
            return this.getElementCount();
        }

        public abstract int getElementCount();

        public abstract int getEndOffset();

        public abstract int getStartOffset();

        private final void checkForIllegalCast() {
            Thread thread = AbstractDocument.this.getCurrentWriter();
            if (thread == null || thread != Thread.currentThread()) {
                throw new StateInvariantError("Illegal cast to MutableAttributeSet");
            }
        }

        public abstract boolean getAllowsChildren();

        public abstract boolean isLeaf();

        public abstract int getElementIndex(int var1);

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleContext.readAttributeSet(objectInputStream, simpleAttributeSet);
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.addAttributes(SimpleAttributeSet.EMPTY, simpleAttributeSet);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            StyleContext.writeAttributeSet(objectOutputStream, this.attributes);
        }

        public void dump(PrintStream printStream, int n2) {
            Object object;
            Object object2;
            PrintWriter printWriter;
            try {
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)printStream, "JavaEsc"), true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                printWriter = new PrintWriter(printStream, true);
            }
            this.indent(printWriter, n2);
            if (this.getName() == null) {
                printWriter.print("<??");
            } else {
                printWriter.print("<" + this.getName());
            }
            if (this.getAttributeCount() > 0) {
                printWriter.println("");
                object2 = this.attributes.getAttributeNames();
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    this.indent(printWriter, n2 + 1);
                    printWriter.println(object + "=" + this.getAttribute(object));
                }
                this.indent(printWriter, n2);
            }
            printWriter.println(">");
            if (this.isLeaf()) {
                this.indent(printWriter, n2 + 1);
                printWriter.print("[" + this.getStartOffset() + "," + this.getEndOffset() + "]");
                object2 = AbstractDocument.this.getContent();
                try {
                    object = object2.getString(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
                    if (((String)object).length() > 40) {
                        object = ((String)object).substring(0, 40) + "...";
                    }
                    printWriter.println("[" + (String)object + "]");
                }
                catch (BadLocationException badLocationException) {}
            } else {
                int n3 = this.getElementCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    AbstractElement abstractElement = (AbstractElement)this.getElement(i2);
                    abstractElement.dump(printStream, n2 + 1);
                }
            }
        }

        private final void indent(PrintWriter printWriter, int n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                printWriter.print("  ");
            }
        }

        public void removeAttribute(Object object) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.removeAttribute(this.attributes, object);
        }

        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        public String getName() {
            if (this.attributes.isDefined(AbstractDocument.ElementNameAttribute)) {
                return (String)this.attributes.getAttribute(AbstractDocument.ElementNameAttribute);
            }
            return null;
        }

        public abstract Enumeration children();

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public void removeAttributes(Enumeration enumeration) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.removeAttributes(this.attributes, enumeration);
        }

        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        public AttributeSet getAttributes() {
            return this;
        }

        public AttributeSet getResolveParent() {
            AttributeSet attributeSet = this.attributes.getResolveParent();
            if (attributeSet == null && this.parent != null) {
                attributeSet = this.parent.getAttributes();
            }
            return attributeSet;
        }

        public void addAttributes(AttributeSet attributeSet) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.addAttributes(this.attributes, attributeSet);
        }

        public void removeAttributes(AttributeSet attributeSet) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeSet == this ? attributeContext.getEmptySet() : attributeContext.removeAttributes(this.attributes, attributeSet);
        }

        public void setResolveParent(AttributeSet attributeSet) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeSet != null ? attributeContext.addAttribute(this.attributes, StyleConstants.ResolveAttribute, attributeSet) : attributeContext.removeAttribute(this.attributes, StyleConstants.ResolveAttribute);
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public Element getParentElement() {
            return this.parent;
        }

        public abstract Element getElement(int var1);

        public TreeNode getParent() {
            return (TreeNode)((Object)this.getParentElement());
        }

        public TreeNode getChildAt(int n2) {
            return (TreeNode)((Object)this.getElement(n2));
        }

        public int getIndex(TreeNode treeNode) {
            for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                if (this.getChildAt(i2) != treeNode) continue;
                return i2;
            }
            return -1;
        }

        public Object getAttribute(Object object) {
            Object object2 = this.attributes.getAttribute(object);
            if (object2 == null) {
                AttributeSet attributeSet;
                AttributeSet attributeSet2 = attributeSet = this.parent != null ? this.parent.getAttributes() : null;
                if (attributeSet != null) {
                    object2 = attributeSet.getAttribute(object);
                }
            }
            return object2;
        }

        public void addAttribute(Object object, Object object2) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.addAttribute(this.attributes, object, object2);
        }

        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        public AbstractElement(Element element, AttributeSet attributeSet) {
            this.parent = element;
            this.attributes = AbstractDocument.this.getAttributeContext().getEmptySet();
            if (attributeSet != null) {
                this.addAttributes(attributeSet);
            }
        }
    }

    public static interface AttributeContext {
        public AttributeSet getEmptySet();

        public void reclaim(AttributeSet var1);

        public AttributeSet removeAttribute(AttributeSet var1, Object var2);

        public AttributeSet removeAttributes(AttributeSet var1, Enumeration var2);

        public AttributeSet addAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet removeAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet addAttribute(AttributeSet var1, Object var2, Object var3);
    }

    class BidiElement
    extends LeafElement {
        int getLevel() {
            Integer n2 = (Integer)this.getAttribute(StyleConstants.BidiLevel);
            if (n2 != null) {
                return n2;
            }
            return 0;
        }

        boolean isLeftToRight() {
            return this.getLevel() % 2 == 0;
        }

        public String getName() {
            return AbstractDocument.BidiElementName;
        }

        BidiElement(Element element, int n2, int n3, int n4) {
            super(element, new SimpleAttributeSet(), n2, n3);
            this.addAttribute(StyleConstants.BidiLevel, new Integer(n4));
        }
    }

    class BidiRootElement
    extends BranchElement {
        public String getName() {
            return "bidi root";
        }

        BidiRootElement() {
            super(null, null);
        }
    }

    public class BranchElement
    extends AbstractElement {
        private AbstractElement[] children;
        private int nchildren;
        private int lastIndex;

        public int getElementCount() {
            return this.nchildren;
        }

        public int getEndOffset() {
            AbstractElement abstractElement = this.children[this.nchildren - 1];
            return abstractElement.getEndOffset();
        }

        public int getStartOffset() {
            return this.children[0].getStartOffset();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            return false;
        }

        public int getElementIndex(int n2) {
            int n3;
            AbstractElement abstractElement;
            int n4 = 0;
            int n5 = this.nchildren - 1;
            int n6 = 0;
            int n7 = this.getStartOffset();
            if (this.nchildren == 0) {
                return 0;
            }
            if (n2 >= this.getEndOffset()) {
                return this.nchildren - 1;
            }
            if (this.lastIndex >= n4 && this.lastIndex <= n5) {
                abstractElement = this.children[this.lastIndex];
                n7 = abstractElement.getStartOffset();
                n3 = abstractElement.getEndOffset();
                if (n2 >= n7 && n2 < n3) {
                    return this.lastIndex;
                }
                if (n2 < n7) {
                    n5 = this.lastIndex;
                } else {
                    n4 = this.lastIndex;
                }
            }
            while (n4 <= n5) {
                n6 = n4 + (n5 - n4) / 2;
                abstractElement = this.children[n6];
                n7 = abstractElement.getStartOffset();
                n3 = abstractElement.getEndOffset();
                if (n2 >= n7 && n2 < n3) {
                    int n8;
                    this.lastIndex = n8 = n6;
                    return n8;
                }
                if (n2 < n7) {
                    n5 = n6 - 1;
                    continue;
                }
                n4 = n6 + 1;
            }
            int n9 = n2 < n7 ? n6 : n6 + 1;
            this.lastIndex = n9;
            return n9;
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                string = AbstractDocument.ParagraphElementName;
            }
            return string;
        }

        public String toString() {
            return "BranchElement(" + this.getName() + ") " + this.getStartOffset() + "," + this.getEndOffset() + "\n";
        }

        public Enumeration children() {
            if (this.nchildren == 0) {
                return null;
            }
            Vector vector = new Vector(this.nchildren);
            for (int i2 = 0; i2 < this.nchildren; ++i2) {
                vector.addElement(this.children[i2]);
            }
            return vector.elements();
        }

        public Element getElement(int n2) {
            if (n2 < this.nchildren) {
                return this.children[n2];
            }
            return null;
        }

        public Element positionToElement(int n2) {
            int n3 = this.getElementIndex(n2);
            AbstractElement abstractElement = this.children[n3];
            int n4 = abstractElement.getStartOffset();
            int n5 = abstractElement.getEndOffset();
            if (n2 >= n4 && n2 < n5) {
                return abstractElement;
            }
            return null;
        }

        public void replace(int n2, int n3, Element[] elementArray) {
            int n4 = elementArray.length - n3;
            int n5 = n2 + n3;
            int n6 = this.nchildren - n5;
            int n7 = n5 + n4;
            if (this.nchildren + n4 >= this.children.length) {
                int n8 = Math.max(2 * this.children.length, this.nchildren + n4);
                AbstractElement[] abstractElementArray = new AbstractElement[n8];
                System.arraycopy(this.children, 0, abstractElementArray, 0, n2);
                System.arraycopy(elementArray, 0, abstractElementArray, n2, elementArray.length);
                System.arraycopy(this.children, n5, abstractElementArray, n7, n6);
                this.children = abstractElementArray;
            } else {
                System.arraycopy(this.children, n5, this.children, n7, n6);
                System.arraycopy(elementArray, 0, this.children, n2, elementArray.length);
            }
            this.nchildren += n4;
        }

        public BranchElement(Element element, AttributeSet attributeSet) {
            super(element, attributeSet);
            this.children = new AbstractElement[1];
            this.nchildren = 0;
            this.lastIndex = -1;
        }
    }

    public static interface Content {
        public int length();

        public String getString(int var1, int var2) throws BadLocationException;

        public Position createPosition(int var1) throws BadLocationException;

        public void getChars(int var1, int var2, Segment var3) throws BadLocationException;

        public UndoableEdit remove(int var1, int var2) throws BadLocationException;

        public UndoableEdit insertString(int var1, String var2) throws BadLocationException;
    }

    public class DefaultDocumentEvent
    extends CompoundEdit
    implements DocumentEvent {
        private int offset;
        private int length;
        private Hashtable changeLookup;
        private DocumentEvent.EventType type;

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void redo() throws CannotRedoException {
            AbstractDocument.this.writeLock();
            try {
                super.redo();
                if (this.type == DocumentEvent.EventType.INSERT) {
                    AbstractDocument.this.fireInsertUpdate(this);
                } else if (this.type == DocumentEvent.EventType.REMOVE) {
                    AbstractDocument.this.fireRemoveUpdate(this);
                } else {
                    AbstractDocument.this.fireChangedUpdate(this);
                }
            }
            finally {
                AbstractDocument.this.writeUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undo() throws CannotUndoException {
            AbstractDocument.this.writeLock();
            try {
                super.undo();
                if (this.type == DocumentEvent.EventType.REMOVE) {
                    AbstractDocument.this.fireInsertUpdate(this);
                } else if (this.type == DocumentEvent.EventType.INSERT) {
                    AbstractDocument.this.fireRemoveUpdate(this);
                } else {
                    AbstractDocument.this.fireChangedUpdate(this);
                }
            }
            finally {
                AbstractDocument.this.writeUnlock();
            }
        }

        public boolean isSignificant() {
            return true;
        }

        public String getPresentationName() {
            DocumentEvent.EventType eventType = this.getType();
            if (eventType == DocumentEvent.EventType.INSERT) {
                return UIManager.getString("AbstractDocument.additionText");
            }
            if (eventType == DocumentEvent.EventType.REMOVE) {
                return UIManager.getString("AbstractDocument.deletionText");
            }
            return UIManager.getString("AbstractDocument.styleChangeText");
        }

        public String getRedoPresentationName() {
            return UIManager.getString("AbstractDocument.redoText") + " " + this.getPresentationName();
        }

        public String getUndoPresentationName() {
            return UIManager.getString("AbstractDocument.undoText") + " " + this.getPresentationName();
        }

        public String toString() {
            return this.edits.toString();
        }

        public DocumentEvent.EventType getType() {
            return this.type;
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (this.changeLookup == null && this.edits.size() > 10) {
                this.changeLookup = new Hashtable();
                int n2 = this.edits.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object = this.edits.elementAt(i2);
                    if (!(object instanceof DocumentEvent.ElementChange)) continue;
                    DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)object;
                    this.changeLookup.put(elementChange.getElement(), elementChange);
                }
            }
            if (this.changeLookup != null && undoableEdit instanceof DocumentEvent.ElementChange) {
                DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)((Object)undoableEdit);
                this.changeLookup.put(elementChange.getElement(), elementChange);
            }
            return super.addEdit(undoableEdit);
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            if (this.changeLookup != null) {
                return (DocumentEvent.ElementChange)this.changeLookup.get(element);
            }
            int n2 = this.edits.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                DocumentEvent.ElementChange elementChange;
                Object object = this.edits.elementAt(i2);
                if (!(object instanceof DocumentEvent.ElementChange) || (elementChange = (DocumentEvent.ElementChange)object).getElement() != element) continue;
                return elementChange;
            }
            return null;
        }

        public DefaultDocumentEvent(int n2, int n3, DocumentEvent.EventType eventType) {
            this.offset = n2;
            this.length = n3;
            this.type = eventType;
        }
    }

    private class DefaultFilterBypass
    extends DocumentFilter.FilterBypass {
        public void remove(int n2, int n3) throws BadLocationException {
            AbstractDocument.this.handleRemove(n2, n3);
        }

        private DefaultFilterBypass() {
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public void replace(int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
            AbstractDocument.this.handleRemove(n2, n3);
            AbstractDocument.this.handleInsertString(n2, string, attributeSet);
        }

        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            AbstractDocument.this.handleInsertString(n2, string, attributeSet);
        }
    }

    public static class ElementEdit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        private Element e;
        private int index;
        private Element[] removed;
        private Element[] added;

        public int getIndex() {
            return this.index;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Element[] elementArray = this.removed;
            this.removed = this.added;
            this.added = elementArray;
            ((BranchElement)this.e).replace(this.index, this.removed.length, this.added);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            ((BranchElement)this.e).replace(this.index, this.added.length, this.removed);
            Element[] elementArray = this.removed;
            this.removed = this.added;
            this.added = elementArray;
        }

        public Element getElement() {
            return this.e;
        }

        public Element[] getChildrenAdded() {
            return this.added;
        }

        public Element[] getChildrenRemoved() {
            return this.removed;
        }

        public ElementEdit(Element element, int n2, Element[] elementArray, Element[] elementArray2) {
            this.e = element;
            this.index = n2;
            this.removed = elementArray;
            this.added = elementArray2;
        }
    }

    public class LeafElement
    extends AbstractElement {
        private transient Position p0;
        private transient Position p1;

        public int getElementCount() {
            return 0;
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public boolean isLeaf() {
            return true;
        }

        public int getElementIndex(int n2) {
            return -1;
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            int n2 = objectInputStream.readInt();
            int n3 = objectInputStream.readInt();
            try {
                this.p0 = AbstractDocument.this.createPosition(n2);
                this.p1 = AbstractDocument.this.createPosition(n3);
            }
            catch (BadLocationException badLocationException) {
                this.p0 = null;
                this.p1 = null;
                throw new IOException("Can't restore Position references");
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeInt(this.p0.getOffset());
            objectOutputStream.writeInt(this.p1.getOffset());
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                string = AbstractDocument.ContentElementName;
            }
            return string;
        }

        public String toString() {
            return "LeafElement(" + this.getName() + ") " + this.p0 + "," + this.p1 + "\n";
        }

        public Enumeration children() {
            return null;
        }

        public Element getElement(int n2) {
            return null;
        }

        public LeafElement(Element element, AttributeSet attributeSet, int n2, int n3) {
            super(element, attributeSet);
            try {
                this.p0 = AbstractDocument.this.createPosition(n2);
                this.p1 = AbstractDocument.this.createPosition(n3);
            }
            catch (BadLocationException badLocationException) {
                this.p0 = null;
                this.p1 = null;
                throw new StateInvariantError("Can't create Position references");
            }
        }
    }
}

