/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.BreakIterator;
import java.text.CharSet;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import sun.text.CompactByteArray;

class RuleBasedBreakIterator
extends BreakIterator {
    protected static final byte IGNORE = -1;
    private static final short START_STATE = 1;
    private static final short STOP_STATE = 0;
    private String description;
    private CompactByteArray charCategoryTable = null;
    private short[] stateTable = null;
    private short[] backwardsStateTable = null;
    private boolean[] endStates = null;
    private boolean[] lookaheadStates = null;
    private int numCategories;
    private CharacterIterator text = null;

    public int current() {
        return this.getText().getIndex();
    }

    public int first() {
        CharacterIterator characterIterator = this.getText();
        characterIterator.first();
        return characterIterator.getIndex();
    }

    protected int handleNext() {
        CharacterIterator characterIterator = this.getText();
        if (characterIterator.getIndex() == characterIterator.getEndIndex()) {
            return -1;
        }
        int n2 = characterIterator.getIndex() + 1;
        int n3 = 0;
        int n4 = 1;
        char c2 = characterIterator.current();
        while (c2 != '\uffff' && n4 != 0) {
            int n5 = this.lookupCategory(c2);
            if (n5 != -1) {
                n4 = this.lookupState(n4, n5);
            }
            if (this.lookaheadStates[n4]) {
                if (this.endStates[n4]) {
                    n2 = n3;
                } else {
                    n3 = characterIterator.getIndex() + 1;
                }
            } else if (this.endStates[n4]) {
                n2 = characterIterator.getIndex() + 1;
            }
            c2 = characterIterator.next();
        }
        if (c2 == '\uffff' && n3 == characterIterator.getEndIndex()) {
            n2 = n3;
        }
        characterIterator.setIndex(n2);
        return n2;
    }

    protected int handlePrevious() {
        CharacterIterator characterIterator = this.getText();
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        char c2 = characterIterator.current();
        while (c2 != '\uffff' && n2 != 0) {
            n4 = n3;
            n3 = this.lookupCategory(c2);
            if (n3 != -1) {
                n2 = this.lookupBackwardState(n2, n3);
            }
            c2 = characterIterator.previous();
        }
        if (c2 != '\uffff') {
            if (n4 != -1) {
                characterIterator.setIndex(characterIterator.getIndex() + 2);
            } else {
                characterIterator.next();
            }
        }
        return characterIterator.getIndex();
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    public int last() {
        CharacterIterator characterIterator = this.getText();
        characterIterator.setIndex(characterIterator.getEndIndex());
        return characterIterator.getIndex();
    }

    public int next() {
        return this.handleNext();
    }

    public int previous() {
        int n2;
        CharacterIterator characterIterator = this.getText();
        if (this.current() == characterIterator.getBeginIndex()) {
            return -1;
        }
        int n3 = this.current();
        characterIterator.previous();
        int n4 = n2 = this.handlePrevious();
        while (n4 != -1 && n4 < n3) {
            n2 = n4;
            n4 = this.handleNext();
        }
        characterIterator.setIndex(n2);
        return n2;
    }

    protected int lookupCategory(char c2) {
        return this.charCategoryTable.elementAt(c2);
    }

    public int following(int n2) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n2, characterIterator);
        characterIterator.setIndex(n2);
        if (n2 == characterIterator.getBeginIndex()) {
            return this.handleNext();
        }
        int n3 = this.handlePrevious();
        while (n3 != -1 && n3 <= n2) {
            n3 = this.handleNext();
        }
        return n3;
    }

    public int next(int n2) {
        int n3 = this.current();
        while (n2 > 0) {
            n3 = this.handleNext();
            --n2;
        }
        while (n2 < 0) {
            n3 = this.previous();
            ++n2;
        }
        return n3;
    }

    public int preceding(int n2) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n2, characterIterator);
        characterIterator.setIndex(n2);
        return this.previous();
    }

    public boolean isBoundary(int n2) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n2, characterIterator);
        if (n2 == characterIterator.getBeginIndex()) {
            return true;
        }
        return this.following(n2 - 1) == n2;
    }

    protected int lookupBackwardState(int n2, int n3) {
        return this.backwardsStateTable[n2 * this.numCategories + n3];
    }

    protected int lookupState(int n2, int n3) {
        return this.stateTable[n2 * this.numCategories + n3];
    }

    public Object clone() {
        RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)super.clone();
        if (this.text != null) {
            ruleBasedBreakIterator.text = (CharacterIterator)this.text.clone();
        }
        return ruleBasedBreakIterator;
    }

    public boolean equals(Object object) {
        try {
            RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)object;
            if (!this.description.equals(ruleBasedBreakIterator.description)) {
                return false;
            }
            if (this.text == null) {
                return ruleBasedBreakIterator.text == null;
            }
            return this.text.equals(ruleBasedBreakIterator.text);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return this.description;
    }

    public RuleBasedBreakIterator(String string) {
        this.description = string;
        Builder builder = this.makeBuilder();
        builder.buildBreakIterator();
    }

    public CharacterIterator getText() {
        if (this.text == null) {
            this.text = new StringCharacterIterator("");
        }
        return this.text;
    }

    protected static final void checkOffset(int n2, CharacterIterator characterIterator) {
        if (n2 < characterIterator.getBeginIndex() || n2 >= characterIterator.getEndIndex()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
    }

    public void setText(CharacterIterator characterIterator) {
        boolean bl2;
        int n2 = characterIterator.getEndIndex();
        try {
            characterIterator.setIndex(n2);
            bl2 = characterIterator.getIndex() == n2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl2 = false;
        }
        this.text = bl2 ? characterIterator : new SafeCharIterator(characterIterator);
        this.text.first();
    }

    static /* synthetic */ short[] access$502(RuleBasedBreakIterator ruleBasedBreakIterator, short[] sArray) {
        ruleBasedBreakIterator.stateTable = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$602(RuleBasedBreakIterator ruleBasedBreakIterator, short[] sArray) {
        ruleBasedBreakIterator.backwardsStateTable = sArray;
        return sArray;
    }

    static /* synthetic */ boolean[] access$302(RuleBasedBreakIterator ruleBasedBreakIterator, boolean[] blArray) {
        ruleBasedBreakIterator.endStates = blArray;
        return blArray;
    }

    static /* synthetic */ boolean[] access$402(RuleBasedBreakIterator ruleBasedBreakIterator, boolean[] blArray) {
        ruleBasedBreakIterator.lookaheadStates = blArray;
        return blArray;
    }

    protected Builder makeBuilder() {
        return new Builder();
    }

    protected class Builder {
        protected Vector categories = null;
        protected Hashtable expressions = null;
        protected CharSet ignoreChars = null;
        protected Vector tempStateTable = null;
        protected Vector decisionPointList = null;
        protected Stack decisionPointStack = null;
        protected Vector loopingStates = null;
        protected Vector statesToBackfill = null;
        protected Vector mergeList = null;
        protected boolean clearLoopingStates = false;
        protected static final int END_STATE_FLAG = 32768;
        protected static final int DONT_LOOP_FLAG = 16384;
        protected static final int LOOKAHEAD_STATE_FLAG = 8192;
        protected static final int ALL_FLAGS = 57344;

        private void backfillLoopingStates() {
            short[] sArray = null;
            int n2 = 0;
            for (int i2 = 0; i2 < this.tempStateTable.size(); ++i2) {
                short[] sArray2 = (short[])this.tempStateTable.elementAt(i2);
                int n3 = sArray2[RuleBasedBreakIterator.this.numCategories] & 0xFFFF1FFF;
                if (n3 <= 0) continue;
                if (n3 != n2) {
                    n2 = n3;
                    sArray = (short[])this.tempStateTable.elementAt(n2);
                }
                int n4 = RuleBasedBreakIterator.this.numCategories;
                sArray2[n4] = (short)(sArray2[n4] & 0xE000);
                for (int i3 = 0; i3 < sArray2.length; ++i3) {
                    if (sArray2[i3] == 0) {
                        sArray2[i3] = sArray[i3];
                        continue;
                    }
                    if (sArray2[i3] != 16384) continue;
                    sArray2[i3] = 0;
                }
            }
        }

        public void buildBreakIterator() {
            Vector vector = this.buildRuleList(RuleBasedBreakIterator.this.description);
            this.buildCharCategories(vector);
            this.buildStateTable(vector);
            this.buildBackwardsStateTable(vector);
        }

        private void eliminateBackfillStates(int n2) {
            if (this.statesToBackfill.contains(new Integer(n2))) {
                this.statesToBackfill.removeElement(new Integer(n2));
                short[] sArray = (short[])this.tempStateTable.elementAt(n2);
                for (int i2 = 0; i2 < RuleBasedBreakIterator.this.numCategories; ++i2) {
                    if (sArray[i2] == 0) continue;
                    this.eliminateBackfillStates(sArray[i2]);
                }
            }
        }

        private int searchMergeList(int n2, int n3) {
            if (this.mergeList == null) {
                return 0;
            }
            for (int i2 = 0; i2 < this.mergeList.size(); ++i2) {
                int[] nArray = (int[])this.mergeList.elementAt(i2);
                if (nArray[0] == n2 && nArray[1] == n3 || nArray[0] == n3 && nArray[1] == n2) {
                    return nArray[2];
                }
                if (nArray[2] == n2 && (nArray[0] == n3 || nArray[1] == n3)) {
                    return nArray[2];
                }
                if (nArray[2] != n3 || nArray[0] != n2 && nArray[1] != n2) continue;
                return nArray[2];
            }
            return 0;
        }

        private void finishBuildingStateTable(boolean bl2) {
            int n2;
            int n3;
            short[] sArray;
            int n4;
            this.backfillLoopingStates();
            int[] nArray = new int[this.tempStateTable.size()];
            Stack stack = new Stack();
            stack.push(new Integer(1));
            nArray[1] = 1;
            while (stack.size() != 0) {
                int n5 = (Integer)stack.pop();
                short[] sArray2 = (short[])this.tempStateTable.elementAt(n5);
                for (int i2 = 0; i2 < RuleBasedBreakIterator.this.numCategories; ++i2) {
                    if (sArray2[i2] == 0 || nArray[sArray2[i2]] != 0) continue;
                    nArray[sArray2[i2]] = sArray2[i2];
                    stack.push(new Integer(sArray2[i2]));
                }
            }
            int[] nArray2 = new int[this.tempStateTable.size()];
            int n6 = RuleBasedBreakIterator.this.numCategories + 1;
            for (n4 = 1; n4 < nArray2.length; ++n4) {
                if (nArray[n4] == 0) continue;
                sArray = (short[])this.tempStateTable.elementAt(n4);
                for (n3 = 0; n3 < RuleBasedBreakIterator.this.numCategories; ++n3) {
                    if (sArray[n3] == 0) continue;
                    int n7 = n4;
                    nArray2[n7] = nArray2[n7] + 1;
                }
                if (nArray2[n4] != 0) continue;
                nArray2[n4] = n6;
            }
            ++n6;
            do {
                n3 = n6;
                for (n4 = 1; n4 < n6; ++n4) {
                    boolean bl3 = false;
                    short[] sArray3 = null;
                    sArray = null;
                    block6: for (int i3 = 0; i3 < nArray2.length; ++i3) {
                        if (nArray2[i3] != n4) continue;
                        if (sArray == null) {
                            sArray = (short[])this.tempStateTable.elementAt(i3);
                            continue;
                        }
                        sArray3 = (short[])this.tempStateTable.elementAt(i3);
                        for (n2 = 0; n2 < sArray3.length; ++n2) {
                            if ((n2 != RuleBasedBreakIterator.this.numCategories || sArray[n2] == sArray3[n2] || !bl2) && (n2 == RuleBasedBreakIterator.this.numCategories || nArray2[sArray[n2]] == nArray2[sArray3[n2]])) continue;
                            nArray2[i3] = n6;
                            bl3 = true;
                            continue block6;
                        }
                    }
                    if (!bl3) continue;
                    ++n6;
                }
            } while (n3 != n6);
            int[] nArray3 = new int[n6];
            for (n2 = 1; n2 < nArray2.length; ++n2) {
                if (nArray3[nArray2[n2]] == 0) {
                    nArray3[nArray2[n2]] = n2;
                    continue;
                }
                nArray[n2] = nArray3[nArray2[n2]];
            }
            for (n2 = 1; n2 < nArray.length; ++n2) {
                if (nArray[n2] == n2) continue;
                this.tempStateTable.setElementAt(null, n2);
            }
            int n8 = 1;
            for (n2 = 1; n2 < nArray.length; ++n2) {
                if (this.tempStateTable.elementAt(n2) == null) continue;
                nArray[n2] = n8++;
            }
            for (n2 = 1; n2 < nArray.length; ++n2) {
                if (this.tempStateTable.elementAt(n2) != null) continue;
                nArray[n2] = nArray[nArray[n2]];
            }
            if (bl2) {
                RuleBasedBreakIterator.access$302(RuleBasedBreakIterator.this, new boolean[n8]);
                RuleBasedBreakIterator.access$402(RuleBasedBreakIterator.this, new boolean[n8]);
                RuleBasedBreakIterator.access$502(RuleBasedBreakIterator.this, new short[n8 * RuleBasedBreakIterator.this.numCategories]);
                n2 = 0;
                int n9 = 0;
                for (int i4 = 0; i4 < this.tempStateTable.size(); ++i4) {
                    short[] sArray4 = (short[])this.tempStateTable.elementAt(i4);
                    if (sArray4 == null) continue;
                    for (int i5 = 0; i5 < RuleBasedBreakIterator.this.numCategories; ++i5) {
                        ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).stateTable[n2] = (short)nArray[sArray4[i5]];
                        ++n2;
                    }
                    ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).endStates[n9] = (sArray4[RuleBasedBreakIterator.this.numCategories] & 0x8000) != 0;
                    ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).lookaheadStates[n9] = (sArray4[RuleBasedBreakIterator.this.numCategories] & 0x2000) != 0;
                    ++n9;
                }
            } else {
                RuleBasedBreakIterator.access$602(RuleBasedBreakIterator.this, new short[n8 * RuleBasedBreakIterator.this.numCategories]);
                n2 = 0;
                for (int i6 = 0; i6 < this.tempStateTable.size(); ++i6) {
                    short[] sArray5 = (short[])this.tempStateTable.elementAt(i6);
                    if (sArray5 == null) continue;
                    for (int i7 = 0; i7 < RuleBasedBreakIterator.this.numCategories; ++i7) {
                        ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).backwardsStateTable[n2] = (short)nArray[sArray5[i7]];
                        ++n2;
                    }
                }
            }
        }

        private void parseRule(String string, boolean bl2) {
            short[] sArray;
            int n2;
            int n3;
            int n4 = 0;
            int n5 = n3 = 1;
            String string2 = "";
            this.decisionPointStack = new Stack();
            this.decisionPointList = new Vector();
            this.loopingStates = new Vector();
            this.statesToBackfill = new Vector();
            boolean bl3 = false;
            if (!bl2) {
                this.loopingStates.addElement(new Integer(1));
            }
            this.decisionPointList.addElement(new Integer(n3));
            n3 = this.tempStateTable.size() - 1;
            while (n4 < string.length()) {
                int n6;
                n2 = string.charAt(n4);
                this.clearLoopingStates = false;
                if (n2 == 91 || n2 == 92 || Character.isLetter((char)n2) || Character.isDigit((char)n2) || n2 < 32 || n2 == 46 || n2 >= 127) {
                    int n7;
                    if (n2 != 46) {
                        n7 = n4;
                        if (n2 == 92) {
                            n7 = n4 + 2;
                            ++n4;
                        } else if (n2 == 91) {
                            int n8 = 1;
                            while (n8 > 0) {
                                if ((n2 = string.charAt(++n7)) == 91) {
                                    ++n8;
                                    continue;
                                }
                                if (n2 == 93) {
                                    --n8;
                                    continue;
                                }
                                if (n2 != 92) continue;
                                ++n7;
                            }
                            ++n7;
                        } else {
                            n7 = n4 + 1;
                        }
                        string2 = (String)this.expressions.get(string.substring(n4, n7));
                        n4 = n7 - 1;
                    } else {
                        n7 = (Integer)this.decisionPointList.lastElement();
                        sArray = (short[])this.tempStateTable.elementAt(n7);
                        if (n4 + 1 < string.length() && string.charAt(n4 + 1) == '*' && sArray[0] != 0) {
                            this.decisionPointList.addElement(new Integer(sArray[0]));
                            string2 = "";
                            ++n4;
                        } else {
                            StringBuffer stringBuffer = new StringBuffer();
                            for (n6 = 0; n6 < RuleBasedBreakIterator.this.numCategories; ++n6) {
                                stringBuffer.append((char)(n6 + 256));
                            }
                            string2 = stringBuffer.toString();
                        }
                    }
                    if (string2.length() != 0) {
                        if (n4 + 1 < string.length() && string.charAt(n4 + 1) == '*') {
                            this.decisionPointStack.push(this.decisionPointList.clone());
                        }
                        n7 = this.tempStateTable.size();
                        if (this.loopingStates.size() != 0) {
                            this.statesToBackfill.addElement(new Integer(n7));
                        }
                        sArray = new short[RuleBasedBreakIterator.this.numCategories + 1];
                        if (bl3) {
                            sArray[((RuleBasedBreakIterator)RuleBasedBreakIterator.this).numCategories] = 16384;
                        }
                        this.tempStateTable.addElement(sArray);
                        this.updateStateTable(this.decisionPointList, string2, (short)n7);
                        this.decisionPointList.removeAllElements();
                        n5 = n3;
                        do {
                            this.decisionPointList.addElement(new Integer(++n3));
                        } while (n3 + 1 < this.tempStateTable.size());
                    }
                } else if (n2 == 123) {
                    this.decisionPointStack.push(this.decisionPointList.clone());
                } else if (n2 == 125 || n2 == 42) {
                    if (n2 == 42) {
                        for (int i2 = n5 + 1; i2 < this.tempStateTable.size(); ++i2) {
                            Vector vector = new Vector();
                            vector.addElement(new Integer(i2));
                            this.updateStateTable(vector, string2, (short)(n5 + 1));
                        }
                    }
                    Vector vector = (Vector)this.decisionPointStack.pop();
                    for (int i3 = 0; i3 < this.decisionPointList.size(); ++i3) {
                        vector.addElement(this.decisionPointList.elementAt(i3));
                    }
                    this.decisionPointList = vector;
                } else if (n2 == 63) {
                    this.setLoopingStates(this.decisionPointList, this.decisionPointList);
                } else if (n2 == 40) {
                    this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
                    n5 = n3++;
                    this.decisionPointList.insertElementAt(new Integer(n3), 0);
                    this.decisionPointStack.push(this.decisionPointList.clone());
                    this.decisionPointStack.push(new Vector());
                } else if (n2 == 124) {
                    Vector vector = (Vector)this.decisionPointStack.pop();
                    Vector vector2 = (Vector)this.decisionPointStack.peek();
                    this.decisionPointStack.push(vector);
                    for (n6 = 0; n6 < this.decisionPointList.size(); ++n6) {
                        vector.addElement(this.decisionPointList.elementAt(n6));
                    }
                    this.decisionPointList = (Vector)vector2.clone();
                } else if (n2 == 41) {
                    Vector vector = (Vector)this.decisionPointStack.pop();
                    for (int i4 = 0; i4 < this.decisionPointList.size(); ++i4) {
                        vector.addElement(this.decisionPointList.elementAt(i4));
                    }
                    this.decisionPointList = vector;
                    if (n4 + 1 >= string.length() || string.charAt(n4 + 1) != '*') {
                        this.decisionPointStack.pop();
                    } else {
                        int n9;
                        vector = (Vector)this.decisionPointList.clone();
                        Vector vector3 = (Vector)this.decisionPointStack.pop();
                        n6 = (Integer)vector3.firstElement();
                        short[] sArray2 = (short[])this.tempStateTable.elementAt(n6);
                        for (n9 = 0; n9 < this.decisionPointList.size(); ++n9) {
                            vector3.addElement(this.decisionPointList.elementAt(n9));
                        }
                        this.decisionPointList = vector3;
                        for (n9 = 0; n9 < sArray2.length; ++n9) {
                            if (sArray2[n9] <= n6) continue;
                            this.updateStateTable(vector, new Character((char)(n9 + 256)).toString(), sArray2[n9]);
                        }
                        n5 = n3;
                        n3 = this.tempStateTable.size() - 1;
                        ++n4;
                    }
                } else if (n2 == 47) {
                    bl3 = true;
                    for (int i5 = 0; i5 < this.decisionPointList.size(); ++i5) {
                        sArray = (short[])this.tempStateTable.elementAt((Integer)this.decisionPointList.elementAt(i5));
                        int n10 = RuleBasedBreakIterator.this.numCategories;
                        sArray[n10] = (short)(sArray[n10] | 0x2000);
                    }
                }
                if (this.clearLoopingStates) {
                    this.setLoopingStates(null, this.decisionPointList);
                }
                ++n4;
            }
            this.setLoopingStates(null, this.decisionPointList);
            for (n2 = 0; n2 < this.decisionPointList.size(); ++n2) {
                int n11 = (Integer)this.decisionPointList.elementAt(n2);
                sArray = (short[])this.tempStateTable.elementAt(n11);
                int n12 = RuleBasedBreakIterator.this.numCategories;
                sArray[n12] = (short)(sArray[n12] | 0x8000);
                if (!bl3) continue;
                int n13 = RuleBasedBreakIterator.this.numCategories;
                sArray[n13] = (short)(sArray[n13] | 0x2000);
            }
        }

        protected void mungeExpressionList(Hashtable hashtable) {
        }

        private void mergeStates(int n2, short[] sArray, Vector vector) {
            short[] sArray2 = (short[])this.tempStateTable.elementAt(n2);
            boolean bl2 = this.loopingStates.contains(new Integer(n2));
            for (int i2 = 0; i2 < sArray2.length; ++i2) {
                if (sArray2[i2] == sArray[i2]) continue;
                if (bl2 && this.loopingStates.contains(new Integer(sArray2[i2]))) {
                    if (sArray[i2] == 0) continue;
                    if (sArray2[i2] == 0) {
                        this.clearLoopingStates = true;
                    }
                    sArray2[i2] = sArray[i2];
                    continue;
                }
                if (sArray2[i2] == 0) {
                    sArray2[i2] = sArray[i2];
                    continue;
                }
                if (i2 == RuleBasedBreakIterator.this.numCategories) {
                    sArray2[i2] = (short)(sArray[i2] & 0xE000 | sArray2[i2]);
                    continue;
                }
                if (sArray2[i2] == 0 || sArray[i2] == 0) continue;
                int n3 = this.searchMergeList(sArray2[i2], sArray[i2]);
                if (n3 != 0) {
                    sArray2[i2] = (short)n3;
                    continue;
                }
                int n4 = sArray2[i2];
                int n5 = sArray[i2];
                n3 = this.tempStateTable.size();
                if (this.mergeList == null) {
                    this.mergeList = new Vector();
                }
                this.mergeList.addElement(new int[]{n4, n5, n3});
                short[] sArray3 = new short[RuleBasedBreakIterator.this.numCategories + 1];
                short[] sArray4 = (short[])this.tempStateTable.elementAt(n4);
                System.arraycopy(sArray4, 0, sArray3, 0, RuleBasedBreakIterator.this.numCategories + 1);
                this.tempStateTable.addElement(sArray3);
                sArray2[i2] = (short)n3;
                if ((this.decisionPointList.contains(new Integer(n4)) || this.decisionPointList.contains(new Integer(n5))) && !this.decisionPointList.contains(new Integer(n3))) {
                    this.decisionPointList.addElement(new Integer(n3));
                }
                if ((vector.contains(new Integer(n4)) || vector.contains(new Integer(n5))) && !vector.contains(new Integer(n3))) {
                    this.decisionPointList.addElement(new Integer(n3));
                }
                for (int i3 = 0; i3 < this.decisionPointStack.size(); ++i3) {
                    Vector vector2 = (Vector)this.decisionPointStack.elementAt(i3);
                    if (!vector2.contains(new Integer(n4)) && !vector2.contains(new Integer(n5)) || vector2.contains(new Integer(n3))) continue;
                    vector2.addElement(new Integer(n3));
                }
                this.mergeStates(n3, (short[])this.tempStateTable.elementAt(sArray[i2]), vector);
            }
        }

        private void buildBackwardsStateTable(Vector vector) {
            int n2;
            int n3;
            int n4;
            int n5;
            this.tempStateTable = new Vector();
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            for (n5 = 0; n5 < vector.size(); ++n5) {
                String string = (String)vector.elementAt(n5);
                if (string.charAt(0) != '!') continue;
                this.parseRule(string.substring(1), false);
            }
            this.backfillLoopingStates();
            n5 = this.tempStateTable.size();
            if (n5 > 2) {
                ++n5;
            }
            for (int i2 = 0; i2 < RuleBasedBreakIterator.this.numCategories + 1; ++i2) {
                this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            }
            short[] sArray = (short[])this.tempStateTable.elementAt(n5 - 1);
            for (n4 = 0; n4 < RuleBasedBreakIterator.this.numCategories; ++n4) {
                sArray[n4] = (short)(n4 + n5);
            }
            n4 = RuleBasedBreakIterator.this.stateTable.length / RuleBasedBreakIterator.this.numCategories;
            for (n3 = 0; n3 < RuleBasedBreakIterator.this.numCategories; ++n3) {
                for (int i3 = 0; i3 < n4; ++i3) {
                    n2 = RuleBasedBreakIterator.this.lookupState(i3, n3);
                    if (n2 == 0) continue;
                    for (int i4 = 0; i4 < RuleBasedBreakIterator.this.numCategories; ++i4) {
                        int n6 = RuleBasedBreakIterator.this.lookupState(n2, i4);
                        if (n6 == 0) continue;
                        sArray = (short[])this.tempStateTable.elementAt(i4 + n5);
                        sArray[n3] = (short)(n3 + n5);
                    }
                }
            }
            if (n5 > 1) {
                sArray = (short[])this.tempStateTable.elementAt(1);
                for (n3 = n5 - 1; n3 < this.tempStateTable.size(); ++n3) {
                    short[] sArray2 = (short[])this.tempStateTable.elementAt(n3);
                    for (n2 = 0; n2 < RuleBasedBreakIterator.this.numCategories; ++n2) {
                        if (sArray[n2] == 0 || sArray2[n2] == 0) continue;
                        sArray2[n2] = sArray[n2];
                    }
                }
                sArray = (short[])this.tempStateTable.elementAt(n5 - 1);
                for (n3 = 1; n3 < n5 - 1; ++n3) {
                    short[] sArray3 = (short[])this.tempStateTable.elementAt(n3);
                    if ((sArray3[RuleBasedBreakIterator.this.numCategories] & 0x8000) != 0) continue;
                    for (n2 = 0; n2 < RuleBasedBreakIterator.this.numCategories; ++n2) {
                        if (sArray3[n2] != 0) continue;
                        sArray3[n2] = sArray[n2];
                    }
                }
            }
            this.finishBuildingStateTable(false);
        }

        protected void buildCharCategories(Vector vector) {
            Object object;
            CharSet charSet;
            Object object2;
            int n2;
            Object object3;
            int n3 = 0;
            int n4 = 0;
            this.expressions = new Hashtable();
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                object3 = (String)vector.elementAt(i2);
                block11: for (n4 = 0; n4 < ((String)object3).length(); ++n4) {
                    char c2 = ((String)object3).charAt(n4);
                    switch (c2) {
                        case '!': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '.': 
                        case '/': 
                        case ';': 
                        case '?': 
                        case '{': 
                        case '|': 
                        case '}': {
                            continue block11;
                        }
                        case '[': {
                            ++n3;
                            block12: for (n2 = n4 + 1; n2 < ((String)object3).length() && n3 != 0; ++n2) {
                                c2 = ((String)object3).charAt(n2);
                                switch (c2) {
                                    case '\\': {
                                        ++n2;
                                        continue block12;
                                    }
                                    case '[': {
                                        ++n3;
                                        continue block12;
                                    }
                                    case ']': {
                                        --n3;
                                    }
                                }
                            }
                            if (this.expressions.get(((String)object3).substring(n4, n2)) == null) {
                                this.expressions.put(((String)object3).substring(n4, n2), CharSet.parseString(((String)object3).substring(n4, n2)));
                            }
                            n4 = n2 - 1;
                            continue block11;
                        }
                        case '\\': {
                            c2 = ((String)object3).charAt(++n4);
                        }
                        default: {
                            this.expressions.put(((String)object3).substring(n4, n4 + 1), CharSet.parseString(((String)object3).substring(n4, n4 + 1)));
                        }
                    }
                }
            }
            CharSet.releaseExpressionCache();
            this.categories = new Vector();
            if (this.ignoreChars != null) {
                this.categories.addElement(this.ignoreChars);
            } else {
                this.categories.addElement(new CharSet());
            }
            this.ignoreChars = null;
            this.mungeExpressionList(this.expressions);
            object3 = this.expressions.elements();
            while (object3.hasMoreElements()) {
                CharSet charSet2 = (CharSet)object3.nextElement();
                for (n2 = this.categories.size() - 1; !charSet2.empty() && n2 > 0; --n2) {
                    object2 = (CharSet)this.categories.elementAt(n2);
                    if (((CharSet)object2).intersection(charSet2).empty()) continue;
                    charSet = ((CharSet)object2).difference(charSet2);
                    if (!charSet.empty()) {
                        this.categories.addElement(charSet);
                    }
                    charSet = charSet2.intersection((CharSet)object2);
                    charSet2 = charSet2.difference((CharSet)object2);
                    if (charSet.equals(object2)) continue;
                    this.categories.setElementAt(charSet, n2);
                }
                if (charSet2.empty()) continue;
                this.categories.addElement(charSet2);
            }
            CharSet charSet3 = new CharSet();
            for (n2 = 1; n2 < this.categories.size(); ++n2) {
                charSet3 = charSet3.union((CharSet)this.categories.elementAt(n2));
            }
            CharSet charSet4 = (CharSet)this.categories.elementAt(0);
            charSet4 = charSet4.difference(charSet3);
            this.categories.setElementAt(charSet4, 0);
            object3 = this.expressions.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                charSet = (CharSet)this.expressions.get(object2);
                object = new StringBuffer();
                for (int i3 = 0; i3 < this.categories.size(); ++i3) {
                    CharSet charSet5 = charSet.intersection((CharSet)this.categories.elementAt(i3));
                    if (charSet5.empty()) continue;
                    ((StringBuffer)object).append((char)(256 + i3));
                    if (charSet5.equals(charSet)) break;
                }
                this.expressions.put(object2, ((StringBuffer)object).toString());
            }
            RuleBasedBreakIterator.this.charCategoryTable = new CompactByteArray(0);
            for (int i4 = 0; i4 < this.categories.size(); ++i4) {
                charSet = (CharSet)this.categories.elementAt(i4);
                object = charSet.getChars();
                while (object.hasMoreElements()) {
                    char[] cArray = (char[])object.nextElement();
                    if (i4 != 0) {
                        RuleBasedBreakIterator.this.charCategoryTable.setElementAt(cArray[0], cArray[1], (byte)i4);
                        continue;
                    }
                    RuleBasedBreakIterator.this.charCategoryTable.setElementAt(cArray[0], cArray[1], (byte)-1);
                }
            }
            RuleBasedBreakIterator.this.charCategoryTable.compact();
            RuleBasedBreakIterator.this.numCategories = this.categories.size();
        }

        private void buildStateTable(Vector vector) {
            this.tempStateTable = new Vector();
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                String string = (String)vector.elementAt(i2);
                if (string.charAt(0) == '!') continue;
                this.parseRule(string, true);
            }
            this.finishBuildingStateTable(true);
        }

        protected void error(String string, int n2, String string2) {
            throw new IllegalArgumentException("Parse error at position (" + n2 + "): " + string + "\n" + string2.substring(0, n2) + " -here- " + string2.substring(n2));
        }

        private void updateStateTable(Vector vector, String string, short s2) {
            int n2;
            short[] sArray = new short[RuleBasedBreakIterator.this.numCategories + 1];
            for (n2 = 0; n2 < string.length(); ++n2) {
                sArray[string.charAt((int)n2) - 256] = s2;
            }
            for (n2 = 0; n2 < vector.size(); ++n2) {
                this.mergeStates((Integer)vector.elementAt(n2), sArray, vector);
            }
        }

        private Vector buildRuleList(String string) {
            Vector vector = new Vector();
            Stack stack = new Stack();
            int n2 = 0;
            int n3 = 0;
            char c2 = '\u0000';
            int n4 = 0;
            int n5 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (string.length() != 0 && string.charAt(string.length() - 1) != ';') {
                string = string + ";";
            }
            while (n2 < string.length()) {
                c2 = string.charAt(n2);
                switch (c2) {
                    case '\\': {
                        ++n2;
                        break;
                    }
                    case '(': 
                    case '<': 
                    case '[': 
                    case '{': {
                        if (n5 == 60) {
                            this.error("Can't nest brackets inside <>", n2, string);
                        }
                        if (n5 == 91 && c2 != '[') {
                            this.error("Can't nest anything in [] but []", n2, string);
                        }
                        if (c2 == '<' && (bl2 || bl3)) {
                            this.error("Unknown variable name", n2, string);
                        }
                        n5 = c2;
                        stack.push(new Character(c2));
                        if (c2 != '<') break;
                        bl4 = true;
                        break;
                    }
                    case ')': 
                    case '>': 
                    case ']': 
                    case '}': {
                        char c3 = '\u0000';
                        switch (n5) {
                            case 123: {
                                c3 = '}';
                                break;
                            }
                            case 91: {
                                c3 = ']';
                                break;
                            }
                            case 40: {
                                c3 = ')';
                                break;
                            }
                            case 60: {
                                c3 = '>';
                            }
                        }
                        if (c2 != c3) {
                            this.error("Unbalanced parentheses", n2, string);
                        }
                        if (n4 == n5) {
                            this.error("Parens don't contain anything", n2, string);
                        }
                        stack.pop();
                        if (!stack.empty()) {
                            n5 = ((Character)stack.peek()).charValue();
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    case '*': {
                        if ("=/{(|}*;\u0000".indexOf(n4) == -1) break;
                        this.error("Misplaced asterisk", n2, string);
                        break;
                    }
                    case '?': {
                        if (n4 == 42) break;
                        this.error("Misplaced ?", n2, string);
                        break;
                    }
                    case '=': {
                        if (bl2 || bl3) {
                            this.error("More than one = or / in rule", n2, string);
                        }
                        bl2 = true;
                        break;
                    }
                    case '/': {
                        if (bl2 || bl3) {
                            this.error("More than one = or / in rule", n2, string);
                        }
                        if (bl4) {
                            this.error("Unknown variable name", n2, string);
                        }
                        bl3 = true;
                        break;
                    }
                    case '!': {
                        if (n4 == 59 || n4 == 0) break;
                        this.error("! can only occur at the beginning of a rule", n2, string);
                        break;
                    }
                    case '.': {
                        break;
                    }
                    case '-': 
                    case ':': 
                    case '^': {
                        if (n5 == 91 || n5 == 60) break;
                        this.error("Illegal character", n2, string);
                        break;
                    }
                    case ';': {
                        if (n4 == 59 || n4 == 0) {
                            this.error("Empty rule", n2, string);
                        }
                        if (!stack.empty()) {
                            this.error("Unbalanced parenheses", n2, string);
                        }
                        if (!stack.empty()) break;
                        if (bl2) {
                            string = this.processSubstitution(string.substring(n3, n2), string, n2 + 1);
                        } else {
                            if (bl4) {
                                this.error("Unknown variable name", n2, string);
                            }
                            vector.addElement(string.substring(n3, n2));
                        }
                        n3 = n2 + 1;
                        bl4 = false;
                        bl3 = false;
                        bl2 = false;
                        break;
                    }
                    case '|': {
                        if (n4 == 124) {
                            this.error("Empty alternative", n2, string);
                        }
                        if (!stack.empty() && n5 == 40) break;
                        this.error("Misplaced |", n2, string);
                        break;
                    }
                    default: {
                        if (c2 < ' ' || c2 >= '\u007f' || Character.isLetter(c2) || Character.isDigit(c2)) break;
                        this.error("Illegal character", n2, string);
                    }
                }
                n4 = c2;
                ++n2;
            }
            if (vector.size() == 0) {
                this.error("No valid rules in description", n2, string);
            }
            return vector;
        }

        private void setLoopingStates(Vector vector, Vector vector2) {
            if (!this.loopingStates.isEmpty()) {
                int n2;
                int n3 = (Integer)this.loopingStates.lastElement();
                for (n2 = 0; n2 < vector2.size(); ++n2) {
                    this.eliminateBackfillStates((Integer)vector2.elementAt(n2));
                }
                for (n2 = 0; n2 < this.statesToBackfill.size(); ++n2) {
                    int n4 = (Integer)this.statesToBackfill.elementAt(n2);
                    short[] sArray = (short[])this.tempStateTable.elementAt(n4);
                    sArray[((RuleBasedBreakIterator)RuleBasedBreakIterator.this).numCategories] = (short)(sArray[RuleBasedBreakIterator.this.numCategories] & 0xE000 | n3);
                }
                this.statesToBackfill.removeAllElements();
                this.loopingStates.removeAllElements();
            }
            if (vector != null) {
                this.loopingStates = (Vector)vector.clone();
            }
        }

        protected String processSubstitution(String string, String string2, int n2) {
            int n3 = string.indexOf(61);
            String string3 = string.substring(0, n3);
            String string4 = string.substring(n3 + 1);
            this.handleSpecialSubstitution(string3, string4, n2, string2);
            if (string4.length() == 0) {
                this.error("Nothing on right-hand side of =", n2, string2);
            }
            if (string3.length() == 0) {
                this.error("Nothing on left-hand side of =", n2, string2);
            }
            if (string3.length() == 2 && string3.charAt(0) != '\\') {
                this.error("Illegal left-hand side for =", n2, string2);
            }
            if (string3.length() >= 3 && string3.charAt(0) != '<' && string3.charAt(n3 - 1) != '>') {
                this.error("Illegal left-hand side for =", n2, string2);
            }
            if (!(string4.charAt(0) == '[' && string4.charAt(string4.length() - 1) == ']' || string4.charAt(0) == '(' && string4.charAt(string4.length() - 1) == ')')) {
                this.error("Illegal right-hand side for =", n2, string2);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2.substring(0, n2));
            int n4 = n2;
            int n5 = string2.indexOf(string3, n2);
            while (n5 != -1) {
                stringBuffer.append(string2.substring(n4, n5));
                stringBuffer.append(string4);
                n4 = n5 + string3.length();
                n5 = string2.indexOf(string3, n4);
            }
            stringBuffer.append(string2.substring(n4));
            return stringBuffer.toString();
        }

        protected void handleSpecialSubstitution(String string, String string2, int n2, String string3) {
            if (string.equals("<ignore>")) {
                if (string2.charAt(0) == '(') {
                    this.error("Ignore group can't be enclosed in (", n2, string3);
                }
                this.ignoreChars = CharSet.parseString(string2);
            }
        }
    }

    private static final class SafeCharIterator
    implements CharacterIterator,
    Cloneable {
        private CharacterIterator base;
        private int rangeStart;
        private int rangeLimit;
        private int currentIndex;

        public char current() {
            if (this.currentIndex < this.rangeStart || this.currentIndex >= this.rangeLimit) {
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char first() {
            return this.setIndex(this.rangeStart);
        }

        public char last() {
            return this.setIndex(this.rangeLimit - 1);
        }

        public char next() {
            ++this.currentIndex;
            if (this.currentIndex >= this.rangeLimit) {
                this.currentIndex = this.rangeLimit;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char previous() {
            --this.currentIndex;
            if (this.currentIndex < this.rangeStart) {
                this.currentIndex = this.rangeStart;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public int getBeginIndex() {
            return this.rangeStart;
        }

        public int getEndIndex() {
            return this.rangeLimit;
        }

        public int getIndex() {
            return this.currentIndex;
        }

        public char setIndex(int n2) {
            if (n2 < this.rangeStart || n2 > this.rangeLimit) {
                throw new IllegalArgumentException("Invalid position");
            }
            this.currentIndex = n2;
            return this.current();
        }

        public Object clone() {
            CharacterIterator characterIterator;
            SafeCharIterator safeCharIterator = null;
            try {
                safeCharIterator = (SafeCharIterator)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("Clone not supported: " + cloneNotSupportedException);
            }
            safeCharIterator.base = characterIterator = (CharacterIterator)this.base.clone();
            return safeCharIterator;
        }

        SafeCharIterator(CharacterIterator characterIterator) {
            this.base = characterIterator;
            this.rangeStart = characterIterator.getBeginIndex();
            this.rangeLimit = characterIterator.getEndIndex();
            this.currentIndex = characterIterator.getIndex();
        }
    }
}

