/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapReferralContext;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.ldap.Control;

public final class LdapReferralException
extends javax.naming.ldap.LdapReferralException {
    private int handleReferrals;
    private Hashtable envprops;
    private String nextName;
    private Control[] reqCtls;
    private Vector referrals = null;
    private int referralIndex = 0;
    private int referralCount = 0;
    private boolean foundEntry = false;
    private boolean skipThisReferral = false;
    private int hopCount = 1;
    private NamingException errorEx = null;
    private String newRdn = null;
    private boolean debug = false;
    LdapReferralException nextReferralEx = null;

    void dump() {
        System.out.println();
        System.out.println("LdapReferralException.dump");
        LdapReferralException ldapReferralException = this;
        while (ldapReferralException != null) {
            ldapReferralException.dumpState();
            ldapReferralException = ldapReferralException.nextReferralEx;
        }
    }

    private void dumpState() {
        System.out.println("LdapReferralException.dumpState");
        System.out.println("  hashCode=" + this.hashCode());
        System.out.println("  foundEntry=" + this.foundEntry);
        System.out.println("  skipThisReferral=" + this.skipThisReferral);
        System.out.println("  referralIndex=" + this.referralIndex);
        if (this.referrals != null) {
            System.out.println("  referrals:");
            for (int i2 = 0; i2 < this.referralCount; ++i2) {
                System.out.println("    [" + i2 + "] " + this.referrals.elementAt(i2));
            }
        } else {
            System.out.println("  referrals=null");
        }
        System.out.println("  errorEx=" + this.errorEx);
        if (this.nextReferralEx == null) {
            System.out.println("  nextRefEx=null");
        } else {
            System.out.println("  nextRefEx=" + this.nextReferralEx.hashCode());
        }
        System.out.println();
    }

    public void retryReferral() {
        if (this.debug) {
            System.out.println("LdapReferralException.retryReferral");
        }
        if (this.referralIndex > 0) {
            --this.referralIndex;
        }
    }

    boolean hasMoreReferralExceptions() {
        if (this.debug) {
            System.out.println("LdapReferralException.hasMoreReferralExceptions");
        }
        return this.nextReferralEx != null;
    }

    boolean hasMoreReferrals() {
        if (this.debug) {
            System.out.println("LdapReferralException.hasMoreReferrals");
        }
        return !this.foundEntry && this.referralIndex < this.referralCount;
    }

    public boolean skipReferral() {
        if (this.debug) {
            System.out.println("LdapReferralException.skipReferral");
        }
        this.skipThisReferral = true;
        try {
            this.getNextReferral();
        }
        catch (ReferralException referralException) {
            // empty catch block
        }
        return this.hasMoreReferrals() || this.hasMoreReferralExceptions();
    }

    void setHopCount(int n2) {
        if (this.debug) {
            System.out.println("LdapReferralException.setHopCount");
        }
        this.hopCount = n2;
    }

    void setNameResolved(boolean bl2) {
        if (this.debug) {
            System.out.println("LdapReferralException.setNameResolved");
        }
        this.foundEntry = bl2;
    }

    public Object getReferralInfo() {
        if (this.debug) {
            System.out.println("LdapReferralException.getReferralInfo");
            System.out.println("  referralIndex=" + this.referralIndex);
        }
        if (this.hasMoreReferrals()) {
            return this.referrals.elementAt(this.referralIndex);
        }
        return null;
    }

    String getNewRdn() {
        if (this.debug) {
            System.out.println("LdapReferralException.getNewRdn");
        }
        return this.newRdn;
    }

    String getNextReferral() throws ReferralException {
        if (this.debug) {
            System.out.println("LdapReferralException.getNextReferral");
        }
        if (this.hasMoreReferrals()) {
            return (String)this.referrals.elementAt(this.referralIndex++);
        }
        if (this.hasMoreReferralExceptions()) {
            throw this.nextReferralEx;
        }
        return null;
    }

    void setNewRdn(String string) {
        if (this.debug) {
            System.out.println("LdapReferralException.setNewRdn");
        }
        this.newRdn = string;
    }

    void setReferralInfo(Vector vector, boolean bl2) {
        if (this.debug) {
            System.out.println("LdapReferralException.setReferralInfo");
        }
        this.referrals = vector;
        if (vector != null) {
            this.referralCount = vector.size();
        }
        if (this.debug) {
            for (int i2 = 0; i2 < this.referralCount; ++i2) {
                System.out.println("  [" + i2 + "] " + vector.elementAt(i2));
            }
        }
    }

    public Context getReferralContext() throws NamingException {
        return this.getReferralContext(this.envprops, null);
    }

    NamingException getNamingException() {
        if (this.debug) {
            System.out.println("LdapReferralException.getNamingException");
        }
        return this.errorEx;
    }

    void setNamingException(NamingException namingException) {
        if (this.debug) {
            System.out.println("LdapReferralException.setNamingException");
        }
        if (this.errorEx == null) {
            namingException.setRootCause(this);
            this.errorEx = namingException;
        }
    }

    LdapReferralException appendUnprocessedReferrals(LdapReferralException ldapReferralException) {
        LdapReferralException ldapReferralException2;
        if (this.debug) {
            System.out.println("LdapReferralException.appendUnprocessedReferrals");
            this.dump();
            if (ldapReferralException != null) {
                ldapReferralException.dump();
            }
        }
        if (!(ldapReferralException2 = this).hasMoreReferrals()) {
            ldapReferralException2 = this.nextReferralEx;
            if (this.errorEx != null && ldapReferralException2 != null) {
                ldapReferralException2.setNamingException(this.errorEx);
            }
        }
        if (this == ldapReferralException) {
            return ldapReferralException2;
        }
        if (ldapReferralException != null && !ldapReferralException.hasMoreReferrals()) {
            ldapReferralException = ldapReferralException.nextReferralEx;
        }
        if (ldapReferralException == null) {
            return ldapReferralException2;
        }
        LdapReferralException ldapReferralException3 = ldapReferralException2;
        while (ldapReferralException3.nextReferralEx != null) {
            ldapReferralException3 = ldapReferralException3.nextReferralEx;
        }
        ldapReferralException3.nextReferralEx = ldapReferralException;
        return ldapReferralException2;
    }

    public Context getReferralContext(Hashtable hashtable) throws NamingException {
        return this.getReferralContext(hashtable, null);
    }

    public Context getReferralContext(Hashtable hashtable, Control[] controlArray) throws NamingException {
        if (this.debug) {
            System.out.println("LdapReferralException.getReferralContext");
        }
        LdapReferralContext ldapReferralContext = new LdapReferralContext(this, hashtable, controlArray, this.reqCtls, this.nextName, this.skipThisReferral, this.handleReferrals);
        ldapReferralContext.setHopCount(this.hopCount + 1);
        if (this.skipThisReferral) {
            this.skipThisReferral = false;
        }
        return ldapReferralContext;
    }

    LdapReferralException(Name name, Object object, Name name2, String string, Hashtable hashtable, String string2, int n2, Control[] controlArray) {
        super(string);
        if (this.debug) {
            System.out.println("LdapReferralException constructor");
        }
        this.setResolvedName(name);
        this.setResolvedObj(object);
        this.setRemainingName(name2);
        this.envprops = hashtable;
        this.nextName = string2;
        this.handleReferrals = n2;
        this.reqCtls = n2 == 1 ? controlArray : null;
    }
}

