/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.ccache.a1;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PrincipalName
implements Cloneable {
    public static final int KRB_NT_UNKNOWN = 0;
    public static final int KRB_NT_PRINCIPAL = 1;
    public static final int KRB_NT_SRV_INST = 2;
    public static final int KRB_NT_SRV_HST = 3;
    public static final int KRB_NT_SRV_XHST = 4;
    public static final int KRB_NT_UID = 5;
    public static final String TGS_DEFAULT_SRV_NAME = "krbtgt";
    public static final int TGS_DEFAULT_NT = 2;
    public static final char NAME_COMPONENT_SEPARATOR = '/';
    public static final char NAME_REALM_SEPARATOR = '@';
    public static final char REALM_COMPONENT_SEPARATOR = '.';
    public static final String NAME_COMPONENT_SEPARATOR_STR = "/";
    public static final String NAME_REALM_SEPARATOR_STR = "@";
    public static final String REALM_COMPONENT_SEPARATOR_STR = ".";
    private int a;
    private String[] b;
    private Realm c;

    public int getNameType() {
        return this.a;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected PrincipalName() {
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        BigInteger bigInteger = BigInteger.valueOf(this.a);
        derOutputStream2.putInteger(bigInteger);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        DerValue[] derValueArray = new DerValue[this.b.length];
        int n2 = 0;
        while (n2 < this.b.length) {
            derValueArray[n2] = new DerValue(27, this.b[n2]);
            ++n2;
        }
        derOutputStream2.putSequence(derValueArray);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public byte[][] toByteArray() {
        byte[][] byArrayArray = new byte[this.b.length][];
        int n2 = 0;
        while (n2 < this.b.length) {
            byArrayArray[n2] = new byte[this.b[n2].length()];
            byArrayArray[n2] = this.b[n2].getBytes();
            ++n2;
        }
        return byArrayArray;
    }

    public Object clone() {
        PrincipalName principalName = new PrincipalName();
        principalName.a = this.a;
        if (this.b != null) {
            principalName.b = new String[this.b.length];
            System.arraycopy(this.b, 0, principalName.b, 0, this.b.length);
        }
        if (this.c != null) {
            principalName.c = (Realm)this.c.clone();
        }
        return principalName;
    }

    public boolean equals(Object object) {
        if (object instanceof PrincipalName) {
            return this.equals((PrincipalName)object);
        }
        return false;
    }

    public String getInstanceComponent() {
        if (this.b != null && this.b.length >= 2) {
            return new String(this.b[1]);
        }
        return null;
    }

    public String getName() {
        return this.toString();
    }

    public String getNameString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.b.length) {
            if (n2 > 0) {
                stringBuffer.append(NAME_COMPONENT_SEPARATOR_STR);
            }
            stringBuffer.append(this.b[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getPrincipalNameAsString() {
        StringBuffer stringBuffer = new StringBuffer(this.b[0]);
        int n2 = 1;
        while (n2 < this.b.length) {
            stringBuffer.append(this.b[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getRealmAsString() {
        return this.getRealmString();
    }

    public String getRealmString() {
        if (this.c != null) {
            return this.c.toString();
        }
        return null;
    }

    public String getSalt() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.c != null) {
            stringBuffer.append(this.c.toString());
        }
        int n2 = 0;
        while (n2 < this.b.length) {
            stringBuffer.append(this.b[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.b.length) {
            if (n2 > 0) {
                stringBuffer.append(NAME_COMPONENT_SEPARATOR_STR);
            }
            stringBuffer.append(this.b[n2]);
            ++n2;
        }
        if (this.c != null) {
            stringBuffer.append(NAME_REALM_SEPARATOR_STR);
            stringBuffer.append(this.c.toString());
        }
        return stringBuffer.toString();
    }

    public String[] getNameStrings() {
        return this.b;
    }

    public PrincipalName(String string) throws RealmException {
        this(string, 0);
    }

    public void setRealm(String string) throws RealmException {
        this.c = new Realm(string);
    }

    public static void test(String string) throws RealmException {
        System.out.println("name='" + string + "'");
        PrincipalName principalName = new PrincipalName(string);
        String[] stringArray = principalName.getNameStrings();
        int n2 = 0;
        while (n2 < stringArray.length) {
            System.out.println("part[" + n2 + "]='" + stringArray[n2] + "'");
            ++n2;
        }
        System.out.println("realm='" + principalName.getRealmString() + "'");
        System.out.println();
    }

    public PrincipalName(String string, int n2) throws RealmException {
        Object object;
        if (string == null) {
            throw new IllegalArgumentException("Null name not allowed");
        }
        String[] stringArray = PrincipalName.parseName(string);
        Realm realm = null;
        String string2 = Realm.parseRealmAtSeparator(string);
        if (string2 == null) {
            try {
                object = Config.getInstance();
                string2 = ((Config)object).getDefaultRealm();
            }
            catch (KrbException krbException) {
                RealmException realmException = new RealmException(krbException.getMessage());
                realmException.initCause(krbException);
                throw realmException;
            }
        }
        if (string2 != null) {
            realm = new Realm(string2);
        }
        switch (n2) {
            case 3: {
                if (stringArray.length >= 2) {
                    try {
                        object = InetAddress.getByName(stringArray[1]).getCanonicalHostName();
                        stringArray[1] = ((String)object).toLowerCase();
                    }
                    catch (UnknownHostException unknownHostException) {
                        stringArray[1] = stringArray[1].toLowerCase();
                    }
                }
                this.b = stringArray;
                this.a = n2;
                object = PrincipalName.a(stringArray[1]);
                if (object != null) {
                    this.c = new Realm((String)object);
                    break;
                }
                this.c = realm;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                this.b = stringArray;
                this.a = n2;
                this.c = realm;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal name type");
            }
        }
    }

    public PrincipalName(String[] stringArray) throws IOException {
        this(stringArray, 0);
    }

    public PrincipalName(String[] stringArray, int n2) throws IllegalArgumentException, IOException {
        if (stringArray == null) {
            throw new IllegalArgumentException("Null input not allowed");
        }
        this.b = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.b, 0, stringArray.length);
        this.a = n2;
        this.c = null;
    }

    boolean a(PrincipalName principalName) {
        if (this.a != 0 && principalName.a != 0 && this.a != principalName.a) {
            return false;
        }
        if (this.b != null && principalName.b == null || this.b == null && principalName.b != null) {
            return false;
        }
        if (this.b != null && principalName.b != null) {
            if (this.b.length != principalName.b.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.b.length) {
                if (!this.b[n2].equals(principalName.b[n2])) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public boolean equals(PrincipalName principalName) {
        if (!this.a(principalName)) {
            return false;
        }
        if (this.c != null && principalName.c == null || this.c == null && principalName.c != null) {
            return false;
        }
        return this.c == null || principalName.c == null || this.c.equals(principalName.c);
    }

    public boolean match(PrincipalName principalName) {
        boolean bl2 = true;
        if (this.c != null && principalName.c != null && !this.c.toString().equalsIgnoreCase(principalName.c.toString())) {
            bl2 = false;
        }
        if (this.b.length != principalName.b.length) {
            bl2 = false;
        } else {
            int n2 = 0;
            while (n2 < this.b.length) {
                if (!this.b[n2].equalsIgnoreCase(principalName.b[n2])) {
                    bl2 = false;
                }
                ++n2;
            }
        }
        return bl2;
    }

    public Realm getRealm() {
        return this.c;
    }

    public void setRealm(Realm realm) throws RealmException {
        this.c = realm;
    }

    public void writePrincipal(a1 a12) throws IOException {
        byte[] byArray;
        a12.a(this.a);
        a12.a(this.b.length);
        if (this.c != null) {
            byArray = null;
            byArray = this.c.toString().getBytes();
            a12.a(byArray.length);
            a12.write(byArray, 0, byArray.length);
        }
        byArray = null;
        int n2 = 0;
        while (n2 < this.b.length) {
            byArray = this.b[n2].getBytes();
            a12.a(byArray.length);
            a12.write(byArray, 0, byArray.length);
            ++n2;
        }
    }

    public PrincipalName(DerValue derValue) throws Asn1Exception, IOException {
        this.c = null;
        if (derValue == null) {
            throw new IllegalArgumentException("Null input not allowed");
        }
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        Object object = derValue2.getData().getBigInteger();
        this.a = ((BigInteger)object).intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) == 1) {
            object = derValue2.getData().getDerValue();
            if (((DerValue)object).getTag() != 48) {
                throw new Asn1Exception(906);
            }
            Vector vector = new Vector();
            while (((DerValue)object).getData().available() > 0) {
                DerValue derValue3 = ((DerValue)object).getData().getDerValue();
                vector.addElement(derValue3.getGeneralString());
            }
            if (vector.size() > 0) {
                this.b = new String[vector.size()];
                vector.copyInto(this.b);
            } else {
                this.b = new String[]{""};
            }
        } else {
            throw new Asn1Exception(906);
        }
    }

    static String a(String string) {
        String string2 = null;
        try {
            String string3 = null;
            Config config = Config.getInstance();
            string2 = config.getDefault(string, "domain_realm");
            if (string2 != null) {
                return string2;
            }
            int n2 = 1;
            while (n2 < string.length()) {
                if (string.charAt(n2) != '.' || n2 == string.length() - 1 || (string2 = config.getDefault(string3 = string.substring(n2), "domain_realm")) == null && (string2 = config.getDefault(string3 = string.substring(n2 + 1), "domain_realm")) == null) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (KrbException krbException) {}
        return string2;
    }

    protected static String[] parseName(String string) {
        String string2;
        Vector vector = new Vector();
        String string3 = string;
        int n2 = 0;
        int n3 = 0;
        while (n2 < string3.length()) {
            if (string3.charAt(n2) == '/') {
                if (n2 > 0 && string3.charAt(n2 - 1) == '\\') {
                    string3 = string3.substring(0, n2 - 1) + string3.substring(n2, string3.length());
                    continue;
                }
                if (n3 < n2) {
                    string2 = string3.substring(n3, n2);
                    vector.addElement(string2);
                }
                n3 = n2 + 1;
            } else if (string3.charAt(n2) == '@') {
                if (n2 > 0 && string3.charAt(n2 - 1) == '\\') {
                    string3 = string3.substring(0, n2 - 1) + string3.substring(n2, string3.length());
                    continue;
                }
                if (n3 < n2) {
                    string2 = string3.substring(n3, n2);
                    vector.addElement(string2);
                }
                n3 = n2 + 1;
                break;
            }
            ++n2;
        }
        if (n2 == string3.length() && n3 < n2) {
            string2 = string3.substring(n3, n2);
            vector.addElement(string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public PrincipalName(String string, String string2) throws RealmException {
        this(string, 0);
        this.c = new Realm(string2);
    }

    public static PrincipalName parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new PrincipalName(derValue2);
    }

    protected PrincipalName(String string, String string2, String string3, int n2) throws KrbException {
        if (n2 != 2) {
            throw new KrbException(60, "Bad name type");
        }
        String[] stringArray = new String[]{string, string2};
        this.b = stringArray;
        this.c = new Realm(string3);
        this.a = n2;
    }
}

