/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class LogRecord
implements Serializable {
    private static long globalSequenceNumber;
    private static int nextThreadId;
    private static ThreadLocal threadIds;
    private Level level;
    private long sequenceNumber;
    private String sourceClassName;
    private String sourceMethodName;
    private String message;
    private int threadID;
    private long millis;
    private Throwable thrown;
    private String loggerName;
    private String resourceBundleName;
    private transient boolean needToInferCaller;
    private transient Object[] parameters;
    private transient ResourceBundle resourceBundle;

    public int getThreadID() {
        return this.threadID;
    }

    public long getMillis() {
        return this.millis;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    static {
        nextThreadId = 10;
        threadIds = new ThreadLocal();
    }

    private void inferCaller() {
        StackTraceElement stackTraceElement;
        String string;
        int n2;
        this.needToInferCaller = false;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        for (n2 = 0; n2 < stackTraceElementArray.length && !(string = (stackTraceElement = stackTraceElementArray[n2]).getClassName()).equals("java.util.logging.Logger"); ++n2) {
        }
        while (n2 < stackTraceElementArray.length) {
            stackTraceElement = stackTraceElementArray[n2];
            string = stackTraceElement.getClassName();
            if (!string.equals("java.util.logging.Logger")) {
                this.setSourceClassName(string);
                this.setSourceMethodName(stackTraceElement.getMethodName());
                return;
            }
            ++n2;
        }
    }

    public void setThreadID(int n2) {
        this.threadID = n2;
    }

    public void setMillis(long l2) {
        this.millis = l2;
    }

    public void setSequenceNumber(long l2) {
        this.sequenceNumber = l2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte by = objectInputStream.readByte();
        byte by2 = objectInputStream.readByte();
        if (by != 1) {
            throw new IOException("LogRecord: bad version: " + by + "." + by2);
        }
        int n2 = objectInputStream.readInt();
        if (n2 == -1) {
            this.parameters = null;
        } else {
            this.parameters = new Object[n2];
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                this.parameters[i2] = objectInputStream.readObject();
            }
        }
        if (this.resourceBundleName != null) {
            try {
                this.resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
            }
            catch (MissingResourceException missingResourceException) {
                this.resourceBundle = null;
            }
        }
        this.needToInferCaller = false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeByte(1);
        objectOutputStream.writeByte(0);
        if (this.parameters == null) {
            objectOutputStream.writeInt(-1);
            return;
        }
        objectOutputStream.writeInt(this.parameters.length);
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            if (this.parameters[i2] == null) {
                objectOutputStream.writeObject(null);
                continue;
            }
            objectOutputStream.writeObject(this.parameters[i2].toString());
        }
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] objectArray) {
        this.parameters = objectArray;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getSourceClassName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return this.sourceClassName;
    }

    public String getSourceMethodName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return this.sourceMethodName;
    }

    public void setLoggerName(String string) {
        this.loggerName = string;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setResourceBundleName(String string) {
        this.resourceBundleName = string;
    }

    public void setSourceClassName(String string) {
        this.sourceClassName = string;
        this.needToInferCaller = false;
    }

    public void setSourceMethodName(String string) {
        this.sourceMethodName = string;
        this.needToInferCaller = false;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable throwable) {
        this.thrown = throwable;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException();
        }
        this.level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord(Level level, String string) {
        level.getClass();
        this.level = level;
        this.message = string;
        Class clazz = LogRecord.class;
        synchronized (clazz) {
            this.sequenceNumber = globalSequenceNumber++;
            Integer n2 = (Integer)threadIds.get();
            if (n2 == null) {
                n2 = new Integer(nextThreadId++);
                threadIds.set(n2);
            }
            this.threadID = n2;
        }
        this.millis = System.currentTimeMillis();
        this.needToInferCaller = true;
    }
}

