/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import sun.plugin.AppletViewer;
import sun.plugin.util.Trace;

public class Steamer
implements ActionListener {
    private Timer ticker;
    private static final int NUMBER_OF_IMAGES = 1;
    private static final String img_base = "sun/plugin/util/cup";
    private static final String broken_image = "sun/plugin/util/graybox_broken.gif";
    private static Image[] cups = new Image[1];
    private static Image broken_graybox_image = null;
    private String custom_image_file = null;
    private Image custom_image;
    private int current_image_number = 0;
    private URL codebase;
    private boolean applet_error = false;
    private int X_coordinate = 6;
    private int Y_coordinate = 6;
    AppletViewer av;
    private static MediaTracker tracker;
    private static boolean init;

    static {
        init = false;
    }

    public void destroy() {
        this.stopTimer();
    }

    public void error() {
        this.applet_error = true;
        this.X_coordinate = 6;
        this.Y_coordinate = 6;
        this.custom_image = null;
    }

    public void init() {
        tracker = new MediaTracker((Component)((Object)this.av));
        this.loadDefaultImages();
        if (this.custom_image_file != null) {
            this.loadCustomImage();
        } else {
            this.startTimer();
        }
    }

    private void loadCustomImage() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (Steamer.this.custom_image_file != null) {
                        URL uRL = new URL(Steamer.this.codebase, Steamer.this.custom_image_file);
                        Steamer.this.custom_image = Toolkit.getDefaultToolkit().getImage(uRL);
                        tracker.addImage(Steamer.this.custom_image, 1);
                        Steamer.this.X_coordinate = 0;
                        Steamer.this.Y_coordinate = 0;
                        try {
                            tracker.waitForID(1);
                            Steamer.this.av.repaint();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.msgPrintln("image_failed");
                }
            }
        };
        Thread thread = new Thread(runnable, "Custom Image Loader");
        thread.start();
    }

    private void loadDefaultImages() {
        if (init) {
            return;
        }
        init = true;
        this.loadFirstImage();
        Steamer.loadOtherImages();
    }

    private void loadFirstImage() {
        if (cups[0] == null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    cups[0] = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("sun/plugin/util/cup1.gif"));
                    tracker.addImage(cups[0], 2);
                    try {
                        tracker.waitForID(2);
                        Steamer.this.av.repaint();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            Thread thread = new Thread(runnable, "Default Image Loader");
            thread.start();
        }
    }

    private static synchronized void loadOtherImages() {
        Runnable runnable = new Runnable(){

            public void run() {
                for (int i = 1; i < 1; ++i) {
                    String string = Steamer.img_base + (i + 1) + ".gif";
                    cups[i] = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string));
                }
            }
        };
        Thread thread = new Thread(runnable, "Graybox Image Loader");
        thread.start();
    }

    public synchronized void startTimer() {
    }

    public void stop() {
        this.stopTimer();
        this.av.repaint();
    }

    public synchronized void stopTimer() {
    }

    public Image getCurrentImage() {
        if (this.applet_error) {
            this.stopTimer();
            broken_graybox_image = new ImageIcon(ClassLoader.getSystemResource(broken_image)).getImage();
            return broken_graybox_image;
        }
        if (this.custom_image != null) {
            return this.custom_image;
        }
        this.startTimer();
        return this.getCurrentImage(this.current_image_number);
    }

    private Image getCurrentImage(int n) {
        if (n < 0) {
            return null;
        }
        for (int i = n; i >= 0; --i) {
            if (cups[i] == null) continue;
            return cups[i];
        }
        return null;
    }

    public Point getImgCoordinates() {
        return new Point(this.X_coordinate, this.Y_coordinate);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ++this.current_image_number;
        this.current_image_number %= 1;
        this.av.repaint();
    }

    public Steamer(AppletViewer appletViewer) {
        this.av = appletViewer;
    }

    public void setCustomImage(URL uRL, String string) {
        this.X_coordinate = 0;
        this.Y_coordinate = 0;
        this.codebase = uRL;
        this.custom_image_file = string;
    }
}

